/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render.text;

import dan200.computercraft.client.render.text.FixedWidthFontRenderer;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.shared.util.Colour;
import dan200.computercraft.shared.util.Palette;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import org.lwjgl.system.MemoryUtil;

public final class DirectFixedWidthFontRenderer {
    private DirectFixedWidthFontRenderer() {
    }

    private static void drawChar(ByteBuffer buffer, float x, float y, int index, byte[] colour) {
        if (index == 0 || index == 32) {
            return;
        }
        int column = index % 16;
        int row = index / 16;
        int xStart = 1 + column * 8;
        int yStart = 1 + row * 11;
        DirectFixedWidthFontRenderer.quad(buffer, x, y, x + 6.0f, y + 9.0f, colour, (float)xStart / 256.0f, (float)yStart / 256.0f, (float)(xStart + 6) / 256.0f, (float)(yStart + 9) / 256.0f);
    }

    private static void drawQuad(ByteBuffer emitter, float x, float y, float width, float height, Palette palette, boolean greyscale, char colourIndex) {
        byte[] colour = palette.getByteColour(FixedWidthFontRenderer.getColour(colourIndex, Colour.BLACK), greyscale);
        DirectFixedWidthFontRenderer.quad(emitter, x, y, x + width, y + height, colour, 0.9765625f, 0.9765625f, 0.984375f, 0.984375f);
    }

    private static void drawBackground(@Nonnull ByteBuffer buffer, float x, float y, @Nonnull TextBuffer backgroundColour, @Nonnull Palette palette, boolean greyscale, float leftMarginSize, float rightMarginSize, float height) {
        if (leftMarginSize > 0.0f) {
            DirectFixedWidthFontRenderer.drawQuad(buffer, x - leftMarginSize, y, leftMarginSize, height, palette, greyscale, backgroundColour.charAt(0));
        }
        if (rightMarginSize > 0.0f) {
            DirectFixedWidthFontRenderer.drawQuad(buffer, x + (float)(backgroundColour.length() * 6), y, rightMarginSize, height, palette, greyscale, backgroundColour.charAt(backgroundColour.length() - 1));
        }
        int blockStart = 0;
        char blockColour = '\u0000';
        for (int i = 0; i < backgroundColour.length(); ++i) {
            char colourIndex = backgroundColour.charAt(i);
            if (colourIndex == blockColour) continue;
            if (blockColour != '\u0000') {
                DirectFixedWidthFontRenderer.drawQuad(buffer, x + (float)(blockStart * 6), y, 6 * (i - blockStart), height, palette, greyscale, blockColour);
            }
            blockColour = colourIndex;
            blockStart = i;
        }
        if (blockColour != '\u0000') {
            DirectFixedWidthFontRenderer.drawQuad(buffer, x + (float)(blockStart * 6), y, 6 * (backgroundColour.length() - blockStart), height, palette, greyscale, blockColour);
        }
    }

    private static void drawString(@Nonnull ByteBuffer buffer, float x, float y, @Nonnull TextBuffer text, @Nonnull TextBuffer textColour, @Nonnull Palette palette, boolean greyscale) {
        for (int i = 0; i < text.length(); ++i) {
            byte[] colour = palette.getByteColour(FixedWidthFontRenderer.getColour(textColour.charAt(i), Colour.BLACK), greyscale);
            int index = text.charAt(i);
            if (index > 255) {
                index = 63;
            }
            DirectFixedWidthFontRenderer.drawChar(buffer, x + (float)(i * 6), y, index, colour);
        }
    }

    public static void drawTerminalWithoutCursor(@Nonnull ByteBuffer buffer, float x, float y, @Nonnull Terminal terminal, boolean greyscale, float topMarginSize, float bottomMarginSize, float leftMarginSize, float rightMarginSize) {
        Palette palette = terminal.getPalette();
        int height = terminal.getHeight();
        DirectFixedWidthFontRenderer.drawBackground(buffer, x, y - topMarginSize, terminal.getBackgroundColourLine(0), palette, greyscale, leftMarginSize, rightMarginSize, topMarginSize);
        DirectFixedWidthFontRenderer.drawBackground(buffer, x, y + (float)(height * 9), terminal.getBackgroundColourLine(height - 1), palette, greyscale, leftMarginSize, rightMarginSize, bottomMarginSize);
        for (int i = 0; i < height; ++i) {
            float rowY = y + (float)(9 * i);
            DirectFixedWidthFontRenderer.drawBackground(buffer, x, rowY, terminal.getBackgroundColourLine(i), palette, greyscale, leftMarginSize, rightMarginSize, 9.0f);
            DirectFixedWidthFontRenderer.drawString(buffer, x, rowY, terminal.getLine(i), terminal.getTextColourLine(i), palette, greyscale);
        }
    }

    public static void drawCursor(@Nonnull ByteBuffer buffer, float x, float y, @Nonnull Terminal terminal, boolean greyscale) {
        if (FixedWidthFontRenderer.isCursorVisible(terminal)) {
            byte[] colour = terminal.getPalette().getByteColour(15 - terminal.getTextColour(), greyscale);
            DirectFixedWidthFontRenderer.drawChar(buffer, x + (float)(terminal.getCursorX() * 6), y + (float)(terminal.getCursorY() * 9), 95, colour);
        }
    }

    public static int getVertexCount(Terminal terminal) {
        return (1 + (terminal.getHeight() + 2) * terminal.getWidth() * 2) * 4;
    }

    private static void quad(ByteBuffer buffer, float x1, float y1, float x2, float y2, byte[] rgba, float u1, float v1, float u2, float v2) {
        int position = buffer.position();
        long addr = MemoryUtil.memAddress((ByteBuffer)buffer);
        if (position < 0 || 96 > buffer.limit() - position) {
            throw new IndexOutOfBoundsException();
        }
        if ((addr & 3L) != 0L) {
            throw new IllegalStateException("Memory is not aligned");
        }
        if (rgba.length != 4) {
            throw new IllegalStateException();
        }
        MemoryUtil.memPutFloat((long)(addr + 0L), (float)x1);
        MemoryUtil.memPutFloat((long)(addr + 4L), (float)y1);
        MemoryUtil.memPutFloat((long)(addr + 8L), (float)0.0f);
        MemoryUtil.memPutByte((long)(addr + 12L), (byte)rgba[0]);
        MemoryUtil.memPutByte((long)(addr + 13L), (byte)rgba[1]);
        MemoryUtil.memPutByte((long)(addr + 14L), (byte)rgba[2]);
        MemoryUtil.memPutByte((long)(addr + 15L), (byte)-1);
        MemoryUtil.memPutFloat((long)(addr + 16L), (float)u1);
        MemoryUtil.memPutFloat((long)(addr + 20L), (float)v1);
        MemoryUtil.memPutFloat((long)(addr + 24L), (float)x1);
        MemoryUtil.memPutFloat((long)(addr + 28L), (float)y2);
        MemoryUtil.memPutFloat((long)(addr + 32L), (float)0.0f);
        MemoryUtil.memPutByte((long)(addr + 36L), (byte)rgba[0]);
        MemoryUtil.memPutByte((long)(addr + 37L), (byte)rgba[1]);
        MemoryUtil.memPutByte((long)(addr + 38L), (byte)rgba[2]);
        MemoryUtil.memPutByte((long)(addr + 39L), (byte)-1);
        MemoryUtil.memPutFloat((long)(addr + 40L), (float)u1);
        MemoryUtil.memPutFloat((long)(addr + 44L), (float)v2);
        MemoryUtil.memPutFloat((long)(addr + 48L), (float)x2);
        MemoryUtil.memPutFloat((long)(addr + 52L), (float)y2);
        MemoryUtil.memPutFloat((long)(addr + 56L), (float)0.0f);
        MemoryUtil.memPutByte((long)(addr + 60L), (byte)rgba[0]);
        MemoryUtil.memPutByte((long)(addr + 61L), (byte)rgba[1]);
        MemoryUtil.memPutByte((long)(addr + 62L), (byte)rgba[2]);
        MemoryUtil.memPutByte((long)(addr + 63L), (byte)-1);
        MemoryUtil.memPutFloat((long)(addr + 64L), (float)u2);
        MemoryUtil.memPutFloat((long)(addr + 68L), (float)v2);
        MemoryUtil.memPutFloat((long)(addr + 72L), (float)x2);
        MemoryUtil.memPutFloat((long)(addr + 76L), (float)y1);
        MemoryUtil.memPutFloat((long)(addr + 80L), (float)0.0f);
        MemoryUtil.memPutByte((long)(addr + 84L), (byte)rgba[0]);
        MemoryUtil.memPutByte((long)(addr + 85L), (byte)rgba[1]);
        MemoryUtil.memPutByte((long)(addr + 86L), (byte)rgba[2]);
        MemoryUtil.memPutByte((long)(addr + 87L), (byte)-1);
        MemoryUtil.memPutFloat((long)(addr + 88L), (float)u2);
        MemoryUtil.memPutFloat((long)(addr + 92L), (float)v1);
        buffer.position(position + 96);
    }
}

