/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.filesystem;

import dan200.computercraft.api.filesystem.FileAttributes;
import dan200.computercraft.api.filesystem.FileOperationException;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import javax.annotation.Nonnull;

public interface IMount {
    public boolean exists(@Nonnull String var1) throws IOException;

    public boolean isDirectory(@Nonnull String var1) throws IOException;

    public void list(@Nonnull String var1, @Nonnull List<String> var2) throws IOException;

    public long getSize(@Nonnull String var1) throws IOException;

    @Nonnull
    public ReadableByteChannel openForRead(@Nonnull String var1) throws IOException;

    @Nonnull
    default public BasicFileAttributes getAttributes(@Nonnull String path) throws IOException {
        if (!this.exists(path)) {
            throw new FileOperationException(path, "No such file");
        }
        return new FileAttributes(this.isDirectory(path), this.getSize(path));
    }
}

