/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.internal.cobalt.lib.doubles;

import cc.tweaked.internal.cobalt.lib.doubles.Assert;
import cc.tweaked.internal.cobalt.lib.doubles.Bignum;
import cc.tweaked.internal.cobalt.lib.doubles.DecimalRepBuf;
import cc.tweaked.internal.cobalt.lib.doubles.Ieee;
import org.checkerframework.checker.signedness.qual.Signed;
import org.checkerframework.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.checker.signedness.qual.Unsigned;
import org.checkerframework.common.value.qual.UnknownVal;

public class BigNumDtoa {
    private static final @UnknownVal @Signed int ASCII_ZERO = 48;
    private static final @UnknownVal @Signed int ASCII_NINE = 57;

    private static @UnknownVal @Signed int normalizedExponent(@Unsigned @UnknownVal long significand, @UnknownVal @Signed int exponent) {
        if (Assert.assertEnabled()) {
            Assert.assertThat(significand != 0L);
        }
        while ((significand & 0x10000000000000L) == 0L) {
            significand <<= 1;
            --exponent;
        }
        return exponent;
    }

    public static void bignumDtoa(@UnknownVal @Signed double v, @UnknownVal @UnknownSignedness BignumDtoaMode mode, @UnknownVal @Signed int requestedDigits, @UnknownVal @UnknownSignedness DecimalRepBuf buf) {
        if (Assert.assertEnabled()) {
            Assert.assertThat(v > 0.0);
            Assert.assertThat(!new Ieee.Double(v).isSpecial());
        }
        @Unsigned long significand = new Ieee.Double(v).significand();
        int exponent = new Ieee.Double(v).exponent();
        boolean isEven = (significand & 1L) == 0L;
        int normalizedExponent = BigNumDtoa.normalizedExponent(significand, exponent);
        int estimatePower = BigNumDtoa.estimatePower(normalizedExponent);
        if (mode == BignumDtoaMode.FIXED && -estimatePower - 1 > requestedDigits) {
            buf.clearBuf();
            buf.setPointPosition(-requestedDigits);
            return;
        }
        int[] estimatedPoint = new int[1];
        Bignum numerator = new Bignum();
        Bignum denominator = new Bignum();
        Bignum deltaMinus = new Bignum();
        Bignum deltaPlus = new Bignum();
        BigNumDtoa.initialScaledStartValues(significand, exponent, estimatePower, numerator, denominator);
        BigNumDtoa.fixupMultiply10(estimatePower, isEven, estimatedPoint, numerator, denominator, deltaMinus, deltaPlus);
        buf.setPointPosition(estimatedPoint[0]);
        switch (mode) {
            case FIXED: {
                BigNumDtoa.bignumToFixed(requestedDigits, numerator, denominator, buf);
                break;
            }
            case PRECISION: {
                BigNumDtoa.generateCountedDigits(requestedDigits, numerator, denominator, buf);
                break;
            }
            default: {
                throw new IllegalStateException("Unreachable");
            }
        }
    }

    private static void generateCountedDigits(@UnknownVal @Signed int count, @UnknownVal @UnknownSignedness Bignum numerator, @UnknownVal @UnknownSignedness Bignum denominator, @UnknownVal @UnknownSignedness DecimalRepBuf buf) {
        if (Assert.assertEnabled()) {
            Assert.assertThat(count >= 0);
        }
        for (int i = 0; i < count - 1; ++i) {
            @Unsigned int digit = numerator.divideModuloIntBignum(denominator);
            buf.append(digit);
            numerator.times10();
        }
        @Unsigned int digit = numerator.divideModuloIntBignum(denominator);
        buf.append(digit);
        if (Bignum.plusCompare(numerator, numerator, denominator) >= 0) {
            buf.roundUp();
        }
    }

    private static void bignumToFixed(@UnknownVal @Signed int requestedDigits, @UnknownVal @UnknownSignedness Bignum numerator, @UnknownVal @UnknownSignedness Bignum denominator, @UnknownVal @UnknownSignedness DecimalRepBuf buf) {
        int decimalPoint = buf.getPointPosition();
        if (-decimalPoint > requestedDigits) {
            buf.clearBuf();
            buf.setPointPosition(-requestedDigits);
            return;
        }
        if (-decimalPoint == requestedDigits) {
            if (Assert.assertEnabled()) {
                Assert.assertThat(decimalPoint == -requestedDigits);
            }
            denominator.times10();
            if (Bignum.plusCompare(numerator, numerator, denominator) >= 0) {
                buf.clearBuf();
                buf.append(1);
                buf.setPointPosition(decimalPoint + 1);
            } else {
                buf.clearBuf();
            }
            return;
        }
        int neededDigits = decimalPoint + requestedDigits;
        BigNumDtoa.generateCountedDigits(neededDigits, numerator, denominator, buf);
    }

    private static @UnknownVal @Signed int estimatePower(@UnknownVal @Signed int exponent) {
        double k1Log10 = 0.30102999566398114;
        double estimate = Math.ceil((double)(exponent + 53 - 1) * 0.30102999566398114 - 1.0E-10);
        return (int)estimate;
    }

    private static void initialScaledStartValuesPositiveExponent(@Unsigned @UnknownVal long significand, @UnknownVal @Signed int exponent, @UnknownVal @Signed int estimatedPower, @UnknownVal @UnknownSignedness Bignum numerator, @UnknownVal @UnknownSignedness Bignum denominator) {
        Assert.assertThat(estimatedPower >= 0);
        numerator.assignUInt64(significand);
        numerator.shiftLeft(exponent);
        denominator.assignPower(10, estimatedPower);
    }

    private static void initialScaledStartValuesNegativeExponentPositivePower(@Unsigned @UnknownVal long ulSignificand, @UnknownVal @Signed int exponent, @UnknownVal @Signed int estimatedPower, @UnknownVal @UnknownSignedness Bignum numerator, @UnknownVal @UnknownSignedness Bignum denominator) {
        numerator.assignUInt64(ulSignificand);
        denominator.assignPower(10, estimatedPower);
        denominator.shiftLeft(-exponent);
    }

    private static void initialScaledStartValuesNegativeExponentNegativePower(@Unsigned @UnknownVal long ulSignificand, @UnknownVal @Signed int exponent, @UnknownVal @Signed int estimatedPower, @UnknownVal @UnknownSignedness Bignum numerator, @UnknownVal @UnknownSignedness Bignum denominator) {
        Bignum powerTen = numerator;
        powerTen.assignPower(10, -estimatedPower);
        if (Assert.assertEnabled()) {
            Assert.assertThat(numerator.equals(powerTen));
        }
        numerator.multiplyByUInt64(ulSignificand);
        denominator.assignUInt(1);
        denominator.shiftLeft(-exponent);
    }

    private static void initialScaledStartValues(@Unsigned @UnknownVal long significand, @UnknownVal @Signed int exponent, @UnknownVal @Signed int estimatedPower, @UnknownVal @UnknownSignedness Bignum numerator, @UnknownVal @UnknownSignedness Bignum denominator) {
        if (exponent >= 0) {
            BigNumDtoa.initialScaledStartValuesPositiveExponent(significand, exponent, estimatedPower, numerator, denominator);
        } else if (estimatedPower >= 0) {
            BigNumDtoa.initialScaledStartValuesNegativeExponentPositivePower(significand, exponent, estimatedPower, numerator, denominator);
        } else {
            BigNumDtoa.initialScaledStartValuesNegativeExponentNegativePower(significand, exponent, estimatedPower, numerator, denominator);
        }
    }

    private static void fixupMultiply10(@UnknownVal @Signed int estimatedPower, @UnknownVal @UnknownSignedness boolean isEven, @UnknownVal @Signed int @UnknownVal @UnknownSignedness [] decimalPoint, @UnknownVal @UnknownSignedness Bignum numerator, @UnknownVal @UnknownSignedness Bignum denominator, @UnknownVal @UnknownSignedness Bignum deltaMinus, @UnknownVal @UnknownSignedness Bignum deltaPlus) {
        boolean inRange;
        if (isEven) {
            inRange = Bignum.plusCompare(numerator, deltaPlus, denominator) >= 0;
        } else {
            boolean bl = inRange = Bignum.plusCompare(numerator, deltaPlus, denominator) > 0;
        }
        if (inRange) {
            decimalPoint[0] = estimatedPower + 1;
        } else {
            decimalPoint[0] = estimatedPower;
            numerator.times10();
            if (Bignum.equal(deltaMinus, deltaPlus)) {
                deltaMinus.times10();
                deltaPlus.assignBignum(deltaMinus);
            } else {
                deltaMinus.times10();
                deltaPlus.times10();
            }
        }
    }

    public static enum BignumDtoaMode {
        FIXED,
        PRECISION;

    }
}

