/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.Mekanism;
import mekanism.common.tags.MekanismTags;
import mekanism.common.util.EnumUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Contract;

public class WorldUtils {
    @Contract(value="null, _ -> false")
    public static boolean isChunkLoaded(@Nullable LevelReader world, @Nonnull BlockPos pos) {
        return WorldUtils.isChunkLoaded(world, SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123343_()));
    }

    @Contract(value="null, _ -> false")
    public static boolean isChunkLoaded(@Nullable LevelReader world, ChunkPos chunkPos) {
        return WorldUtils.isChunkLoaded(world, chunkPos.f_45578_, chunkPos.f_45579_);
    }

    @Contract(value="null, _, _ -> false")
    public static boolean isChunkLoaded(@Nullable LevelReader world, int chunkX, int chunkZ) {
        LevelAccessor accessor;
        ChunkSource chunkSource;
        if (world == null) {
            return false;
        }
        if (world instanceof LevelAccessor && (chunkSource = (accessor = (LevelAccessor)world).m_7726_()) instanceof ServerChunkCache) {
            ServerChunkCache serverChunkCache = (ServerChunkCache)chunkSource;
            CompletableFuture future = serverChunkCache.m_8431_(chunkX, chunkZ, ChunkStatus.f_62326_, false);
            return future.isDone() && future.getNow(ChunkHolder.f_139995_).left().isPresent();
        }
        return world.m_6522_(chunkX, chunkZ, ChunkStatus.f_62326_, false) != null;
    }

    @Contract(value="null, _ -> false")
    public static boolean isBlockLoaded(@Nullable BlockGetter world, @Nonnull BlockPos pos) {
        if (world == null) {
            return false;
        }
        if (world instanceof LevelReader) {
            Level level;
            LevelReader reader = (LevelReader)world;
            if (reader instanceof Level && !(level = (Level)reader).m_46739_(pos)) {
                return false;
            }
            return WorldUtils.isChunkLoaded(reader, pos);
        }
        return true;
    }

    @Contract(value="null, _ -> false")
    public static boolean isBlockInBounds(@Nullable BlockGetter world, @Nonnull BlockPos pos) {
        if (world == null) {
            return false;
        }
        if (world instanceof LevelReader) {
            Level level;
            LevelReader reader = (LevelReader)world;
            return !(reader instanceof Level) || (level = (Level)reader).m_46739_(pos);
        }
        return true;
    }

    @Nullable
    @Contract(value="null, _, _ -> null")
    private static ChunkAccess getChunkForPos(@Nullable LevelAccessor world, @Nonnull Long2ObjectMap<ChunkAccess> chunkMap, @Nonnull BlockPos pos) {
        int chunkZ;
        if (!WorldUtils.isBlockInBounds((BlockGetter)world, pos)) {
            return null;
        }
        int chunkX = pos.m_123341_() >> 4;
        long combinedChunk = (long)chunkX << 32 | (long)(chunkZ = pos.m_123343_() >> 4) & 0xFFFFFFFFL;
        ChunkAccess chunk = (ChunkAccess)chunkMap.get(combinedChunk);
        if (chunk == null && (chunk = world.m_6522_(chunkX, chunkZ, ChunkStatus.f_62326_, false)) != null) {
            chunkMap.put(combinedChunk, (Object)chunk);
        }
        return chunk;
    }

    @Nonnull
    public static Optional<BlockState> getBlockState(@Nullable LevelAccessor world, @Nonnull Long2ObjectMap<ChunkAccess> chunkMap, @Nonnull BlockPos pos) {
        return WorldUtils.getBlockState((BlockGetter)WorldUtils.getChunkForPos(world, chunkMap, pos), pos);
    }

    @Nonnull
    public static Optional<BlockState> getBlockState(@Nullable BlockGetter world, @Nonnull BlockPos pos) {
        if (!WorldUtils.isBlockLoaded(world, pos)) {
            return Optional.empty();
        }
        return Optional.of(world.m_8055_(pos));
    }

    @Nonnull
    public static Optional<FluidState> getFluidState(@Nullable LevelAccessor world, @Nonnull Long2ObjectMap<ChunkAccess> chunkMap, @Nonnull BlockPos pos) {
        return WorldUtils.getFluidState((BlockGetter)WorldUtils.getChunkForPos(world, chunkMap, pos), pos);
    }

    @Nonnull
    public static Optional<FluidState> getFluidState(@Nullable BlockGetter world, @Nonnull BlockPos pos) {
        if (!WorldUtils.isBlockLoaded(world, pos)) {
            return Optional.empty();
        }
        return Optional.of(world.m_6425_(pos));
    }

    @Nullable
    @Contract(value="null, _, _ -> null")
    public static BlockEntity getTileEntity(@Nullable LevelAccessor world, @Nonnull Long2ObjectMap<ChunkAccess> chunkMap, @Nonnull BlockPos pos) {
        return WorldUtils.getTileEntity((BlockGetter)WorldUtils.getChunkForPos(world, chunkMap, pos), pos);
    }

    @Nullable
    @Contract(value="_, null, _, _ -> null")
    public static <T extends BlockEntity> T getTileEntity(@Nonnull Class<T> clazz, @Nullable LevelAccessor world, @Nonnull Long2ObjectMap<ChunkAccess> chunkMap, @Nonnull BlockPos pos) {
        return WorldUtils.getTileEntity(clazz, world, chunkMap, pos, false);
    }

    @Nullable
    @Contract(value="_, null, _, _, _ -> null")
    public static <T extends BlockEntity> T getTileEntity(@Nonnull Class<T> clazz, @Nullable LevelAccessor world, @Nonnull Long2ObjectMap<ChunkAccess> chunkMap, @Nonnull BlockPos pos, boolean logWrongType) {
        return WorldUtils.getTileEntity(clazz, (BlockGetter)WorldUtils.getChunkForPos(world, chunkMap, pos), pos, logWrongType);
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static BlockEntity getTileEntity(@Nullable BlockGetter world, @Nonnull BlockPos pos) {
        if (!WorldUtils.isBlockLoaded(world, pos)) {
            return null;
        }
        return world.m_7702_(pos);
    }

    @Nullable
    @Contract(value="_, null, _ -> null")
    public static <T extends BlockEntity> T getTileEntity(@Nonnull Class<T> clazz, @Nullable BlockGetter world, @Nonnull BlockPos pos) {
        return WorldUtils.getTileEntity(clazz, world, pos, false);
    }

    @Nullable
    @Contract(value="_, null, _, _ -> null")
    public static <T extends BlockEntity> T getTileEntity(@Nonnull Class<T> clazz, @Nullable BlockGetter world, @Nonnull BlockPos pos, boolean logWrongType) {
        BlockEntity tile = WorldUtils.getTileEntity(world, pos);
        if (tile == null) {
            return null;
        }
        if (clazz.isInstance(tile)) {
            return (T)((BlockEntity)clazz.cast(tile));
        }
        if (logWrongType) {
            Mekanism.logger.warn("Unexpected TileEntity class at {}, expected {}, but found: {}", (Object)pos, clazz, tile.getClass());
        }
        return null;
    }

    public static void saveChunk(BlockEntity tile) {
        if (tile != null && !tile.m_58901_() && tile.m_58904_() != null) {
            WorldUtils.markChunkDirty(tile.m_58904_(), tile.m_58899_());
        }
    }

    public static void markChunkDirty(Level world, BlockPos pos) {
        if (WorldUtils.isBlockLoaded((BlockGetter)world, pos)) {
            world.m_46745_(pos).m_8092_(true);
        }
    }

    public static void dismantleBlock(BlockState state, Level world, BlockPos pos) {
        WorldUtils.dismantleBlock(state, world, pos, WorldUtils.getTileEntity((BlockGetter)world, pos));
    }

    public static void dismantleBlock(BlockState state, Level world, BlockPos pos, @Nullable BlockEntity tile) {
        Block.m_49892_((BlockState)state, (LevelAccessor)world, (BlockPos)pos, (BlockEntity)tile);
        world.m_7471_(pos, false);
    }

    public static double distanceBetween(BlockPos start, BlockPos end) {
        return Math.sqrt(start.m_123331_((Vec3i)end));
    }

    public static Direction sideDifference(BlockPos pos, BlockPos other) {
        BlockPos diff = pos.m_141950_((Vec3i)other);
        for (Direction side : EnumUtils.DIRECTIONS) {
            if (side.m_122429_() != diff.m_123341_() || side.m_122430_() != diff.m_123342_() || side.m_122431_() != diff.m_123343_()) continue;
            return side;
        }
        return null;
    }

    public static boolean isChunkVibrated(ChunkPos chunk, Level world) {
        return Mekanism.activeVibrators.stream().anyMatch(coord -> coord.dimension == world.m_46472_() && coord.getX() >> 4 == chunk.f_45578_ && coord.getZ() >> 4 == chunk.f_45579_);
    }

    public static boolean tryPlaceContainedLiquid(@Nullable Player player, Level world, BlockPos pos, @Nonnull FluidStack fluidStack, @Nullable Direction side) {
        LiquidBlockContainer liquidBlockContainer;
        boolean canContainFluid;
        Fluid fluid = fluidStack.getFluid();
        if (!fluid.getAttributes().canBePlacedInWorld((BlockAndTintGetter)world, pos, fluidStack)) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        boolean isReplaceable = state.m_60722_(fluid);
        Block block = state.m_60734_();
        boolean bl = canContainFluid = block instanceof LiquidBlockContainer && (liquidBlockContainer = (LiquidBlockContainer)block).m_6044_((BlockGetter)world, pos, state, fluid);
        if (state.m_60795_() || isReplaceable || canContainFluid) {
            if (world.m_6042_().m_63951_() && fluid.getAttributes().doesVaporize((BlockAndTintGetter)world, pos, fluidStack)) {
                fluid.getAttributes().vaporize(player, world, pos, fluidStack);
            } else if (canContainFluid) {
                if (!((LiquidBlockContainer)state.m_60734_()).m_7361_((LevelAccessor)world, pos, state, fluid.getAttributes().getStateForPlacement((BlockAndTintGetter)world, pos, fluidStack))) {
                    return false;
                }
                WorldUtils.playEmptySound(player, (LevelAccessor)world, pos, fluidStack);
            } else {
                if (!world.m_5776_() && isReplaceable && !state.m_60767_().m_76332_()) {
                    world.m_46961_(pos, true);
                }
                WorldUtils.playEmptySound(player, (LevelAccessor)world, pos, fluidStack);
                world.m_7731_(pos, fluid.m_76145_().m_76188_(), 11);
            }
            return true;
        }
        return side != null && WorldUtils.tryPlaceContainedLiquid(player, world, pos.m_142300_(side), fluidStack, null);
    }

    private static void playEmptySound(@Nullable Player player, LevelAccessor world, BlockPos pos, @Nonnull FluidStack fluidStack) {
        SoundEvent soundevent = fluidStack.getFluid().getAttributes().getEmptySound((BlockAndTintGetter)world, pos);
        if (soundevent == null) {
            soundevent = MekanismTags.Fluids.LAVA_LOOKUP.contains(fluidStack.getFluid()) ? SoundEvents.f_11780_ : SoundEvents.f_11778_;
        }
        world.m_5594_(player, pos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public static void playFillSound(@Nullable Player player, LevelAccessor world, BlockPos pos, @Nonnull FluidStack fluidStack, @Nullable SoundEvent soundEvent) {
        if (soundEvent == null) {
            Fluid fluid = fluidStack.getFluid();
            soundEvent = fluid.m_142520_().orElseGet(() -> fluid.getAttributes().getFillSound((BlockAndTintGetter)world, pos));
        }
        world.m_5594_(player, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public static boolean isGettingPowered(Level world, BlockPos pos) {
        if (WorldUtils.isBlockLoaded((BlockGetter)world, pos)) {
            for (Direction side : EnumUtils.DIRECTIONS) {
                BlockState blockState;
                boolean weakPower;
                BlockPos offset = pos.m_142300_(side);
                if (!WorldUtils.isBlockLoaded((BlockGetter)world, offset) || (!(weakPower = (blockState = world.m_8055_(offset)).m_60734_().shouldCheckWeakPower(blockState, (LevelReader)world, pos, side)) || !WorldUtils.isDirectlyGettingPowered(world, offset)) && (weakPower || blockState.m_60746_((BlockGetter)world, offset, side) <= 0)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDirectlyGettingPowered(Level world, BlockPos pos) {
        for (Direction side : EnumUtils.DIRECTIONS) {
            BlockPos offset = pos.m_142300_(side);
            if (!WorldUtils.isBlockLoaded((BlockGetter)world, offset) || world.m_46681_(pos, side) <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean areBlocksValidAndReplaceable(@Nonnull BlockGetter world, BlockPos ... positions) {
        return WorldUtils.areBlocksValidAndReplaceable(world, Arrays.stream(positions));
    }

    public static boolean areBlocksValidAndReplaceable(@Nonnull BlockGetter world, @Nonnull Collection<BlockPos> positions) {
        return WorldUtils.areBlocksValidAndReplaceable(world, positions.stream());
    }

    public static boolean areBlocksValidAndReplaceable(@Nonnull BlockGetter world, @Nonnull Stream<BlockPos> positions) {
        return positions.allMatch(pos -> WorldUtils.isValidReplaceableBlock(world, pos));
    }

    public static boolean isValidReplaceableBlock(@Nonnull BlockGetter world, @Nonnull BlockPos pos) {
        return WorldUtils.isBlockInBounds(world, pos) && world.m_8055_(pos).m_60767_().m_76336_();
    }

    public static void notifyLoadedNeighborsOfTileChange(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        for (Direction dir : EnumUtils.DIRECTIONS) {
            Block block1;
            BlockPos offset = pos.m_142300_(dir);
            if (!WorldUtils.isBlockLoaded((BlockGetter)world, offset)) continue;
            WorldUtils.notifyNeighborOfChange(world, offset, pos);
            if (!world.m_8055_(offset).m_60796_((BlockGetter)world, offset) || !WorldUtils.isBlockLoaded((BlockGetter)world, offset = offset.m_142300_(dir)) || !(block1 = world.m_8055_(offset).m_60734_()).getWeakChanges(state, (LevelReader)world, offset)) continue;
            block1.onNeighborChange(state, (LevelReader)world, offset, pos);
        }
    }

    public static void notifyNeighborsOfChange(@Nullable Level world, BlockPos fromPos, Set<Direction> neighbors) {
        if (!neighbors.isEmpty()) {
            WorldUtils.getBlockState((BlockGetter)world, fromPos).ifPresent(sourceState -> {
                for (Direction neighbor : neighbors) {
                    BlockPos pos = fromPos.m_142300_(neighbor);
                    WorldUtils.getBlockState((BlockGetter)world, pos).ifPresent(state -> {
                        state.onNeighborChange((LevelReader)world, pos, fromPos);
                        state.m_60690_(world, pos, sourceState.m_60734_(), fromPos, false);
                    });
                }
            });
        }
    }

    public static void notifyNeighborOfChange(@Nullable Level world, BlockPos pos, BlockPos fromPos) {
        WorldUtils.getBlockState((BlockGetter)world, pos).ifPresent(state -> {
            state.onNeighborChange((LevelReader)world, pos, fromPos);
            state.m_60690_(world, pos, world.m_8055_(fromPos).m_60734_(), fromPos, false);
        });
    }

    public static void notifyNeighborOfChange(@Nullable Level world, Direction neighborSide, BlockPos fromPos) {
        WorldUtils.notifyNeighborOfChange(world, fromPos.m_142300_(neighborSide), fromPos);
    }

    public static void updateBlock(@Nullable Level world, @Nonnull BlockPos pos, BlockState state) {
        if (WorldUtils.isBlockLoaded((BlockGetter)world, pos)) {
            world.m_7260_(pos, state, state, 3);
        }
    }

    public static void recheckLighting(@Nullable BlockAndTintGetter world, @Nonnull BlockPos pos) {
        if (WorldUtils.isBlockLoaded((BlockGetter)world, pos)) {
            world.m_5518_().m_142202_(pos);
        }
    }

    public static float getSunBrightness(Level world, float partialTicks) {
        float f = world.m_46942_(partialTicks);
        float f1 = 1.0f - (Mth.m_14089_((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        f1 = Mth.m_14036_((float)f1, (float)0.0f, (float)1.0f);
        f1 = 1.0f - f1;
        f1 = (float)((double)f1 * (1.0 - (double)(world.m_46722_(partialTicks) * 5.0f) / 16.0));
        f1 = (float)((double)f1 * (1.0 - (double)(world.m_46661_(partialTicks) * 5.0f) / 16.0));
        return f1 * 0.8f + 0.2f;
    }

    @Contract(value="null, _ -> false")
    public static boolean canSeeSun(@Nullable Level world, BlockPos pos) {
        return world != null && world.m_6042_().m_63935_() && world.m_7445_() < 4 && world.m_45527_(pos);
    }

    public static long getChunkPosAsLong(BlockPos pos) {
        return ChunkPos.m_45589_((int)SectionPos.m_123171_((int)pos.m_123341_()), (int)SectionPos.m_123171_((int)pos.m_123343_()));
    }

    public static BlockPos getBlockPosFromChunkPos(long chunkPos) {
        return new BlockPos((int)chunkPos, 0, (int)(chunkPos >> 32));
    }
}

