/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.UUID;
import javax.annotation.Nonnull;
import mekanism.api.IContentsListener;
import mekanism.api.MekanismAPI;
import mekanism.api.security.ISecurityUtils;
import mekanism.api.security.SecurityMode;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.ISecurityContainer;
import mekanism.common.inventory.slot.SecurityInventorySlot;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.network.to_client.PacketSecurityUpdate;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IBoundingBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.server.ServerLifecycleHooks;

public class TileEntitySecurityDesk
extends TileEntityMekanism
implements IBoundingBlock {
    private SecurityInventorySlot unlockSlot;
    private SecurityInventorySlot lockSlot;

    public TileEntitySecurityDesk(BlockPos pos, BlockState state) {
        super(MekanismBlocks.SECURITY_DESK, pos, state);
        this.addDisabledCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Capabilities.SECURITY_OBJECT);
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.unlockSlot = SecurityInventorySlot.unlock(this::getOwnerUUID, listener, 146, 18);
        builder.addSlot(this.unlockSlot);
        this.lockSlot = SecurityInventorySlot.lock(listener, 146, 97);
        builder.addSlot(this.lockSlot);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        SecurityFrequency frequency = this.getFreq();
        UUID ownerUUID = this.getOwnerUUID();
        if (ownerUUID != null && frequency != null) {
            this.unlockSlot.unlock(ownerUUID);
            this.lockSlot.lock(ownerUUID, frequency);
        }
    }

    public void toggleOverride() {
        SecurityFrequency frequency = this.getFreq();
        if (frequency != null) {
            frequency.setOverridden(!frequency.isOverridden());
            this.markForSave();
            Mekanism.packetHandler().sendToAll(new PacketSecurityUpdate(frequency));
            this.validateAccess();
        }
    }

    private void validateAccess() {
        MinecraftServer server;
        if (this.m_58898_() && (server = this.getWorldNN().m_142572_()) != null) {
            ISecurityUtils securityUtils = MekanismAPI.getSecurityUtils();
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                ISecurityContainer container;
                AbstractContainerMenu abstractContainerMenu = player.f_36096_;
                if (!(abstractContainerMenu instanceof ISecurityContainer) || securityUtils.canAccess((Player)player, (container = (ISecurityContainer)abstractContainerMenu).getSecurityObject())) continue;
                player.m_6915_();
            }
        }
    }

    public void removeTrusted(int index) {
        SecurityFrequency frequency = this.getFreq();
        if (frequency != null) {
            AbstractContainerMenu abstractContainerMenu;
            ServerPlayer player;
            MinecraftServer server;
            UUID removed = frequency.removeTrusted(index);
            this.markForSave();
            if (removed != null && this.m_58898_() && (server = this.getWorldNN().m_142572_()) != null && (player = server.m_6846_().m_11259_(removed)) != null && (abstractContainerMenu = player.f_36096_) instanceof ISecurityContainer) {
                ISecurityContainer container = (ISecurityContainer)abstractContainerMenu;
                if (!MekanismAPI.getSecurityUtils().canAccess((Player)player, container.getSecurityObject())) {
                    player.m_6915_();
                }
            }
        }
    }

    public void setSecurityDeskMode(SecurityMode mode) {
        SecurityMode old;
        SecurityFrequency frequency = this.getFreq();
        if (frequency != null && (old = frequency.getSecurityMode()) != mode) {
            frequency.setSecurityMode(mode);
            this.markForSave();
            Mekanism.packetHandler().sendToAll(new PacketSecurityUpdate(frequency));
            if (MekanismAPI.getSecurityUtils().moreRestrictive(old, mode)) {
                this.validateAccess();
            }
        }
    }

    public void addTrusted(String name) {
        SecurityFrequency frequency = this.getFreq();
        if (frequency != null) {
            ServerLifecycleHooks.getCurrentServer().m_129927_().m_10996_(name).ifPresent(profile -> {
                frequency.addTrusted(profile.getId(), profile.getName());
                this.markForSave();
            });
        }
    }

    public SecurityFrequency getFreq() {
        return (SecurityFrequency)this.getFrequency(FrequencyType.SECURITY);
    }

    @Override
    public boolean isOffsetCapabilityDisabled(@Nonnull Capability<?> capability, Direction side, @Nonnull Vec3i offset) {
        return true;
    }
}

