/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.model.ModelIndustrialAlarm;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.tile.TileEntityIndustrialAlarm;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.profiling.ProfilerFiller;

@ParametersAreNonnullByDefault
public class RenderIndustrialAlarm
extends MekanismTileEntityRenderer<TileEntityIndustrialAlarm> {
    private static final float ROTATE_SPEED = 10.0f;
    private final ModelIndustrialAlarm model;

    public RenderIndustrialAlarm(BlockEntityRendererProvider.Context context) {
        super(context);
        this.model = new ModelIndustrialAlarm(context.m_173585_());
    }

    @Override
    protected void render(TileEntityIndustrialAlarm tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        this.performTranslations(tile, matrix);
        float rotation = ((float)tile.m_58904_().m_46467_() + partialTick) * 10.0f % 360.0f;
        this.model.render(matrix, renderer, light, overlayLight, Attribute.isActive(tile.m_58900_()), rotation, false, false);
        matrix.m_85849_();
    }

    @Override
    protected String getProfilerSection() {
        return "industrialAlarm";
    }

    public boolean shouldRenderOffScreen(TileEntityIndustrialAlarm tile) {
        return true;
    }

    private void performTranslations(TileEntityIndustrialAlarm tile, PoseStack matrix) {
        matrix.m_85836_();
        matrix.m_85837_(0.5, 0.0, 0.5);
        switch (tile.getDirection()) {
            case DOWN: {
                matrix.m_85837_(0.0, 1.0, 0.0);
                matrix.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
                break;
            }
            case NORTH: {
                matrix.m_85837_(0.0, 0.5, 0.5);
                matrix.m_85845_(Vector3f.f_122222_.m_122240_(90.0f));
                break;
            }
            case SOUTH: {
                matrix.m_85837_(0.0, 0.5, -0.5);
                matrix.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                break;
            }
            case EAST: {
                matrix.m_85837_(-0.5, 0.5, 0.0);
                matrix.m_85845_(Vector3f.f_122226_.m_122240_(90.0f));
                break;
            }
            case WEST: {
                matrix.m_85837_(0.5, 0.5, 0.0);
                matrix.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
            }
        }
    }
}

