/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.BooleanSupplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.data.RenderData;
import mekanism.common.config.MekanismConfig;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

@ParametersAreNonnullByDefault
public abstract class MekanismTileEntityRenderer<TILE extends BlockEntity>
implements BlockEntityRenderer<TILE> {
    protected final BlockEntityRendererProvider.Context context;

    protected MekanismTileEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public int m_142163_() {
        return MekanismConfig.client.terRange.get();
    }

    public void m_6922_(TILE tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight) {
        if (tile.m_58904_() != null) {
            ProfilerFiller profiler = tile.m_58904_().m_46473_();
            profiler.m_6180_(this.getProfilerSection());
            this.render(tile, partialTick, matrix, renderer, light, overlayLight, profiler);
            profiler.m_7238_();
        }
    }

    protected abstract void render(TILE var1, float var2, PoseStack var3, MultiBufferSource var4, int var5, int var6, ProfilerFiller var7);

    protected abstract String getProfilerSection();

    protected boolean isInsideBounds(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        Vec3 projectedView = this.context.m_173581_().f_112249_.m_90583_();
        return minX <= projectedView.f_82479_ && projectedView.f_82479_ <= maxX && minY <= projectedView.f_82480_ && projectedView.f_82480_ <= maxY && minZ <= projectedView.f_82481_ && projectedView.f_82481_ <= maxZ;
    }

    protected RenderResizableCuboid.FaceDisplay getFaceDisplay(RenderData data, MekanismRenderer.Model3D model) {
        return this.isInsideBounds(data.location.m_123341_(), data.location.m_123342_(), data.location.m_123343_(), data.location.m_123341_() + data.length, (float)data.location.m_123342_() + ModelRenderer.getActualHeight(model), data.location.m_123343_() + data.width) ? RenderResizableCuboid.FaceDisplay.BACK : RenderResizableCuboid.FaceDisplay.FRONT;
    }

    protected BooleanSupplier isInsideMultiblock(RenderData data) {
        return () -> this.isInsideBounds(data.location.m_123341_(), data.location.m_123342_(), data.location.m_123343_(), data.location.m_123341_() + data.length, data.location.m_123342_() + data.height, data.location.m_123343_() + data.width);
    }
}

