/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gear;

import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.functions.FloatSupplier;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.math.FloatingLongSupplier;
import net.minecraft.core.BlockSource;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraftforge.common.ToolAction;

@ParametersAreNonnullByDefault
public interface ICustomModule<MODULE extends ICustomModule<MODULE>> {
    default public void init(IModule<MODULE> module, ModuleConfigItemCreator configItemCreator) {
    }

    default public void tickServer(IModule<MODULE> module, Player player) {
    }

    default public void tickClient(IModule<MODULE> module, Player player) {
    }

    default public void addHUDStrings(IModule<MODULE> module, Player player, Consumer<Component> hudStringAdder) {
    }

    default public void addHUDElements(IModule<MODULE> module, Player player, Consumer<IHUDElement> hudElementAdder) {
    }

    default public boolean canChangeModeWhenDisabled(IModule<MODULE> module) {
        return false;
    }

    default public void changeMode(IModule<MODULE> module, Player player, ItemStack stack, int shift, boolean displayChangeMessage) {
    }

    default public void onAdded(IModule<MODULE> module, boolean first) {
    }

    default public void onRemoved(IModule<MODULE> module, boolean last) {
    }

    default public void onEnabledStateChange(IModule<MODULE> module) {
    }

    @Nullable
    default public ModuleDamageAbsorbInfo getDamageAbsorbInfo(IModule<MODULE> module, DamageSource damageSource) {
        return null;
    }

    @Nonnull
    default public InteractionResult onItemUse(IModule<MODULE> module, UseOnContext context) {
        return InteractionResult.PASS;
    }

    default public boolean canPerformAction(IModule<MODULE> module, ToolAction action) {
        return false;
    }

    @Nonnull
    default public InteractionResult onInteract(IModule<MODULE> module, Player player, LivingEntity entity, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    @Nonnull
    default public ModuleDispenseResult onDispense(IModule<MODULE> module, BlockSource source) {
        return ModuleDispenseResult.DEFAULT;
    }

    public static enum ModuleDispenseResult {
        HANDLED,
        DEFAULT,
        FAIL_PREVENT_DROP;

    }

    public record ModuleDamageAbsorbInfo(FloatSupplier absorptionRatio, FloatingLongSupplier energyCost) {
        public ModuleDamageAbsorbInfo {
            Objects.requireNonNull(absorptionRatio, "Absorption ratio supplier cannot be null");
            Objects.requireNonNull(energyCost, "Energy cost supplier cannot be null");
        }
    }
}

