/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config.sorting;

import java.io.File;
import java.util.Comparator;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.config.sorting.MappedSortingConfig;
import mezz.jei.config.sorting.serializers.SortingSerializers;

public class RecipeCategorySortingConfig
extends MappedSortingConfig<RecipeType<?>, String> {
    public RecipeCategorySortingConfig(File file) {
        super(file, SortingSerializers.STRING, r -> r.getUid().toString());
    }

    @Override
    protected Comparator<String> getDefaultSortOrder() {
        Comparator<String> minecraftCraftingFirst = Comparator.comparing(s -> {
            String vanillaCrafting = RecipeTypes.CRAFTING.getUid().toString();
            return s.equals(vanillaCrafting);
        }).reversed();
        Comparator<String> minecraftFirst = Comparator.comparing(s -> s.startsWith("minecraft")).reversed();
        Comparator naturalOrder = Comparator.naturalOrder();
        return minecraftCraftingFirst.thenComparing(minecraftFirst).thenComparing(naturalOrder);
    }
}

