/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.management.edgePoint.station;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.entity.TrainIconType;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class TrainEditPacket
extends SimplePacketBase {
    private String name;
    private UUID id;
    private ResourceLocation iconType;

    public TrainEditPacket(UUID id, String name, ResourceLocation iconType) {
        this.name = name;
        this.id = id;
        this.iconType = iconType;
    }

    public TrainEditPacket(FriendlyByteBuf buffer) {
        this.id = buffer.m_130259_();
        this.name = buffer.m_130136_(256);
        this.iconType = buffer.m_130281_();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.id);
        buffer.m_130070_(this.name);
        buffer.m_130085_(this.iconType);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ServerPlayer sender = ctx.getSender();
            Level level = sender == null ? null : sender.f_19853_;
            Train train = Create.RAILWAYS.sided((LevelAccessor)level).trains.get(this.id);
            if (train == null) {
                return;
            }
            if (!this.name.isBlank()) {
                train.name = new TextComponent(this.name);
            }
            train.icon = TrainIconType.byId(this.iconType);
            if (sender != null) {
                AllPackets.channel.send(PacketDistributor.ALL.noArg(), (Object)new TrainEditReturnPacket(this.id, this.name, this.iconType));
            }
        });
        ctx.setPacketHandled(true);
    }

    public static class TrainEditReturnPacket
    extends TrainEditPacket {
        public TrainEditReturnPacket(FriendlyByteBuf buffer) {
            super(buffer);
        }

        public TrainEditReturnPacket(UUID id, String name, ResourceLocation iconType) {
            super(id, name, iconType);
        }
    }
}

