/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.display;

import com.simibubi.create.content.logistics.block.display.AllDisplayBehaviours;
import com.simibubi.create.content.logistics.block.display.DisplayLinkBlock;
import com.simibubi.create.content.logistics.block.display.DisplayLinkContext;
import com.simibubi.create.content.logistics.block.display.source.DisplaySource;
import com.simibubi.create.content.logistics.block.display.target.DisplayTarget;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DisplayLinkTileEntity
extends SmartTileEntity {
    protected BlockPos targetOffset = BlockPos.f_121853_;
    public DisplaySource activeSource;
    private CompoundTag sourceConfig = new CompoundTag();
    public DisplayTarget activeTarget;
    public int targetLine = 0;
    public LerpedFloat glow = LerpedFloat.linear().startWithValue(0.0);
    private boolean sendPulse;
    public int refreshTicks;

    public DisplayLinkTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.glow.chase(0.0, 0.5, LerpedFloat.Chaser.EXP);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isVirtual()) {
            this.glow.tickChaser();
            return;
        }
        if (this.activeSource == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            this.glow.tickChaser();
            return;
        }
        ++this.refreshTicks;
        if (this.refreshTicks < this.activeSource.getPassiveRefreshTicks()) {
            return;
        }
        this.tickSource();
    }

    public void tickSource() {
        this.refreshTicks = 0;
        if (this.m_58900_().m_61145_((Property)DisplayLinkBlock.POWERED).orElse(true).booleanValue()) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            this.updateGatheredData();
        }
    }

    public void onNoLongerPowered() {
        if (this.activeSource == null) {
            return;
        }
        this.refreshTicks = 0;
        this.activeSource.onSignalReset(new DisplayLinkContext(this.f_58857_, this));
        this.updateGatheredData();
    }

    public void updateGatheredData() {
        BlockPos sourcePosition = this.getSourcePosition();
        BlockPos targetPosition = this.getTargetPosition();
        if (!this.f_58857_.m_46749_(targetPosition) || !this.f_58857_.m_46749_(sourcePosition)) {
            return;
        }
        DisplayTarget target = AllDisplayBehaviours.targetOf((LevelAccessor)this.f_58857_, targetPosition);
        List<DisplaySource> sources = AllDisplayBehaviours.sourcesOf((LevelAccessor)this.f_58857_, sourcePosition);
        boolean notify = false;
        if (this.activeTarget != target) {
            this.activeTarget = target;
            notify = true;
        }
        if (this.activeSource != null && !sources.contains(this.activeSource)) {
            this.activeSource = null;
            this.sourceConfig = new CompoundTag();
            notify = true;
        }
        if (notify) {
            this.notifyUpdate();
        }
        if (this.activeSource == null || this.activeTarget == null) {
            return;
        }
        DisplayLinkContext context = new DisplayLinkContext(this.f_58857_, this);
        this.activeSource.transferData(context, this.activeTarget, this.targetLine);
        this.sendPulse = true;
        this.sendData();
        this.award(AllAdvancements.DISPLAY_LINK);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        this.registerAwardables(behaviours, AllAdvancements.DISPLAY_LINK, AllAdvancements.DISPLAY_BOARD);
    }

    @Override
    public void writeSafe(CompoundTag tag, boolean clientPacket) {
        super.writeSafe(tag, clientPacket);
        this.writeGatheredData(tag, clientPacket);
    }

    @Override
    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        this.writeGatheredData(tag, clientPacket);
        if (clientPacket && this.activeTarget != null) {
            tag.m_128359_("TargetType", this.activeTarget.id.toString());
        }
        if (clientPacket && this.sendPulse) {
            this.sendPulse = false;
            NBTHelper.putMarker(tag, "Pulse");
        }
    }

    private void writeGatheredData(CompoundTag tag, boolean clientPacket) {
        tag.m_128365_("TargetOffset", (Tag)NbtUtils.m_129224_((BlockPos)this.targetOffset));
        tag.m_128405_("TargetLine", this.targetLine);
        if (this.activeSource != null) {
            CompoundTag data = this.sourceConfig.m_6426_();
            data.m_128359_("Id", this.activeSource.id.toString());
            tag.m_128365_("Source", (Tag)data);
        }
    }

    @Override
    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.targetOffset = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("TargetOffset"));
        this.targetLine = tag.m_128451_("TargetLine");
        if (clientPacket && tag.m_128441_("TargetType")) {
            this.activeTarget = AllDisplayBehaviours.getTarget(new ResourceLocation(tag.m_128461_("TargetType")));
        }
        if (clientPacket && tag.m_128441_("Pulse")) {
            this.glow.setValue(2.0);
        }
        if (!tag.m_128441_("Source")) {
            return;
        }
        CompoundTag data = tag.m_128469_("Source");
        this.activeSource = AllDisplayBehaviours.getSource(new ResourceLocation(data.m_128461_("Id")));
        this.sourceConfig = new CompoundTag();
        if (this.activeSource != null) {
            this.sourceConfig = data.m_6426_();
        }
    }

    public void target(BlockPos targetPosition) {
        this.targetOffset = targetPosition.m_141950_((Vec3i)this.f_58858_);
    }

    public BlockPos getSourcePosition() {
        return this.f_58858_.m_142300_(this.getDirection());
    }

    public CompoundTag getSourceConfig() {
        return this.sourceConfig;
    }

    public void setSourceConfig(CompoundTag sourceConfig) {
        this.sourceConfig = sourceConfig;
    }

    public Direction getDirection() {
        return this.m_58900_().m_61145_((Property)DisplayLinkBlock.f_52588_).orElse(Direction.UP).m_122424_();
    }

    public BlockPos getTargetPosition() {
        return this.f_58858_.m_141952_((Vec3i)this.targetOffset);
    }
}

