/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.base;

import com.jozufozu.flywheel.backend.instancing.InstancedRenderDispatcher;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.KineticNetwork;
import com.simibubi.create.content.contraptions.RotationPropagator;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticBlock;
import com.simibubi.create.content.contraptions.base.KineticEffectHandler;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.contraptions.relays.elementary.ICogWheel;
import com.simibubi.create.content.contraptions.relays.gearbox.GearboxBlock;
import com.simibubi.create.foundation.block.BlockStressValues;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.sound.SoundScapes;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class KineticTileEntity
extends SmartTileEntity
implements IHaveGoggleInformation,
IHaveHoveringInformation {
    @Nullable
    public Long network;
    @Nullable
    public BlockPos source;
    public boolean networkDirty;
    public boolean updateSpeed = true;
    public int preventSpeedUpdate;
    protected KineticEffectHandler effects = new KineticEffectHandler(this);
    protected float speed;
    protected float capacity;
    protected float stress;
    protected boolean overStressed;
    protected boolean wasMoved;
    private int flickerTally;
    private int networkSize;
    private int validationCountdown;
    protected float lastStressApplied;
    protected float lastCapacityProvided;

    public KineticTileEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Override
    public void initialize() {
        if (this.hasNetwork() && !this.f_58857_.f_46443_) {
            KineticNetwork network = this.getOrCreateNetwork();
            if (!network.initialized) {
                network.initFromTE(this.capacity, this.stress, this.networkSize);
            }
            network.addSilently(this, this.lastCapacityProvided, this.lastStressApplied);
        }
        super.initialize();
    }

    @Override
    public void tick() {
        if (!this.f_58857_.f_46443_ && this.needsSpeedUpdate()) {
            this.attachKinetics();
        }
        super.tick();
        this.effects.tick();
        this.preventSpeedUpdate = 0;
        if (this.f_58857_.f_46443_) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.tickAudio());
            return;
        }
        if (this.validationCountdown-- <= 0) {
            this.validationCountdown = (Integer)AllConfigs.SERVER.kinetics.kineticValidationFrequency.get();
            this.validateKinetics();
        }
        if (this.getFlickerScore() > 0) {
            this.flickerTally = this.getFlickerScore() - 1;
        }
        if (this.networkDirty) {
            if (this.hasNetwork()) {
                this.getOrCreateNetwork().updateNetwork();
            }
            this.networkDirty = false;
        }
    }

    private void validateKinetics() {
        if (this.hasSource()) {
            KineticTileEntity sourceTe;
            if (!this.hasNetwork()) {
                this.removeSource();
                return;
            }
            if (!this.f_58857_.m_46749_(this.source)) {
                return;
            }
            BlockEntity tileEntity = this.f_58857_.m_7702_(this.source);
            KineticTileEntity kineticTileEntity = sourceTe = tileEntity instanceof KineticTileEntity ? (KineticTileEntity)tileEntity : null;
            if (sourceTe == null || sourceTe.speed == 0.0f) {
                this.removeSource();
                this.detachKinetics();
                return;
            }
            return;
        }
        if (this.speed != 0.0f && this.getGeneratedSpeed() == 0.0f) {
            this.speed = 0.0f;
        }
    }

    public void updateFromNetwork(float maxStress, float currentStress, int networkSize) {
        this.networkDirty = false;
        this.capacity = maxStress;
        this.stress = currentStress;
        this.networkSize = networkSize;
        boolean overStressed = maxStress < currentStress && IRotate.StressImpact.isEnabled();
        this.m_6596_();
        if (overStressed != this.overStressed) {
            float prevSpeed = this.getSpeed();
            this.overStressed = overStressed;
            this.onSpeedChanged(prevSpeed);
            this.sendData();
        }
    }

    protected Block getStressConfigKey() {
        return this.m_58900_().m_60734_();
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = (float)BlockStressValues.getImpact(this.getStressConfigKey());
        return impact;
    }

    public float calculateAddedStressCapacity() {
        float capacity;
        this.lastCapacityProvided = capacity = (float)BlockStressValues.getCapacity(this.getStressConfigKey());
        return capacity;
    }

    public void onSpeedChanged(float previousSpeed) {
        boolean directionSwap;
        boolean fromOrToZero = previousSpeed == 0.0f != (this.getSpeed() == 0.0f);
        boolean bl = directionSwap = !fromOrToZero && Math.signum(previousSpeed) != Math.signum(this.getSpeed());
        if (fromOrToZero || directionSwap) {
            this.flickerTally = this.getFlickerScore() + 5;
        }
        this.m_6596_();
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
    }

    @Override
    protected void setRemovedNotDueToChunkUnload() {
        if (!this.f_58857_.f_46443_) {
            if (this.hasNetwork()) {
                this.getOrCreateNetwork().remove(this);
            }
            this.detachKinetics();
        }
        super.setRemovedNotDueToChunkUnload();
    }

    @Override
    protected void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128350_("Speed", this.speed);
        if (this.needsSpeedUpdate()) {
            compound.m_128379_("NeedsSpeedUpdate", true);
        }
        if (this.hasSource()) {
            compound.m_128365_("Source", (Tag)NbtUtils.m_129224_((BlockPos)this.source));
        }
        if (this.hasNetwork()) {
            CompoundTag networkTag = new CompoundTag();
            networkTag.m_128356_("Id", this.network.longValue());
            networkTag.m_128350_("Stress", this.stress);
            networkTag.m_128350_("Capacity", this.capacity);
            networkTag.m_128405_("Size", this.networkSize);
            if (this.lastStressApplied != 0.0f) {
                networkTag.m_128350_("AddedStress", this.lastStressApplied);
            }
            if (this.lastCapacityProvided != 0.0f) {
                networkTag.m_128350_("AddedCapacity", this.lastCapacityProvided);
            }
            compound.m_128365_("Network", (Tag)networkTag);
        }
        super.write(compound, clientPacket);
    }

    public boolean needsSpeedUpdate() {
        return this.updateSpeed;
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        boolean overStressedBefore = this.overStressed;
        this.clearKineticInformation();
        if (this.wasMoved) {
            super.read(compound, clientPacket);
            return;
        }
        this.speed = compound.m_128457_("Speed");
        if (compound.m_128441_("Source")) {
            this.source = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Source"));
        }
        if (compound.m_128441_("Network")) {
            CompoundTag networkTag = compound.m_128469_("Network");
            this.network = networkTag.m_128454_("Id");
            this.stress = networkTag.m_128457_("Stress");
            this.capacity = networkTag.m_128457_("Capacity");
            this.networkSize = networkTag.m_128451_("Size");
            this.lastStressApplied = networkTag.m_128457_("AddedStress");
            this.lastCapacityProvided = networkTag.m_128457_("AddedCapacity");
            this.overStressed = this.capacity < this.stress && IRotate.StressImpact.isEnabled();
        }
        super.read(compound, clientPacket);
        if (clientPacket && overStressedBefore != this.overStressed && this.speed != 0.0f) {
            this.effects.triggerOverStressedEffect();
        }
        if (clientPacket) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> InstancedRenderDispatcher.enqueueUpdate((BlockEntity)this));
        }
    }

    public float getGeneratedSpeed() {
        return 0.0f;
    }

    public boolean isSource() {
        return this.getGeneratedSpeed() != 0.0f;
    }

    public float getSpeed() {
        if (this.overStressed) {
            return 0.0f;
        }
        return this.getTheoreticalSpeed();
    }

    public float getTheoreticalSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public void setSource(BlockPos source) {
        this.source = source;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        BlockEntity tileEntity = this.f_58857_.m_7702_(source);
        if (!(tileEntity instanceof KineticTileEntity)) {
            this.removeSource();
            return;
        }
        KineticTileEntity sourceTe = (KineticTileEntity)tileEntity;
        this.setNetwork(sourceTe.network);
    }

    public void removeSource() {
        float prevSpeed = this.getSpeed();
        this.speed = 0.0f;
        this.source = null;
        this.setNetwork(null);
        this.onSpeedChanged(prevSpeed);
    }

    public void setNetwork(@Nullable Long networkIn) {
        if (this.network == networkIn) {
            return;
        }
        if (this.network != null) {
            this.getOrCreateNetwork().remove(this);
        }
        this.network = networkIn;
        this.m_6596_();
        if (networkIn == null) {
            return;
        }
        this.network = networkIn;
        KineticNetwork network = this.getOrCreateNetwork();
        network.initialized = true;
        network.add(this);
    }

    public KineticNetwork getOrCreateNetwork() {
        return Create.TORQUE_PROPAGATOR.getOrCreateNetworkFor(this);
    }

    public boolean hasNetwork() {
        return this.network != null;
    }

    public void attachKinetics() {
        this.updateSpeed = false;
        RotationPropagator.handleAdded(this.f_58857_, this.f_58858_, this);
    }

    public void detachKinetics() {
        RotationPropagator.handleRemoved(this.f_58857_, this.f_58858_, this);
    }

    public boolean isSpeedRequirementFulfilled() {
        BlockState state = this.m_58900_();
        if (!(this.m_58900_().m_60734_() instanceof IRotate)) {
            return true;
        }
        IRotate def = (IRotate)state.m_60734_();
        IRotate.SpeedLevel minimumRequiredSpeedLevel = def.getMinimumRequiredSpeedLevel();
        return Math.abs(this.getSpeed()) >= minimumRequiredSpeedLevel.getSpeedValue();
    }

    public static void switchToBlockState(Level world, BlockPos pos, BlockState state) {
        if (world.f_46443_) {
            return;
        }
        BlockEntity tileEntityIn = world.m_7702_(pos);
        BlockState currentState = world.m_8055_(pos);
        boolean isKinetic = tileEntityIn instanceof KineticTileEntity;
        if (currentState == state) {
            return;
        }
        if (tileEntityIn == null || !isKinetic) {
            world.m_7731_(pos, state, 3);
            return;
        }
        KineticTileEntity tileEntity = (KineticTileEntity)tileEntityIn;
        if (state.m_60734_() instanceof KineticBlock && !((KineticBlock)state.m_60734_()).areStatesKineticallyEquivalent(currentState, state)) {
            if (tileEntity.hasNetwork()) {
                tileEntity.getOrCreateNetwork().remove(tileEntity);
            }
            tileEntity.detachKinetics();
            tileEntity.removeSource();
        }
        world.m_7731_(pos, state, 3);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    @Override
    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean notFastEnough;
        boolean bl = notFastEnough = !this.isSpeedRequirementFulfilled() && this.getSpeed() != 0.0f;
        if (this.overStressed && ((Boolean)AllConfigs.CLIENT.enableOverstressedTooltip.get()).booleanValue()) {
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)Lang.translateDirect("gui.stressometer.overstressed", new Object[0]).m_130940_(ChatFormatting.GOLD)));
            TranslatableComponent hint = Lang.translateDirect("gui.contraptions.network_overstressed", new Object[0]);
            List<Component> cutString = TooltipHelper.cutTextComponent((Component)hint, ChatFormatting.GRAY, ChatFormatting.WHITE);
            for (int i = 0; i < cutString.size(); ++i) {
                tooltip.add((Component)componentSpacing.m_6879_().m_7220_(cutString.get(i)));
            }
            return true;
        }
        if (notFastEnough) {
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)Lang.translateDirect("tooltip.speedRequirement", new Object[0]).m_130940_(ChatFormatting.GOLD)));
            TranslatableComponent hint = Lang.translateDirect("gui.contraptions.not_fast_enough", I18n.m_118938_((String)this.m_58900_().m_60734_().m_7705_(), (Object[])new Object[0]));
            List<Component> cutString = TooltipHelper.cutTextComponent((Component)hint, ChatFormatting.GRAY, ChatFormatting.WHITE);
            for (int i = 0; i < cutString.size(); ++i) {
                tooltip.add((Component)componentSpacing.m_6879_().m_7220_(cutString.get(i)));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = false;
        if (!IRotate.StressImpact.isEnabled()) {
            return added;
        }
        float stressAtBase = this.calculateStressApplied();
        if (Mth.m_14033_((float)stressAtBase, (float)0.0f)) {
            return added;
        }
        Lang.translate("gui.goggles.kinetic_stats", new Object[0]).forGoggles(tooltip);
        Lang.translate("tooltip.stressImpact", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        float stressTotal = stressAtBase * Math.abs(this.getTheoreticalSpeed());
        Lang.number(stressTotal).translate("generic.unit.stress", new Object[0]).style(ChatFormatting.AQUA).space().add(Lang.translate("gui.goggles.at_current_speed", new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        return true;
    }

    public void clearKineticInformation() {
        this.speed = 0.0f;
        this.source = null;
        this.network = null;
        this.overStressed = false;
        this.stress = 0.0f;
        this.capacity = 0.0f;
        this.lastStressApplied = 0.0f;
        this.lastCapacityProvided = 0.0f;
    }

    public void warnOfMovement() {
        this.wasMoved = true;
    }

    public int getFlickerScore() {
        return this.flickerTally;
    }

    public static float convertToDirection(float axisSpeed, Direction d) {
        return d.m_122421_() == Direction.AxisDirection.POSITIVE ? axisSpeed : -axisSpeed;
    }

    public static float convertToLinear(float speed) {
        return speed / 512.0f;
    }

    public static float convertToAngular(float speed) {
        return speed * 3.0f / 10.0f;
    }

    public boolean isOverStressed() {
        return this.overStressed;
    }

    public float propagateRotationTo(KineticTileEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        return 0.0f;
    }

    public List<BlockPos> addPropagationLocations(IRotate block, BlockState state, List<BlockPos> neighbours) {
        if (!this.canPropagateDiagonally(block, state)) {
            return neighbours;
        }
        Direction.Axis axis = block.getRotationAxis(state);
        BlockPos.m_121990_((BlockPos)new BlockPos(-1, -1, -1), (BlockPos)new BlockPos(1, 1, 1)).forEach(offset -> {
            if (axis.m_7863_(offset.m_123341_(), offset.m_123342_(), offset.m_123343_()) != 0) {
                return;
            }
            if (offset.m_123331_((Vec3i)BlockPos.f_121853_) != 2.0) {
                return;
            }
            neighbours.add(this.f_58858_.m_141952_((Vec3i)offset));
        });
        return neighbours;
    }

    public boolean isCustomConnection(KineticTileEntity other, BlockState state, BlockState otherState) {
        return false;
    }

    protected boolean canPropagateDiagonally(IRotate block, BlockState state) {
        return ICogWheel.isSmallCog(state);
    }

    public void requestModelDataUpdate() {
        super.requestModelDataUpdate();
        if (!this.f_58859_) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> InstancedRenderDispatcher.enqueueUpdate((BlockEntity)this));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        Block block;
        float componentSpeed = Math.abs(this.getSpeed());
        if (componentSpeed == 0.0f) {
            return;
        }
        float pitch = Mth.m_14036_((float)(componentSpeed / 256.0f + 0.45f), (float)0.85f, (float)1.0f);
        if (this.isNoisy()) {
            SoundScapes.play(SoundScapes.AmbienceGroup.KINETIC, this.f_58858_, pitch);
        }
        if (ICogWheel.isSmallCog(block = this.m_58900_().m_60734_()) || ICogWheel.isLargeCog(block) || block instanceof GearboxBlock) {
            SoundScapes.play(SoundScapes.AmbienceGroup.COG, this.f_58858_, pitch);
        }
    }

    protected boolean isNoisy() {
        return true;
    }

    public int getRotationAngleOffset(Direction.Axis axis) {
        return 0;
    }
}

