/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.jei.category.BasinCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedBlazeBurner;
import com.simibubi.create.compat.jei.category.animations.AnimatedMixer;
import com.simibubi.create.content.contraptions.processing.BasinRecipe;
import com.simibubi.create.content.contraptions.processing.HeatCondition;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

@ParametersAreNonnullByDefault
public class MixingCategory
extends BasinCategory {
    private final AnimatedMixer mixer = new AnimatedMixer();
    private final AnimatedBlazeBurner heater = new AnimatedBlazeBurner();
    MixingType type;

    public static MixingCategory autoShapeless() {
        return new MixingCategory(MixingType.AUTO_SHAPELESS, (ItemLike)Items.f_41960_, 85);
    }

    public static MixingCategory standard() {
        return new MixingCategory(MixingType.MIXING, (ItemLike)AllBlocks.BASIN.get(), 103);
    }

    public static MixingCategory autoBrewing() {
        return new MixingCategory(MixingType.AUTO_BREWING, (ItemLike)Blocks.f_50255_, 103);
    }

    protected MixingCategory(MixingType type, ItemLike secondaryItem, int height) {
        super(type != MixingType.AUTO_SHAPELESS, MixingCategory.doubleItemIcon((ItemLike)AllBlocks.MECHANICAL_MIXER.get(), secondaryItem), MixingCategory.emptyBackground(177, height));
        this.type = type;
    }

    @Override
    public void draw(BasinRecipe recipe, IRecipeSlotsView iRecipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        super.draw(recipe, iRecipeSlotsView, matrixStack, mouseX, mouseY);
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        if (requiredHeat != HeatCondition.NONE) {
            this.heater.withHeat(requiredHeat.visualizeAsBlazeBurner()).draw(matrixStack, this.getBackground().getWidth() / 2 + 3, 55);
        }
        this.mixer.draw(matrixStack, this.getBackground().getWidth() / 2 + 3, 34);
    }

    static enum MixingType {
        AUTO_SHAPELESS,
        MIXING,
        AUTO_BREWING;

    }
}

