/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllKeys;
import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.AllStitchedTextures;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.structureMovement.glue.SuperGlueSelectionHandler;
import com.simibubi.create.content.contraptions.components.structureMovement.interaction.controls.TrainHUD;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderDispatcher;
import com.simibubi.create.content.contraptions.components.structureMovement.render.SBBContraptionManager;
import com.simibubi.create.content.contraptions.goggles.GoggleOverlayRenderer;
import com.simibubi.create.content.contraptions.relays.encased.CasingConnectivity;
import com.simibubi.create.content.curiosities.armor.CopperBacktankArmorLayer;
import com.simibubi.create.content.curiosities.bell.SoulPulseEffectHandler;
import com.simibubi.create.content.curiosities.toolbox.ToolboxHandlerClient;
import com.simibubi.create.content.curiosities.tools.BlueprintOverlayRenderer;
import com.simibubi.create.content.curiosities.weapons.PotatoCannonRenderHandler;
import com.simibubi.create.content.curiosities.zapper.ZapperRenderHandler;
import com.simibubi.create.content.logistics.item.LinkedControllerClientHandler;
import com.simibubi.create.content.logistics.trains.GlobalRailwayManager;
import com.simibubi.create.content.schematics.ClientSchematicLoader;
import com.simibubi.create.content.schematics.client.SchematicAndQuillHandler;
import com.simibubi.create.content.schematics.client.SchematicHandler;
import com.simibubi.create.foundation.ClientResourceReloadListener;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.ponder.content.PonderIndex;
import com.simibubi.create.foundation.ponder.element.WorldSectionElement;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.CreateContexts;
import com.simibubi.create.foundation.render.SuperByteBufferCache;
import com.simibubi.create.foundation.utility.ModelSwapper;
import com.simibubi.create.foundation.utility.ShippedResourcePacks;
import com.simibubi.create.foundation.utility.ghost.GhostBlocks;
import com.simibubi.create.foundation.utility.outliner.Outliner;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class CreateClient {
    public static final SuperByteBufferCache BUFFER_CACHE = new SuperByteBufferCache();
    public static final Outliner OUTLINER = new Outliner();
    public static final GhostBlocks GHOST_BLOCKS = new GhostBlocks();
    public static final ModelSwapper MODEL_SWAPPER = new ModelSwapper();
    public static final CasingConnectivity CASING_CONNECTIVITY = new CasingConnectivity();
    public static final ClientSchematicLoader SCHEMATIC_SENDER = new ClientSchematicLoader();
    public static final SchematicHandler SCHEMATIC_HANDLER = new SchematicHandler();
    public static final SchematicAndQuillHandler SCHEMATIC_AND_QUILL_HANDLER = new SchematicAndQuillHandler();
    public static final SuperGlueSelectionHandler GLUE_HANDLER = new SuperGlueSelectionHandler();
    public static final ZapperRenderHandler ZAPPER_RENDER_HANDLER = new ZapperRenderHandler();
    public static final PotatoCannonRenderHandler POTATO_CANNON_RENDER_HANDLER = new PotatoCannonRenderHandler();
    public static final SoulPulseEffectHandler SOUL_PULSE_EFFECT_HANDLER = new SoulPulseEffectHandler();
    public static final GlobalRailwayManager RAILWAYS = new GlobalRailwayManager();
    public static final ClientResourceReloadListener RESOURCE_RELOAD_LISTENER = new ClientResourceReloadListener();

    public static void onCtorClient(IEventBus modEventBus, IEventBus forgeEventBus) {
        modEventBus.addListener(CreateClient::clientInit);
        modEventBus.addListener(AllParticleTypes::registerFactories);
        modEventBus.addListener(CreateContexts::flwInit);
        modEventBus.addListener(ContraptionRenderDispatcher::gatherContext);
        MODEL_SWAPPER.registerListeners(modEventBus);
        ZAPPER_RENDER_HANDLER.registerListeners(forgeEventBus);
        POTATO_CANNON_RENDER_HANDLER.registerListeners(forgeEventBus);
    }

    public static void clientInit(FMLClientSetupEvent event) {
        BUFFER_CACHE.registerCompartment(CachedBufferer.GENERIC_TILE);
        BUFFER_CACHE.registerCompartment(CachedBufferer.PARTIAL);
        BUFFER_CACHE.registerCompartment(CachedBufferer.DIRECTIONAL_PARTIAL);
        BUFFER_CACHE.registerCompartment(KineticTileEntityRenderer.KINETIC_TILE);
        BUFFER_CACHE.registerCompartment(SBBContraptionManager.CONTRAPTION, 20L);
        BUFFER_CACHE.registerCompartment(WorldSectionElement.DOC_WORLD_SECTION, 20L);
        ShippedResourcePacks.extractFiles("Copper Legacy Pack");
        AllKeys.register();
        AllBlockPartials.init();
        AllStitchedTextures.init();
        PonderIndex.register();
        PonderIndex.registerTags();
        CreateClient.registerOverlays();
        UIRenderHelper.init();
    }

    private static void registerOverlays() {
        OverlayRegistry.registerOverlayAbove((IIngameOverlay)ForgeIngameGui.AIR_LEVEL_ELEMENT, (String)"Create's Remaining Air", (IIngameOverlay)CopperBacktankArmorLayer.REMAINING_AIR_OVERLAY);
        OverlayRegistry.registerOverlayAbove((IIngameOverlay)ForgeIngameGui.EXPERIENCE_BAR_ELEMENT, (String)"Create's Train Driver HUD", (IIngameOverlay)TrainHUD.OVERLAY);
        OverlayRegistry.registerOverlayAbove((IIngameOverlay)ForgeIngameGui.HOTBAR_ELEMENT, (String)"Create's Goggle Information", (IIngameOverlay)GoggleOverlayRenderer.OVERLAY);
        OverlayRegistry.registerOverlayAbove((IIngameOverlay)ForgeIngameGui.HOTBAR_ELEMENT, (String)"Create's Blueprints", (IIngameOverlay)BlueprintOverlayRenderer.OVERLAY);
        OverlayRegistry.registerOverlayAbove((IIngameOverlay)ForgeIngameGui.HOTBAR_ELEMENT, (String)"Create's Linked Controller", (IIngameOverlay)LinkedControllerClientHandler.OVERLAY);
        OverlayRegistry.registerOverlayAbove((IIngameOverlay)ForgeIngameGui.HOTBAR_ELEMENT, (String)"Create's Schematics", (IIngameOverlay)SCHEMATIC_HANDLER.getOverlayRenderer());
        OverlayRegistry.registerOverlayAbove((IIngameOverlay)ForgeIngameGui.HOTBAR_ELEMENT, (String)"Create's Toolboxes", (IIngameOverlay)ToolboxHandlerClient.OVERLAY);
    }

    public static void invalidateRenderers() {
        BUFFER_CACHE.invalidate();
        SCHEMATIC_HANDLER.updateRenderers();
        ContraptionRenderDispatcher.reset();
    }

    public static void checkGraphicsFanciness() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (mc.f_91066_.f_92115_ != GraphicsStatus.FABULOUS) {
            return;
        }
        if (((Boolean)AllConfigs.CLIENT.ignoreFabulousWarning.get()).booleanValue()) {
            return;
        }
        MutableComponent text = ComponentUtils.m_130748_((Component)new TextComponent("WARN")).m_130940_(ChatFormatting.GOLD).m_7220_((Component)new TextComponent(" Some of Create's visual features will not be available while Fabulous graphics are enabled!")).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/create dismissFabulousWarning")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Click here to disable this warning"))));
        mc.f_91065_.m_93051_(ChatType.CHAT, (Component)text, mc.f_91074_.m_142081_());
    }
}

