/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.layout;

import com.jozufozu.flywheel.backend.gl.GlNumericType;
import com.jozufozu.flywheel.core.layout.LayoutItem;
import org.lwjgl.opengl.GL20;

public enum MatrixItems implements LayoutItem
{
    MAT3(3, 3),
    MAT4(4, 4);

    private final int rows;
    private final int cols;

    private MatrixItems(int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
    }

    @Override
    public void vertexAttribPointer(int stride, int index, int offset) {
        for (int i = 0; i < this.rows; ++i) {
            long attribPointer = (long)offset + (long)i * (long)this.cols * (long)GlNumericType.FLOAT.getByteWidth();
            GL20.glVertexAttribPointer((int)(index + i), (int)this.cols, (int)GlNumericType.FLOAT.getGlEnum(), (boolean)false, (int)stride, (long)attribPointer);
        }
    }

    @Override
    public int size() {
        return GlNumericType.FLOAT.getByteWidth() * this.rows * this.cols;
    }

    @Override
    public int attributeCount() {
        return this.rows;
    }
}

