/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.speaker;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.network.NetworkHandler;
import dan200.computercraft.shared.network.client.SpeakerStopClientMessage;
import dan200.computercraft.shared.peripheral.speaker.SpeakerPeripheral;
import dan200.computercraft.shared.util.CapabilityUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileSpeaker
extends TileGeneric {
    private final SpeakerPeripheral peripheral = new Peripheral(this);
    private LazyOptional<IPeripheral> peripheralCap;

    public TileSpeaker(BlockEntityType<TileSpeaker> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void serverTick() {
        this.peripheral.update();
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            NetworkHandler.sendToAllPlayers(new SpeakerStopClientMessage(this.peripheral.getSource()));
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == Capabilities.CAPABILITY_PERIPHERAL) {
            if (this.peripheralCap == null) {
                this.peripheralCap = LazyOptional.of(() -> this.peripheral);
            }
            return this.peripheralCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.peripheralCap = CapabilityUtil.invalidate(this.peripheralCap);
    }

    private static final class Peripheral
    extends SpeakerPeripheral {
        private final TileSpeaker speaker;

        private Peripheral(TileSpeaker speaker) {
            this.speaker = speaker;
        }

        @Override
        public Level getLevel() {
            return this.speaker.m_58904_();
        }

        @Override
        @Nonnull
        public Vec3 getPosition() {
            BlockPos pos = this.speaker.m_58899_();
            return new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        }

        @Override
        public boolean equals(@Nullable IPeripheral other) {
            return this == other || other instanceof Peripheral && this.speaker == ((Peripheral)other).speaker;
        }
    }
}

