/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import dan200.computercraft.ComputerCraft;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

abstract class LootTableProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator generator;

    LootTableProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_6865_(@Nonnull HashCache cache) {
        HashMap<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();
        ValidationContext validation = new ValidationContext(LootContextParamSets.f_81420_, x -> null, tables::get);
        this.registerLoot((id, table) -> {
            if (tables.containsKey(id)) {
                validation.m_79357_("Duplicate loot tables for " + id);
            }
            tables.put((ResourceLocation)id, (LootTable)table);
        });
        tables.forEach((key, value) -> LootTables.m_79202_((ValidationContext)validation, (ResourceLocation)key, (LootTable)value));
        Multimap problems = validation.m_79352_();
        if (!problems.isEmpty()) {
            problems.forEach((child, problem) -> ComputerCraft.log.warn("Found validation problem in " + child + ": " + problem));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        tables.forEach((key, value) -> {
            Path path = this.getPath((ResourceLocation)key);
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)LootTables.m_79200_((LootTable)value), (Path)path);
            }
            catch (IOException e) {
                ComputerCraft.log.error("Couldn't save loot table {}", (Object)path, (Object)e);
            }
        });
    }

    protected abstract void registerLoot(BiConsumer<ResourceLocation, LootTable> var1);

    @Nonnull
    public String m_6055_() {
        return "LootTables";
    }

    private Path getPath(ResourceLocation id) {
        return this.generator.m_123916_().resolve("data").resolve(id.m_135827_()).resolve("loot_tables").resolve(id.m_135815_() + ".json");
    }
}

