/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.config.IEditModeConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.render.IngredientListElementRenderer;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.RenderProperties;

public class ItemStackFastRenderer
extends IngredientListElementRenderer<ItemStack> {
    public ItemStackFastRenderer(IIngredientListElement<ItemStack> itemStackElement) {
        super(itemStackElement);
    }

    public void renderItemAndEffectIntoGUI(MultiBufferSource buffer, PoseStack poseStack, IEditModeConfig editModeConfig, IWorldConfig worldConfig) {
        try {
            this.uncheckedRenderItemAndEffectIntoGUI(buffer, poseStack, editModeConfig, worldConfig);
        }
        catch (LinkageError | RuntimeException e) {
            throw ErrorUtil.createRenderIngredientException(e, (ItemStack)this.element.getIngredient());
        }
    }

    private void uncheckedRenderItemAndEffectIntoGUI(MultiBufferSource buffer, PoseStack poseStack, IEditModeConfig editModeConfig, IWorldConfig worldConfig) {
        if (worldConfig.isEditModeEnabled()) {
            this.renderEditMode(poseStack, this.area, this.padding, editModeConfig);
            RenderSystem.m_69478_();
        }
        Minecraft minecraft = Minecraft.m_91087_();
        ItemRenderer itemRenderer = minecraft.m_91291_();
        ItemStack itemStack = (ItemStack)this.element.getIngredient();
        BakedModel bakedModel = itemRenderer.m_174264_(itemStack, null, null, 0);
        poseStack.m_85836_();
        poseStack.m_85837_((double)(this.area.m_110085_() + this.padding) / 16.0, (double)(this.area.m_110086_() + this.padding) / -16.0, 0.0);
        itemRenderer.m_115143_(itemStack, ItemTransforms.TransformType.GUI, false, poseStack, buffer, 0xF000F0, OverlayTexture.f_118083_, bakedModel);
        poseStack.m_85849_();
    }

    public void renderOverlay() {
        ItemStack itemStack = (ItemStack)this.element.getIngredient();
        try {
            ItemStackFastRenderer.renderOverlay(itemStack, this.area, this.padding);
        }
        catch (LinkageError | RuntimeException e) {
            throw ErrorUtil.createRenderIngredientException(e, (ItemStack)this.element.getIngredient());
        }
    }

    private static void renderOverlay(ItemStack itemStack, Rect2i area, int padding) {
        Font font = ItemStackFastRenderer.getFontRenderer(itemStack);
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        itemRenderer.m_115174_(font, itemStack, area.m_110085_() + padding, area.m_110086_() + padding, null);
    }

    public static Font getFontRenderer(ItemStack itemStack) {
        Font fontRenderer = RenderProperties.get((ItemStack)itemStack).getFont(itemStack);
        if (fontRenderer == null) {
            fontRenderer = Minecraft.m_91087_().f_91062_;
        }
        return fontRenderer;
    }
}

