/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.ingredients.item;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.color.ColorGetter;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.StackHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemStackHelper
implements IIngredientHelper<ItemStack> {
    private final StackHelper stackHelper;

    public ItemStackHelper(StackHelper stackHelper) {
        this.stackHelper = stackHelper;
    }

    @Override
    public IIngredientType<ItemStack> getIngredientType() {
        return VanillaTypes.ITEM;
    }

    @Override
    public IFocus<?> translateFocus(IFocus<ItemStack> focus, IFocusFactory focusFactory) {
        IFluidBlock fluidBlock;
        Fluid fluid;
        Block block;
        ItemStack itemStack = focus.getValue();
        Item item = itemStack.m_41720_();
        if (item instanceof BlockItem && (block = ((BlockItem)item).m_40614_()) instanceof IFluidBlock && (fluid = (fluidBlock = (IFluidBlock)block).getFluid()) != null) {
            FluidStack fluidStack = new FluidStack(fluid, 1000);
            return focusFactory.createFocus(focus.getMode(), fluidStack);
        }
        return focus;
    }

    @Override
    @Nullable
    public ItemStack getMatch(Iterable<ItemStack> ingredients, ItemStack toMatch, UidContext context) {
        for (ItemStack stack : ingredients) {
            if (!this.stackHelper.isEquivalent(toMatch, stack, context)) continue;
            return stack;
        }
        return null;
    }

    @Override
    public String getDisplayName(ItemStack ingredient) {
        Component displayNameTextComponent = ingredient.m_41786_();
        String displayName = displayNameTextComponent.getString();
        ErrorUtil.checkNotNull(displayName, "itemStack.getDisplayName()");
        return displayName;
    }

    @Override
    public String getUniqueId(ItemStack ingredient, UidContext context) {
        ErrorUtil.checkNotEmpty(ingredient);
        return this.stackHelper.getUniqueIdentifierForStack(ingredient, context);
    }

    @Override
    public String getWildcardId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty(ingredient);
        return StackHelper.getRegistryNameForStack(ingredient);
    }

    @Override
    public String getModId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty(ingredient);
        Item item = ingredient.m_41720_();
        ResourceLocation itemName = item.getRegistryName();
        if (itemName == null) {
            String stackInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("item.getRegistryName() returned null for: " + stackInfo);
        }
        return itemName.m_135827_();
    }

    @Override
    public String getDisplayModId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty(ingredient);
        Item item = ingredient.m_41720_();
        String modId = item.getCreatorModId(ingredient);
        if (modId == null) {
            String stackInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("item.getCreatorModId() returned null for: " + stackInfo);
        }
        return modId;
    }

    @Override
    public Iterable<Integer> getColors(ItemStack ingredient) {
        return ColorGetter.getColors(ingredient, 2);
    }

    @Override
    public String getResourceId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty(ingredient);
        Item item = ingredient.m_41720_();
        ResourceLocation itemName = item.getRegistryName();
        if (itemName == null) {
            String stackInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("item.getRegistryName() returned null for: " + stackInfo);
        }
        return itemName.m_135815_();
    }

    @Override
    public ItemStack getCheatItemStack(ItemStack ingredient) {
        return ingredient;
    }

    @Override
    public ItemStack copyIngredient(ItemStack ingredient) {
        return ingredient.m_41777_();
    }

    @Override
    public ItemStack normalizeIngredient(ItemStack ingredient) {
        ItemStack copy = ingredient.m_41777_();
        copy.m_41764_(1);
        return copy;
    }

    @Override
    public boolean isValidIngredient(ItemStack ingredient) {
        return !ingredient.m_41619_();
    }

    @Override
    public boolean isIngredientOnServer(ItemStack ingredient) {
        Item item = ingredient.m_41720_();
        return ForgeRegistries.ITEMS.containsValue((IForgeRegistryEntry)item);
    }

    @Override
    public Collection<ResourceLocation> getTags(ItemStack ingredient) {
        return ingredient.m_41720_().getTags();
    }

    @Override
    public Collection<String> getCreativeTabNames(ItemStack ingredient) {
        ArrayList<String> creativeTabsStrings = new ArrayList<String>();
        Item item = ingredient.m_41720_();
        for (CreativeModeTab itemGroup : item.getCreativeTabs()) {
            if (itemGroup == null) continue;
            String creativeTabName = itemGroup.m_40786_().getString();
            creativeTabsStrings.add(creativeTabName);
        }
        return creativeTabsStrings;
    }

    @Override
    public String getErrorInfo(@Nullable ItemStack ingredient) {
        return ErrorUtil.getItemStackInfo(ingredient);
    }
}

