/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.config.IClientConfig;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.Focus;
import mezz.jei.gui.HoverChecker;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.elements.DrawableNineSliceTexture;
import mezz.jei.gui.elements.GuiIconButtonSmall;
import mezz.jei.gui.ingredients.GuiIngredient;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.IRecipeLogicStateListener;
import mezz.jei.gui.recipes.RecipeCatalysts;
import mezz.jei.gui.recipes.RecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeGuiTabs;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.gui.recipes.RecipeTransferButton;
import mezz.jei.gui.textures.Textures;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.ingredients.IngredientTypeHelper;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IRecipeFocusSource;
import mezz.jei.input.MouseUtil;
import mezz.jei.input.UserInput;
import mezz.jei.input.mouse.IUserInputHandler;
import mezz.jei.recipes.RecipeTransferManager;
import mezz.jei.runtime.JeiRuntime;
import mezz.jei.transfer.RecipeTransferUtil;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.MathUtil;
import mezz.jei.util.Rectangle2dBuilder;
import mezz.jei.util.StringUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class RecipesGui
extends Screen
implements IRecipesGui,
IRecipeFocusSource,
IRecipeLogicStateListener {
    private static final int borderPadding = 6;
    private static final int innerPadding = 14;
    private static final int buttonWidth = 13;
    private static final int buttonHeight = 13;
    private final RecipeTransferManager recipeTransferManager;
    private final IClientConfig clientConfig;
    private int headerHeight;
    private final IRecipeGuiLogic logic;
    private final List<RecipeLayout<?>> recipeLayouts = new ArrayList();
    private String pageString = "1/1";
    private Component title = TextComponent.f_131282_;
    private final DrawableNineSliceTexture background;
    private final RecipeCatalysts recipeCatalysts;
    private final RecipeGuiTabs recipeGuiTabs;
    private final HoverChecker titleHoverChecker = new HoverChecker();
    private final GuiIconButtonSmall nextRecipeCategory;
    private final GuiIconButtonSmall previousRecipeCategory;
    private final GuiIconButtonSmall nextPage;
    private final GuiIconButtonSmall previousPage;
    @Nullable
    private Screen parentScreen;
    private Rect2i area = new Rect2i(0, 0, 0, 0);
    private Rect2i titleArea = new Rect2i(0, 0, 0, 0);
    private boolean init = false;

    public RecipesGui(IRecipeManager recipeManager, RecipeTransferManager recipeTransferManager, IngredientManager ingredientManager, IModIdHelper modIdHelper, IClientConfig clientConfig) {
        super((Component)new TextComponent("Recipes"));
        this.recipeTransferManager = recipeTransferManager;
        this.clientConfig = clientConfig;
        this.logic = new RecipeGuiLogic(recipeManager, recipeTransferManager, this, ingredientManager, modIdHelper);
        this.recipeCatalysts = new RecipeCatalysts();
        this.recipeGuiTabs = new RecipeGuiTabs(this.logic);
        this.f_96541_ = Minecraft.m_91087_();
        Textures textures = Internal.getTextures();
        IDrawableStatic arrowNext = textures.getArrowNext();
        IDrawableStatic arrowPrevious = textures.getArrowPrevious();
        this.nextRecipeCategory = new GuiIconButtonSmall(0, 0, 13, 13, arrowNext, b -> this.logic.nextRecipeCategory());
        this.previousRecipeCategory = new GuiIconButtonSmall(0, 0, 13, 13, arrowPrevious, b -> this.logic.previousRecipeCategory());
        this.nextPage = new GuiIconButtonSmall(0, 0, 13, 13, arrowNext, b -> this.logic.nextPage());
        this.previousPage = new GuiIconButtonSmall(0, 0, 13, 13, arrowPrevious, b -> this.logic.previousPage());
        this.background = textures.getGuiBackground();
    }

    private static void drawCenteredStringWithShadow(PoseStack poseStack, Font font, String string, Rect2i area) {
        Rect2i textArea = MathUtil.centerTextArea(area, font, string);
        font.m_92750_(poseStack, string, (float)textArea.m_110085_(), (float)textArea.m_110086_(), -1);
    }

    private static void drawCenteredStringWithShadow(PoseStack poseStack, Font font, Component text, Rect2i area) {
        Rect2i textArea = MathUtil.centerTextArea(area, font, (FormattedText)text);
        font.m_92763_(poseStack, text, (float)textArea.m_110085_(), (float)textArea.m_110086_(), -1);
    }

    public Rect2i getArea() {
        return this.area;
    }

    public int getRecipeCatalystExtraWidth() {
        if (this.recipeCatalysts.isEmpty()) {
            return 0;
        }
        return this.recipeCatalysts.getWidth();
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7856_() {
        super.m_7856_();
        int xSize = 198;
        int ySize = this.f_96544_ - 68;
        int extraSpace = 0;
        int maxHeight = this.clientConfig.getMaxRecipeGuiHeight();
        if (ySize > maxHeight) {
            extraSpace = ySize - maxHeight;
            ySize = maxHeight;
        }
        int guiLeft = (this.f_96543_ - 198) / 2;
        int guiTop = 45 + extraSpace / 2;
        this.area = new Rect2i(guiLeft, guiTop, 198, ySize);
        int rightButtonX = guiLeft + 198 - 6 - 13;
        int leftButtonX = guiLeft + 6;
        Objects.requireNonNull(this.f_96547_);
        int titleHeight = 9 + 6;
        int recipeClassButtonTop = guiTop + titleHeight - 13 + 2;
        this.nextRecipeCategory.f_93620_ = rightButtonX;
        this.nextRecipeCategory.f_93621_ = recipeClassButtonTop;
        this.previousRecipeCategory.f_93620_ = leftButtonX;
        this.previousRecipeCategory.f_93621_ = recipeClassButtonTop;
        int pageButtonTop = recipeClassButtonTop + 13 + 2;
        this.nextPage.f_93620_ = rightButtonX;
        this.nextPage.f_93621_ = pageButtonTop;
        this.previousPage.f_93620_ = leftButtonX;
        this.previousPage.f_93621_ = pageButtonTop;
        this.headerHeight = pageButtonTop + 13 - guiTop;
        int titleX = this.previousRecipeCategory.f_93620_ + this.previousRecipeCategory.m_5711_();
        this.titleArea = new Rectangle2dBuilder(titleX, recipeClassButtonTop, this.nextRecipeCategory.f_93620_ - titleX, titleHeight).insetByPadding(14).build();
        this.m_142416_((GuiEventListener)this.nextRecipeCategory);
        this.m_142416_((GuiEventListener)this.previousRecipeCategory);
        this.m_142416_((GuiEventListener)this.nextPage);
        this.m_142416_((GuiEventListener)this.previousPage);
        this.init = true;
        this.updateLayout();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.f_96541_ == null) {
            return;
        }
        this.m_7333_(poseStack);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = this.area.m_110085_();
        int y = this.area.m_110086_();
        int width = this.area.m_110090_();
        int height = this.area.m_110091_();
        this.background.draw(poseStack, x, y, width, height);
        RenderSystem.m_69461_();
        RecipesGui.m_93172_((PoseStack)poseStack, (int)(x + 6 + 13), (int)this.nextRecipeCategory.f_93621_, (int)(x + width - 6 - 13), (int)(this.nextRecipeCategory.f_93621_ + 13), (int)0x30000000);
        RecipesGui.m_93172_((PoseStack)poseStack, (int)(x + 6 + 13), (int)this.nextPage.f_93621_, (int)(x + width - 6 - 13), (int)(this.nextPage.f_93621_ + 13), (int)0x30000000);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RecipesGui.drawCenteredStringWithShadow(poseStack, this.f_96547_, this.title, this.titleArea);
        Rect2i pageArea = MathUtil.union(this.previousPage.getArea(), this.nextPage.getArea());
        RecipesGui.drawCenteredStringWithShadow(poseStack, this.f_96547_, this.pageString, pageArea);
        this.nextRecipeCategory.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.previousRecipeCategory.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.nextPage.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.previousPage.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        RecipeLayout<?> hoveredLayout = null;
        for (RecipeLayout<?> recipeLayout : this.recipeLayouts) {
            if (recipeLayout.isMouseOver(mouseX, mouseY)) {
                hoveredLayout = recipeLayout;
            }
            recipeLayout.drawRecipe(poseStack, mouseX, mouseY);
        }
        GuiIngredient<?> hoveredRecipeCatalyst = this.recipeCatalysts.draw(poseStack, mouseX, mouseY);
        this.recipeGuiTabs.draw(this.f_96541_, poseStack, mouseX, mouseY);
        if (hoveredLayout != null) {
            hoveredLayout.drawOverlays(poseStack, mouseX, mouseY);
        }
        if (hoveredRecipeCatalyst != null) {
            hoveredRecipeCatalyst.drawOverlays(poseStack, 0, 0, mouseX, mouseY);
        }
        if (this.titleHoverChecker.checkHover(mouseX, mouseY) && !this.logic.hasAllCategories()) {
            TranslatableComponent showAllRecipesString = new TranslatableComponent("jei.tooltip.show.all.recipes");
            TooltipRenderer.drawHoveringText(poseStack, List.of(showAllRecipesString), mouseX, mouseY);
        }
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        if (this.f_96541_ != null && this.f_96541_.f_91080_ == this) {
            if (MathUtil.contains(this.area, mouseX, mouseY)) {
                return true;
            }
            for (RecipeLayout<?> recipeLayout : this.recipeLayouts) {
                if (!recipeLayout.isMouseOver(mouseX, mouseY)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.isOpen()) {
            IClickedIngredient<?> clicked = this.recipeCatalysts.getIngredientUnderMouse(mouseX, mouseY);
            if (clicked == null && this.m_5953_(mouseX, mouseY)) {
                clicked = this.getRecipeLayoutsIngredientUnderMouse(mouseX, mouseY);
            }
            if (clicked != null) {
                clicked.canSetFocusWithMouse();
                return clicked;
            }
        }
        return null;
    }

    @Nullable
    private IClickedIngredient<?> getRecipeLayoutsIngredientUnderMouse(double mouseX, double mouseY) {
        for (RecipeLayout<?> recipeLayout : this.recipeLayouts) {
            Object displayedIngredient;
            GuiIngredient<?> clicked = recipeLayout.getGuiIngredientUnderMouse(mouseX, mouseY);
            if (clicked == null || (displayedIngredient = clicked.getDisplayedIngredient()) == null) continue;
            Rect2i area = clicked.getRect();
            area = new Rect2i(area.m_110085_() + recipeLayout.getPosX(), area.m_110086_() + recipeLayout.getPosY(), area.m_110090_(), area.m_110091_());
            return ClickedIngredient.create(displayedIngredient, area);
        }
        return null;
    }

    public boolean m_6050_(double scrollX, double scrollY, double scrollDelta) {
        double y;
        double x = MouseUtil.getX();
        if (this.m_5953_(x, y = MouseUtil.getY())) {
            if (scrollDelta < 0.0) {
                this.logic.nextPage();
                return true;
            }
            if (scrollDelta > 0.0) {
                this.logic.previousPage();
                return true;
            }
        }
        return super.m_6050_(scrollX, scrollY, scrollDelta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        UserInput input = UserInput.fromVanilla(mouseX, mouseY, mouseButton);
        if (input != null) {
            return this.handleInput(input) || super.m_6375_(mouseX, mouseY, mouseButton);
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        UserInput input = UserInput.fromVanilla(keyCode, scanCode, modifiers);
        return this.handleInput(input);
    }

    private boolean handleInput(UserInput input) {
        IngredientListOverlay itemListOverlay;
        IUserInputHandler handler;
        double mouseY;
        double mouseX = input.getMouseX();
        if (this.m_5953_(mouseX, mouseY = input.getMouseY())) {
            if (this.titleHoverChecker.checkHover(mouseX, mouseY)) {
                if (input.isLeftClick() && this.logic.setCategoryFocus()) {
                    return true;
                }
            } else {
                for (RecipeLayout<?> recipeLayout : this.recipeLayouts) {
                    if (!recipeLayout.handleInput(input)) continue;
                    return true;
                }
            }
        }
        if ((handler = this.recipeGuiTabs.getInputHandler()).handleUserInput(this, input) != null) {
            return true;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (input.isEscapeKey() || input.is(minecraft.f_91066_.f_92092_)) {
            this.m_7379_();
            return true;
        }
        if (input.is(KeyBindings.recipeBack)) {
            this.back();
            return true;
        }
        if (input.is(KeyBindings.nextCategory)) {
            this.logic.nextRecipeCategory();
            return true;
        }
        if (input.is(KeyBindings.previousCategory)) {
            this.logic.previousRecipeCategory();
            return true;
        }
        JeiRuntime runtime = Internal.getRuntime();
        if (runtime != null && !(itemListOverlay = runtime.getIngredientListOverlay()).isMouseOver(mouseX, mouseY)) {
            if (input.is(KeyBindings.nextRecipePage)) {
                this.logic.nextPage();
                return true;
            }
            if (input.is(KeyBindings.previousRecipePage)) {
                this.logic.previousPage();
                return true;
            }
        }
        return false;
    }

    public boolean isOpen() {
        return this.f_96541_ != null && this.f_96541_.f_91080_ == this;
    }

    private void open() {
        if (this.f_96541_ != null) {
            if (!this.isOpen()) {
                this.parentScreen = this.f_96541_.f_91080_;
            }
            this.f_96541_.m_91152_((Screen)this);
        }
    }

    public void m_7379_() {
        if (this.isOpen() && this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parentScreen);
            this.parentScreen = null;
            this.logic.clearHistory();
            return;
        }
        super.m_7379_();
    }

    @Override
    public <V> void show(IFocus<V> focus) {
        Focus<V> checkedFocus = Focus.check(focus);
        if (this.logic.setFocus(checkedFocus)) {
            this.open();
        }
    }

    @Override
    public void showCategories(List<ResourceLocation> recipeCategoryUids) {
        ErrorUtil.checkNotEmpty(recipeCategoryUids, "recipeCategoryUids");
        if (this.logic.setCategoryFocus(recipeCategoryUids)) {
            this.open();
        }
    }

    @Override
    @Nullable
    public <T> T getIngredientUnderMouse(IIngredientType<T> ingredientType) {
        double x = MouseUtil.getX();
        double y = MouseUtil.getY();
        IClickedIngredient<?> ingredient = this.getIngredientUnderMouse(x, y);
        return Optional.ofNullable(ingredient).map(i -> IngredientTypeHelper.checkedCast(i, ingredientType)).map(IClickedIngredient::getValue).orElse(null);
    }

    public void back() {
        this.logic.back();
    }

    private void updateLayout() {
        int heightPerRecipe;
        if (!this.init) {
            return;
        }
        IRecipeCategory<?> recipeCategory = this.logic.getSelectedRecipeCategory();
        IDrawable recipeBackground = recipeCategory.getBackground();
        int x = this.area.m_110085_();
        int y = this.area.m_110086_();
        int width = this.area.m_110090_();
        int height = this.area.m_110091_();
        int availableHeight = height - this.headerHeight;
        int recipesPerPage = availableHeight / (heightPerRecipe = recipeBackground.getHeight() + 14);
        if (recipesPerPage == 0) {
            availableHeight = heightPerRecipe;
            recipesPerPage = 1;
        }
        int recipeXOffset = x + (width - recipeBackground.getWidth()) / 2;
        int recipeSpacing = (availableHeight - recipesPerPage * recipeBackground.getHeight()) / (recipesPerPage + 1);
        this.logic.setRecipesPerPage(recipesPerPage);
        this.title = StringUtil.stripStyling(recipeCategory.getTitle());
        int availableTitleWidth = this.titleArea.m_110090_();
        if (this.f_96547_.m_92852_((FormattedText)this.title) > availableTitleWidth) {
            this.title = StringUtil.truncateStringToWidth(this.title, availableTitleWidth, this.f_96547_);
        }
        Rect2i titleStringArea = MathUtil.centerTextArea(this.titleArea, this.f_96547_, (FormattedText)this.title);
        this.titleHoverChecker.updateBounds(titleStringArea);
        int spacingY = recipeBackground.getHeight() + recipeSpacing;
        this.recipeLayouts.clear();
        this.recipeLayouts.addAll(this.logic.getRecipeLayouts(recipeXOffset, y + this.headerHeight + recipeSpacing, spacingY));
        this.addRecipeTransferButtons(this.recipeLayouts);
        this.nextPage.f_93623_ = this.previousPage.f_93623_ = this.logic.hasMultiplePages();
        this.nextRecipeCategory.f_93623_ = this.previousRecipeCategory.f_93623_ = this.logic.hasMultipleCategories();
        this.pageString = this.logic.getPageString();
        List<Object> recipeCatalysts = this.logic.getRecipeCatalysts();
        this.recipeCatalysts.updateLayout(recipeCatalysts, this);
        this.recipeGuiTabs.initLayout(this);
    }

    private void addRecipeTransferButtons(List<RecipeLayout<?>> recipeLayouts) {
        if (this.f_96541_ == null) {
            return;
        }
        LocalPlayer player = this.f_96541_.f_91074_;
        if (player == null) {
            return;
        }
        List<GuiEventListener> oldTransferButtons = this.m_6702_().stream().filter(widget -> widget instanceof RecipeTransferButton).toList();
        for (GuiEventListener button : oldTransferButtons) {
            this.m_169411_(button);
        }
        AbstractContainerMenu container = this.getParentContainer();
        for (RecipeLayout<?> recipeLayout : recipeLayouts) {
            RecipeTransferButton button = recipeLayout.getRecipeTransferButton();
            if (button == null) continue;
            button.init(this.recipeTransferManager, container, (Player)player);
            button.setOnClickHandler((arg_0, arg_1) -> this.lambda$addRecipeTransferButtons$6(container, recipeLayout, (Player)player, arg_0, arg_1));
            this.m_142416_((GuiEventListener)button);
        }
    }

    @Nullable
    private AbstractContainerMenu getParentContainer() {
        Screen screen = this.parentScreen;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            return screen2.m_6262_();
        }
        return null;
    }

    @Override
    public void onStateChange() {
        this.updateLayout();
    }

    private /* synthetic */ void lambda$addRecipeTransferButtons$6(AbstractContainerMenu container, RecipeLayout recipeLayout, Player player, double mouseX, double mouseY) {
        boolean maxTransfer = Screen.m_96638_();
        if (container != null && RecipeTransferUtil.transferRecipe(this.recipeTransferManager, container, recipeLayout, player, maxTransfer)) {
            this.m_7379_();
        }
    }
}

