/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.bookmarks;

import java.util.List;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.bookmarks.BookmarkList;
import mezz.jei.config.IWorldConfig;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.overlay.bookmarks.BookmarkOverlay;
import mezz.jei.gui.textures.Textures;
import mezz.jei.input.UserInput;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class BookmarkButton
extends GuiIconToggleButton {
    private final BookmarkOverlay bookmarkOverlay;
    private final BookmarkList bookmarkList;
    private final IWorldConfig worldConfig;

    public static BookmarkButton create(BookmarkOverlay bookmarkOverlay, BookmarkList bookmarkList, Textures textures, IWorldConfig worldConfig) {
        IDrawableStatic offIcon = textures.getBookmarkButtonDisabledIcon();
        IDrawableStatic onIcon = textures.getBookmarkButtonEnabledIcon();
        return new BookmarkButton(offIcon, onIcon, bookmarkOverlay, bookmarkList, worldConfig);
    }

    private BookmarkButton(IDrawable offIcon, IDrawable onIcon, BookmarkOverlay bookmarkOverlay, BookmarkList bookmarkList, IWorldConfig worldConfig) {
        super(offIcon, onIcon);
        this.bookmarkOverlay = bookmarkOverlay;
        this.bookmarkList = bookmarkList;
        this.worldConfig = worldConfig;
    }

    @Override
    protected void getTooltips(List<Component> tooltip) {
        tooltip.add((Component)new TranslatableComponent("jei.tooltip.bookmarks"));
        KeyMapping bookmarkKey = KeyBindings.bookmark;
        if (bookmarkKey.getKey().m_84873_() == -1) {
            TranslatableComponent noKey = new TranslatableComponent("jei.tooltip.bookmarks.usage.nokey");
            tooltip.add((Component)noKey.m_130940_(ChatFormatting.RED));
        } else if (!this.bookmarkOverlay.hasRoom()) {
            TranslatableComponent notEnoughSpace = new TranslatableComponent("jei.tooltip.bookmarks.not.enough.space");
            tooltip.add((Component)notEnoughSpace.m_130940_(ChatFormatting.GOLD));
        } else {
            TranslatableComponent key = new TranslatableComponent("jei.tooltip.bookmarks.usage.key", new Object[]{new TranslatableComponent(bookmarkKey.m_90865_())});
            tooltip.add((Component)key.m_130940_(ChatFormatting.GRAY));
        }
    }

    @Override
    protected boolean isIconToggledOn() {
        return this.bookmarkOverlay.isListDisplayed();
    }

    @Override
    protected boolean onMouseClicked(UserInput input) {
        if (!this.bookmarkList.isEmpty() && this.bookmarkOverlay.hasRoom()) {
            if (!input.isSimulate()) {
                this.worldConfig.toggleBookmarkEnabled();
            }
            return true;
        }
        return false;
    }
}

