/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.datagen.providers;

import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedBlockStateProvider
extends BlockStateProvider {
    private final ResourceLocation TEXTURE = this.modLoc("block/framed_block");

    public FramedBlockStateProvider(DataGenerator gen, ExistingFileHelper fileHelper) {
        super(gen, "framedblocks", fileHelper);
    }

    protected void registerStatesAndModels() {
        ModelBuilder cube = this.models().cubeAll("framed_cube", this.TEXTURE);
        this.simpleBlockWithItem(FBContent.blockFramedCube, (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.blockFramedSlope, (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.blockFramedCornerSlope, (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.blockFramedInnerCornerSlope, (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.blockFramedPrismCorner, (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.blockFramedInnerPrismCorner, (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.blockFramedThreewayCorner, (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.blockFramedInnerThreewayCorner, (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedSlabEdge.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedSlabCorner.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedPanel.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedCornerPillar.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedTrapDoor.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedWallSign.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedLattice.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedVerticalStairs.get(), (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.blockFramedDoubleSlab, (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.blockFramedDoublePanel, (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedDoubleSlope.get(), (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.blockFramedDoubleCorner, (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.blockFramedDoublePrismCorner, (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.blockFramedDoubleThreewayCorner, (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.blockFramedRailSlope, (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedPillar.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedHalfPillar.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedPost.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedHalfStairs.get(), (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.blockFramedPrism, (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.blockFramedSlopedPrism, (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.blockFramedSlopeSlab, (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.blockFramedElevatedSlopeSlab, (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.blockFramedDoubleSlopeSlab, (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.blockFramedInverseDoubleSlopeSlab, (ModelFile)cube);
        this.registerFramedSlab((ModelFile)cube);
        this.registerFramedStairs((ModelFile)cube);
        this.registerFramedWall((ModelFile)cube);
        this.registerFramedFence((ModelFile)cube);
        this.registerFramedGate((ModelFile)cube);
        this.registerFramedDoor((ModelFile)cube);
        this.registerFramedPressurePlate((ModelFile)cube);
        this.registerFramedLadder();
        this.registerFramedButton((ModelFile)cube);
        this.registerFramedLever();
        this.registerFramedSign((ModelFile)cube);
        this.registerFramedTorch();
        this.registerFramedWallTorch();
        this.registerFramedSoulTorch();
        this.registerFramedSoulWallTorch();
        this.registerFramedFloorBoard((ModelFile)cube);
        this.registerFramedChest();
        this.registerFramedBarsBlock((ModelFile)cube);
        this.registerFramedPaneBlock((ModelFile)cube);
        this.registerFramedFlowerPotBlock((ModelFile)cube);
        this.registerFramedCollapsibleBlock();
        this.registerFramedBouncyBlock();
        this.registerFramedSecretStorage();
    }

    private void registerFramedSlab(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedSlab.get(), cube);
        this.itemModels().slab("framed_slab", this.TEXTURE, this.TEXTURE, this.TEXTURE);
    }

    private void registerFramedStairs(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedStairs.get(), cube);
        this.itemModels().stairs("framed_stairs", this.TEXTURE, this.TEXTURE, this.TEXTURE);
    }

    private void registerFramedWall(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedWall.get(), cube);
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder("framed_wall")).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/wall_inventory")))).texture("wall", this.TEXTURE);
    }

    private void registerFramedFence(ModelFile cube) {
        this.getMultipartBuilder((Block)FBContent.blockFramedFence.get()).part().modelFile(cube).addModel();
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder("framed_fence")).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/fence_inventory")))).texture("texture", this.TEXTURE);
    }

    private void registerFramedGate(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedGate.get(), cube);
        this.itemModels().fenceGate("framed_gate", this.TEXTURE);
    }

    private void registerFramedDoor(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedDoor.get(), cube);
        this.itemModels().singleTexture("framed_door", this.mcLoc("item/generated"), "layer0", this.modLoc("item/framed_door"));
    }

    private void registerFramedPressurePlate(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedPressurePlate.get(), cube);
        ((ItemModelBuilder)this.itemModels().withExistingParent("framed_pressure_plate", this.mcLoc("block/pressure_plate_up"))).texture("texture", this.TEXTURE);
    }

    private void registerFramedLadder() {
        ModelBuilder ladder = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_ladder", this.mcLoc("block/cube"))).texture("0", this.TEXTURE)).texture("particle", this.TEXTURE)).element().face(Direction.NORTH).texture("#0").end().face(Direction.SOUTH).texture("#0").end().end();
        this.simpleBlockWithItem(FBContent.blockFramedLadder, (ModelFile)ladder);
    }

    private void registerFramedButton(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedButton.get(), cube);
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder("framed_button")).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/button_inventory")))).texture("texture", this.TEXTURE);
    }

    private void registerFramedLever() {
        ModelBuilder lever = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_lever", this.mcLoc("block/lever"))).texture("base", this.TEXTURE)).texture("particle", this.TEXTURE);
        ModelBuilder leverOn = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_lever_on", this.mcLoc("block/lever_on"))).texture("base", this.TEXTURE)).texture("particle", this.TEXTURE);
        this.getVariantBuilder((Block)FBContent.blockFramedLever.get()).forAllStates(arg_0 -> FramedBlockStateProvider.lambda$registerFramedLever$0((ModelFile)leverOn, (ModelFile)lever, arg_0));
        this.itemModels().singleTexture("framed_lever", this.mcLoc("item/generated"), "layer0", this.modLoc("item/framed_lever"));
    }

    private void registerFramedSign(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedSign.get(), cube);
        this.itemModels().singleTexture("framed_sign", this.mcLoc("item/generated"), "layer0", this.modLoc("item/framed_sign"));
    }

    private void registerFramedTorch() {
        ModelFile.ExistingModelFile torch = this.models().getExistingFile(this.modLoc("framed_torch"));
        this.simpleBlock((Block)FBContent.blockFramedTorch.get(), (ModelFile)torch);
        ((ItemModelBuilder)this.itemModels().withExistingParent("framed_torch", "item/generated")).texture("layer0", this.modLoc("block/framed_torch"));
    }

    private void registerFramedWallTorch() {
        ModelFile.ExistingModelFile wallTorch = this.models().getExistingFile(this.modLoc("framed_wall_torch"));
        this.getVariantBuilder((Block)FBContent.blockFramedWallTorch.get()).forAllStates(arg_0 -> FramedBlockStateProvider.lambda$registerFramedWallTorch$1((ModelFile)wallTorch, arg_0));
    }

    private void registerFramedSoulTorch() {
        ModelBuilder torch = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_soul_torch", this.modLoc("framed_torch"))).texture("torch", this.modLoc("block/framed_soul_torch"))).texture("particle", this.modLoc("block/framed_soul_torch"))).texture("top", this.mcLoc("block/soul_torch"));
        this.simpleBlock((Block)FBContent.blockFramedSoulTorch.get(), (ModelFile)torch);
        ((ItemModelBuilder)this.itemModels().withExistingParent("framed_soul_torch", "item/generated")).texture("layer0", this.modLoc("block/framed_soul_torch"));
    }

    private void registerFramedSoulWallTorch() {
        ModelBuilder wallTorch = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_soul_wall_torch", this.modLoc("framed_wall_torch"))).texture("torch", this.modLoc("block/framed_soul_torch"))).texture("particle", this.modLoc("block/framed_soul_torch"))).texture("top", this.mcLoc("block/soul_torch"));
        this.getVariantBuilder((Block)FBContent.blockFramedSoulWallTorch.get()).forAllStates(arg_0 -> FramedBlockStateProvider.lambda$registerFramedSoulWallTorch$2((ModelFile)wallTorch, arg_0));
    }

    private void registerFramedFloorBoard(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedFloor.get(), cube);
        this.itemModels().carpet("framed_floor_board", this.TEXTURE);
    }

    private void registerFramedChest() {
        ModelFile.ExistingModelFile chest = this.models().getExistingFile(this.modLoc("block/framed_chest"));
        this.getVariantBuilder((Block)FBContent.blockFramedChest.get()).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedChest$3((ModelFile)chest, arg_0), new Property[]{BlockStateProperties.f_61362_, PropertyHolder.LATCH_TYPE});
        this.simpleBlockItem((Block)FBContent.blockFramedChest.get(), (ModelFile)chest);
    }

    private void registerFramedBarsBlock(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedBars.get(), cube);
        ((ItemModelBuilder)this.itemModels().withExistingParent("framed_bars", "item/generated")).texture("layer0", this.modLoc("item/framed_bars"));
    }

    private void registerFramedPaneBlock(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedPane.get(), cube);
        ((ItemModelBuilder)this.itemModels().withExistingParent("framed_pane", "item/generated")).texture("layer0", this.TEXTURE);
    }

    private void registerFramedFlowerPotBlock(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedFlowerPot.get(), cube);
        ((ItemModelBuilder)this.itemModels().withExistingParent("framed_flower_pot", "item/generated")).texture("layer0", this.modLoc("item/framed_flower_pot"));
    }

    private void registerFramedCollapsibleBlock() {
        ModelBuilder block = this.models().cubeAll("framed_collapsible_block", this.modLoc("block/framed_collapsible_block"));
        this.simpleBlockWithItem(FBContent.blockFramedCollapsibleBlock, (ModelFile)block);
    }

    private void registerFramedBouncyBlock() {
        ModelBuilder block = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_bouncy_cube", "block/block")).element().cube("#slime").end()).element().cube("#frame").end()).texture("frame", this.TEXTURE)).texture("slime", this.mcLoc("block/slime_block"))).texture("particle", this.TEXTURE);
        this.simpleBlockWithItem(FBContent.blockFramedBouncyCube, (ModelFile)block);
        this.models().cubeAll("slime_frame", this.modLoc("block/slime_frame"));
    }

    private void registerFramedSecretStorage() {
        ModelBuilder block = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_secret_storage", "block/block")).element().cube("#barrel").face(Direction.UP).texture("#barrel_top").end().face(Direction.DOWN).texture("#barrel_bottom").end().end()).element().cube("#frame").end()).texture("barrel", this.mcLoc("block/barrel_side"))).texture("barrel_top", this.mcLoc("block/barrel_top"))).texture("barrel_bottom", this.mcLoc("block/barrel_bottom"))).texture("frame", this.TEXTURE)).texture("particle", this.TEXTURE);
        this.simpleBlockWithItem(FBContent.blockFramedSecretStorage, (ModelFile)block);
    }

    private void simpleBlockWithItem(RegistryObject<Block> block, ModelFile model) {
        this.simpleBlock((Block)block.get(), model);
        this.simpleBlockItem((Block)block.get(), model);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedChest$3(ModelFile chest, BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        int rotY = ((int)dir.m_122435_() + 180) % 360;
        return ConfiguredModel.builder().modelFile(chest).rotationY(rotY).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedSoulWallTorch$2(ModelFile wallTorch, BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        int rotY = ((int)dir.m_122435_() + 90) % 360;
        return ConfiguredModel.builder().modelFile(wallTorch).rotationY(rotY).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedWallTorch$1(ModelFile wallTorch, BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        int rotY = ((int)dir.m_122435_() + 90) % 360;
        return ConfiguredModel.builder().modelFile(wallTorch).rotationY(rotY).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedLever$0(ModelFile leverOn, ModelFile lever, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        AttachFace face = (AttachFace)state.m_61143_((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_);
        boolean powered = (Boolean)state.m_61143_((Property)LeverBlock.f_54622_);
        int rotY = (int)(facing.m_122435_() + 180.0f) % 360;
        int rotX = face.ordinal() * 90;
        ModelFile model = powered ? leverOn : lever;
        return ConfiguredModel.builder().modelFile(model).rotationX(rotX).rotationY(rotY).build();
    }
}

