/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.StairsType;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;

public class SlabEdgeSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        Direction dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean top = (Boolean)state.m_61143_((Property)PropertyHolder.TOP);
        if (adjState.m_60734_() == FBContent.blockFramedSlabEdge.get()) {
            return SlabEdgeSkipPredicate.testAgainstEdge(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedSlab.get()) {
            return SlabEdgeSkipPredicate.testAgainstSlab(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedDoubleSlab.get()) {
            return SlabEdgeSkipPredicate.testAgainstDoubleSlab(level, pos, dir, top, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedSlabCorner.get()) {
            return SlabEdgeSkipPredicate.testAgainstCorner(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedPanel.get()) {
            return SlabEdgeSkipPredicate.testAgainstPanel(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedDoublePanel.get()) {
            return SlabEdgeSkipPredicate.testAgainstDoublePanel(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedStairs.get()) {
            return SlabEdgeSkipPredicate.testAgainstStairs(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedVerticalStairs.get()) {
            return SlabEdgeSkipPredicate.testAgainstVerticalStairs(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedHalfStairs.get())) {
            return SlabEdgeSkipPredicate.testAgainstHalfStairs(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedSlopeSlab.get())) {
            return SlabEdgeSkipPredicate.testAgainstSlopeSlab(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedElevatedSlopeSlab.get())) {
            return SlabEdgeSkipPredicate.testAgainstElevatedSlopeSlab(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedDoubleSlopeSlab.get())) {
            return SlabEdgeSkipPredicate.testAgainstDoubleSlopeSlab(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedInverseDoubleSlopeSlab.get())) {
            return SlabEdgeSkipPredicate.testAgainstInverseDoubleSlopeSlab(level, pos, dir, top, adjState, side);
        }
        return false;
    }

    private static boolean testAgainstEdge(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if (side == dir && adjDir == side.m_122424_()) {
            return top == adjTop && SideSkipPredicate.compareState(level, pos, side);
        }
        if (side == dir.m_122427_() || side == dir.m_122428_()) {
            return dir == adjDir && top == adjTop && SideSkipPredicate.compareState(level, pos, side);
        }
        if (Utils.isY(side) && dir == adjDir) {
            return top != adjTop && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (side != dir || top != (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP)) {
            return false;
        }
        return SideSkipPredicate.compareState(level, pos, side);
    }

    private static boolean testAgainstDoubleSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, Direction side) {
        if (side != dir) {
            return false;
        }
        Direction face = top ? Direction.UP : Direction.DOWN;
        return SideSkipPredicate.compareState(level, pos, side, face);
    }

    private static boolean testAgainstCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if (side == dir.m_122427_() && adjDir == dir || side == dir.m_122428_() && adjDir == dir.m_122427_()) {
            return top == adjTop && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstPanel(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (!Utils.isY(side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        if (dir != adjDir) {
            return false;
        }
        if (side == Direction.UP && top || side == Direction.DOWN && !top) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoublePanel(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (!Utils.isY(side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_NE);
        if (dir != adjDir && dir != adjDir.m_122424_()) {
            return false;
        }
        if (side == Direction.UP && top || side == Direction.DOWN && !top) {
            return SideSkipPredicate.compareState(level, pos, side, dir);
        }
        return false;
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        boolean adjTop;
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
        boolean bl = adjTop = adjState.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP;
        if (top && side == Direction.UP || !top && side == Direction.DOWN) {
            if (adjShape != StairsShape.STRAIGHT || dir != adjDir) {
                return false;
            }
            return top == adjTop && SideSkipPredicate.compareState(level, pos, side);
        }
        if (top == adjTop && side == dir && StairsSkipPredicate.isSlabSide(adjShape, adjDir, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (adjType == StairsType.VERTICAL) {
            return false;
        }
        if (side == dir.m_122428_() && adjDir == dir || side == dir.m_122427_() && adjDir == dir.m_122427_()) {
            return top != adjType.isTop() && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (adjRight && adjDir == dir.m_122428_() || !adjRight && adjDir == dir.m_122427_()) {
            if (Utils.isY(side) && side == Direction.DOWN == adjTop && adjTop != top) {
                return SideSkipPredicate.compareState(level, pos, side);
            }
            return side == adjDir && adjTop == top && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (side != dir) {
            return false;
        }
        return adjDir == dir.m_122424_() && adjTopHalf == top && SideSkipPredicate.compareState(level, pos, side);
    }

    private static boolean testAgainstElevatedSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (side != dir) {
            return false;
        }
        return adjDir == dir && adjTop == top && SideSkipPredicate.compareState(level, pos, side);
    }

    private static boolean testAgainstDoubleSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (side != dir) {
            return false;
        }
        return (adjDir == dir || adjDir == dir.m_122424_()) && adjTopHalf == top && SideSkipPredicate.compareState(level, pos, side);
    }

    private static boolean testAgainstInverseDoubleSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (side != dir) {
            return false;
        }
        return (adjDir == dir && !top || adjDir == dir.m_122424_() && top) && SideSkipPredicate.compareState(level, pos, side);
    }
}

