/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.StairsType;

public class PanelSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        Direction dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
        if (side == dir) {
            return SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedPanel.get()) {
            return PanelSkipPredicate.testAgainstPanel(level, pos, dir, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedDoublePanel.get()) {
            return PanelSkipPredicate.testAgainstDoublePanel(level, pos, dir, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedCornerPillar.get()) {
            return PanelSkipPredicate.testAgainstPillar(level, pos, dir, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedSlabEdge.get()) {
            return PanelSkipPredicate.testAgainstEdge(level, pos, dir, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedStairs.get()) {
            return PanelSkipPredicate.testAgainstStairs(level, pos, dir, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedVerticalStairs.get()) {
            return PanelSkipPredicate.testAgainstVerticalStairs(level, pos, dir, adjState, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedHalfStairs.get())) {
            return PanelSkipPredicate.testAgainstHalfStairs(level, pos, dir, adjState, side);
        }
        return false;
    }

    private static boolean testAgainstPanel(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        if (side == dir.m_122424_()) {
            return false;
        }
        return dir == adjState.m_61143_((Property)PropertyHolder.FACING_HOR) && SideSkipPredicate.compareState(level, pos, side, dir);
    }

    private static boolean testAgainstDoublePanel(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        if (side == dir.m_122424_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_NE);
        return (dir == adjDir || dir == adjDir.m_122424_()) && SideSkipPredicate.compareState(level, pos, side, dir);
    }

    private static boolean testAgainstPillar(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        if (side == dir.m_122427_() && adjDir == dir || side == dir.m_122428_() && adjDir == dir.m_122427_()) {
            return SideSkipPredicate.compareState(level, pos, side, dir);
        }
        return false;
    }

    private static boolean testAgainstEdge(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        if (adjDir != dir) {
            return false;
        }
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if (side == Direction.UP && !adjTop || side == Direction.DOWN && adjTop) {
            return SideSkipPredicate.compareState(level, pos, side, dir);
        }
        return false;
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        boolean adjTop;
        if (!Utils.isY(side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
        boolean bl = adjTop = adjState.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP;
        if (dir != adjDir) {
            return false;
        }
        if (side == Direction.UP && adjTop || side == Direction.DOWN && !adjTop) {
            return adjShape == StairsShape.STRAIGHT && SideSkipPredicate.compareState(level, pos, side, dir);
        }
        return false;
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (side == dir.m_122428_() && adjDir == dir || side == dir.m_122427_() && adjDir == dir.m_122427_()) {
            return adjType == StairsType.VERTICAL && SideSkipPredicate.compareState(level, pos, side, dir);
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (side.m_122434_() == dir.m_122434_()) {
            return false;
        }
        if (adjRight && adjDir == dir.m_122428_() || !adjRight && adjDir == dir.m_122427_()) {
            if (Utils.isY(side)) {
                return side == Direction.DOWN == adjTop && SideSkipPredicate.compareState(level, pos, side, dir);
            }
            return side == adjDir.m_122424_() && SideSkipPredicate.compareState(level, pos, side, dir);
        }
        return false;
    }
}

