/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;

public class ElevatedSlopeSlabSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (SideSkipPredicate.CTM.test(level, pos, state, adjState, side)) {
            return true;
        }
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        if (adjState.m_60713_((Block)FBContent.blockFramedElevatedSlopeSlab.get())) {
            return ElevatedSlopeSlabSkipPredicate.testAgainstElevatedSlopeSlab(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedSlopeSlab.get()) || adjState.m_60713_((Block)FBContent.blockFramedDoubleSlopeSlab.get())) {
            return ElevatedSlopeSlabSkipPredicate.testAgainstSlopeSlab(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedInverseDoubleSlopeSlab.get())) {
            return ElevatedSlopeSlabSkipPredicate.testAgainstInverseDoubleSlopeSlab(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedSlab.get())) {
            return ElevatedSlopeSlabSkipPredicate.testAgainstSlab(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedDoubleSlab.get())) {
            return ElevatedSlopeSlabSkipPredicate.testAgainstDoubleSlab(level, pos, dir, top, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedSlabEdge.get())) {
            return ElevatedSlopeSlabSkipPredicate.testAgainstSlabEdge(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedStairs.get())) {
            return ElevatedSlopeSlabSkipPredicate.testAgainstStairs(level, pos, dir, top, adjState, side);
        }
        return false;
    }

    private static boolean testAgainstElevatedSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop != top) {
            return false;
        }
        if (side == dir.m_122427_() || side == dir.m_122428_()) {
            return adjDir == dir && SideSkipPredicate.compareState(level, pos, side);
        }
        if (side == dir.m_122424_()) {
            return adjDir == dir.m_122424_() && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        return side == dir.m_122424_() && adjDir == dir && adjTopHalf == top && SideSkipPredicate.compareState(level, pos, side);
    }

    private static boolean testAgainstInverseDoubleSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (side != dir.m_122424_()) {
            return false;
        }
        return (adjDir == dir && top || adjDir == dir.m_122424_() && !top) && SideSkipPredicate.compareState(level, pos, side);
    }

    private static boolean testAgainstSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return adjTop == top && side == dir.m_122424_() && SideSkipPredicate.compareState(level, pos, side);
    }

    private static boolean testAgainstDoubleSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, Direction side) {
        return side == dir.m_122424_() && SideSkipPredicate.compareState(level, pos, side, top ? Direction.UP : Direction.DOWN);
    }

    private static boolean testAgainstSlabEdge(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return adjDir == dir && adjTop == top && side == dir.m_122424_() && SideSkipPredicate.compareState(level, pos, side);
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        boolean adjTop;
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
        boolean bl = adjTop = adjState.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP;
        if (adjTop != top || side != dir.m_122424_()) {
            return false;
        }
        return StairsSkipPredicate.isSlabSide(adjShape, adjDir, side.m_122424_()) && SideSkipPredicate.compareState(level, pos, side);
    }
}

