/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.CornerType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.SlopeType;
import xfacthd.framedblocks.common.util.FramedUtils;

public class CornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (SideSkipPredicate.CTM.test(level, pos, state, adjState, side)) {
            return true;
        }
        Block block = adjState.m_60734_();
        if (!(block instanceof IFramedBlock)) {
            return false;
        }
        IFramedBlock block2 = (IFramedBlock)block;
        IBlockType adjBlock = block2.getBlockType();
        Direction dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
        CornerType type = (CornerType)((Object)state.m_61143_(PropertyHolder.CORNER_TYPE));
        if (adjBlock == BlockType.FRAMED_CORNER_SLOPE) {
            return CornerSkipPredicate.testAgainstCorner(level, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_DOUBLE_CORNER) {
            return CornerSkipPredicate.testAgainstDoubleCorner(level, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_SLOPE || adjBlock == BlockType.FRAMED_RAIL_SLOPE) {
            return CornerSkipPredicate.testAgainstSlope(level, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_DOUBLE_SLOPE) {
            return CornerSkipPredicate.testAgainstDoubleSlope(level, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_INNER_CORNER_SLOPE) {
            return CornerSkipPredicate.testAgainstInnerCorner(level, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_PRISM_CORNER || adjBlock == BlockType.FRAMED_THREEWAY_CORNER) {
            return CornerSkipPredicate.testAgainstThreewayCorner(level, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_INNER_PRISM_CORNER || adjBlock == BlockType.FRAMED_INNER_THREEWAY_CORNER) {
            return CornerSkipPredicate.testAgainstInnerThreewayCorner(level, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_DOUBLE_PRISM_CORNER || adjBlock == BlockType.FRAMED_DOUBLE_THREEWAY_CORNER) {
            return CornerSkipPredicate.testAgainstDoubleThreewayCorner(level, pos, dir, type, adjState, side);
        }
        return false;
    }

    private static boolean testAgainstCorner(BlockGetter level, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        if (!type.isHorizontal() && adjType == type && (side == dir && adjDir == dir.m_122428_() || side == dir.m_122428_() && adjDir == dir.m_122427_())) {
            return SideSkipPredicate.compareState(level, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
        }
        if (type.isHorizontal() && type.isHorizontalAdjacent(dir, side, adjType) && adjDir == dir) {
            return SideSkipPredicate.compareState(level, pos, side, dir);
        }
        if (!type.isHorizontal() && adjType.isHorizontal() && adjType.isTop() == type.isTop() && (side == dir && !adjType.isRight() && adjDir == dir.m_122428_() || side == dir.m_122428_() && adjType.isRight() && adjDir == dir)) {
            return SideSkipPredicate.compareState(level, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
        }
        if (type.isHorizontal() && !adjType.isHorizontal() && adjType.isTop() == type.isTop() && (!type.isRight() && side == dir.m_122428_() && adjDir == dir.m_122427_() || type.isRight() && side == dir.m_122427_() && adjDir == dir)) {
            return SideSkipPredicate.compareState(level, pos, side, dir);
        }
        return false;
    }

    private static boolean testAgainstDoubleCorner(BlockGetter level, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        if (!adjType.isHorizontal() && !type.isHorizontal()) {
            if (adjType.isTop() == type.isTop() && adjDir == dir && (side == dir || side == dir.m_122428_())) {
                return SideSkipPredicate.compareState(level, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
            }
            if (adjType.isTop() != type.isTop() && (side == dir && adjDir == dir.m_122427_() || side == dir.m_122428_() && adjDir == dir.m_122428_())) {
                return SideSkipPredicate.compareState(level, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
            }
        } else if (type.isHorizontal() && !adjType.isHorizontal()) {
            if (adjDir == dir && side == dir.m_122428_() && !type.isRight() && adjType.isTop() == type.isTop() || adjDir == dir.m_122424_() && side == dir.m_122427_() && type.isRight() && adjType.isTop() != type.isTop()) {
                return SideSkipPredicate.compareState(level, pos, side, dir);
            }
            if (adjDir == dir.m_122428_() && side == dir.m_122428_() && !type.isRight() && adjType.isTop() != type.isTop() || adjDir == dir.m_122427_() && side == dir.m_122427_() && type.isRight() && adjType.isTop() == type.isTop()) {
                return SideSkipPredicate.compareState(level, pos, side, dir);
            }
        } else if (!type.isHorizontal()) {
            if (side == dir.m_122428_() && adjDir == dir && !adjType.isRight() || side == dir && adjDir == dir.m_122428_() && adjType.isRight()) {
                return adjType.isTop() == type.isTop() && SideSkipPredicate.compareState(level, pos, side, adjDir);
            }
            if (side == dir.m_122428_() && adjDir == dir.m_122424_() && adjType.isRight() || side == dir && adjDir == dir.m_122427_() && !adjType.isRight()) {
                return adjType.isTop() != type.isTop() && SideSkipPredicate.compareState(level, pos, side, adjDir.m_122424_());
            }
        } else {
            if (adjDir == dir && type == adjType && (side == dir.m_122427_() && type.isRight() || side == dir.m_122428_() && !type.isRight() || side == Direction.UP && type.isTop() || side == Direction.DOWN && !type.isTop())) {
                return SideSkipPredicate.compareState(level, pos, side, dir);
            }
            if (adjDir == dir.m_122424_() && type.isTop() != adjType.isTop() && type.isRight() != adjType.isRight() && (side == dir.m_122427_() && type.isRight() || side == dir.m_122428_() && !type.isRight())) {
                return SideSkipPredicate.compareState(level, pos, side, dir);
            }
            if (adjDir == dir.m_122424_() && adjType == type && (side == Direction.DOWN && !type.isTop() || side == Direction.UP && type.isTop())) {
                return SideSkipPredicate.compareState(level, pos, side, dir);
            }
        }
        return false;
    }

    private static boolean testAgainstSlope(BlockGetter level, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = FramedUtils.getBlockFacing(adjState);
        SlopeType adjType = FramedUtils.getSlopeType(adjState);
        if (!type.isHorizontal() && adjType != SlopeType.HORIZONTAL && adjType == SlopeType.TOP == type.isTop()) {
            if (side == dir && adjDir == dir.m_122428_() || side == dir.m_122428_() && adjDir == dir) {
                Direction face = type.isTop() ? Direction.UP : Direction.DOWN;
                return SideSkipPredicate.compareState(level, pos, side, face);
            }
        } else if (type.isHorizontal()) {
            if ((side == dir.m_122427_() && type.isRight() || side == dir.m_122428_() && !type.isRight()) && adjType == SlopeType.TOP == type.isTop()) {
                return adjDir == dir && SideSkipPredicate.compareState(level, pos, side);
            }
            if (side == Direction.UP && type.isTop() || side == Direction.DOWN && !type.isTop()) {
                return (type.isRight() && adjDir == dir.m_122427_() || !type.isRight() && adjDir == dir) && SideSkipPredicate.compareState(level, pos, side);
            }
        }
        return false;
    }

    private static boolean testAgainstDoubleSlope(BlockGetter level, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        boolean adjTop;
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.m_61143_(PropertyHolder.SLOPE_TYPE));
        boolean bl = adjTop = adjType == SlopeType.TOP;
        if (!type.isHorizontal() && adjType != SlopeType.HORIZONTAL && (side == dir && type.isTop() == adjTop && adjDir == dir.m_122428_() || side == dir && type.isTop() != adjTop && adjDir == dir.m_122427_() || side == dir.m_122428_() && type.isTop() == adjTop && adjDir == dir || side == dir.m_122428_() && type.isTop() != adjTop && adjDir == dir.m_122424_())) {
            Direction face = type.isTop() ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, face);
        }
        if (type.isHorizontal() && adjType == SlopeType.HORIZONTAL && (side == Direction.DOWN && !type.isTop() || side == Direction.UP && type.isTop())) {
            if (!type.isRight() && (adjDir == dir || adjDir == dir.m_122424_()) || type.isRight() && (adjDir == dir.m_122427_() || adjDir == dir.m_122428_())) {
                return SideSkipPredicate.compareState(level, pos, side, dir);
            }
        } else if (type.isHorizontal() && adjType != SlopeType.HORIZONTAL && (side == dir.m_122428_() && !type.isRight() || side == dir.m_122427_() && type.isRight())) {
            Direction face = type.isTop() == adjTop ? adjDir : adjDir.m_122424_();
            return (type.isTop() == adjTop && adjDir == dir || type.isTop() != adjTop && adjDir == dir.m_122424_()) && SideSkipPredicate.compareState(level, pos, side, face);
        }
        return false;
    }

    private static boolean testAgainstInnerCorner(BlockGetter level, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        if (!(type.isHorizontal() || adjType != type || adjDir != dir || side != dir && side != dir.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
        }
        if (type.isHorizontal() && adjType == type && (side == Direction.UP && type.isTop() || side == Direction.DOWN && !type.isTop() || side == dir.m_122427_() && type.isRight() || side == dir.m_122428_() && !type.isRight())) {
            return SideSkipPredicate.compareState(level, pos, side, dir);
        }
        if (!type.isHorizontal() && adjType.isHorizontal() && adjType.isTop() == type.isTop() && (side == dir && adjType.isRight() && adjDir == dir.m_122428_() || side == dir.m_122428_() && !adjType.isRight() && adjDir == dir)) {
            return SideSkipPredicate.compareState(level, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
        }
        if (type.isHorizontal() && !adjType.isHorizontal() && adjType.isTop() == type.isTop() && (!type.isRight() && side == dir.m_122428_() && adjDir == dir || type.isRight() && side == dir.m_122427_() && adjDir == dir.m_122427_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir);
        }
        return false;
    }

    private static boolean testAgainstThreewayCorner(BlockGetter level, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if (!type.isHorizontal() && type.isTop() == adjTop) {
            if (side == dir && adjDir == dir.m_122428_() || side == dir.m_122428_() && adjDir == dir.m_122427_()) {
                return SideSkipPredicate.compareState(level, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
            }
        } else if (type.isHorizontal()) {
            if (side == dir.m_122427_() && type.isRight() && adjDir == dir && type.isTop() == adjTop || side == dir.m_122428_() && !type.isRight() && adjDir == dir.m_122427_() && type.isTop() == adjTop) {
                return SideSkipPredicate.compareState(level, pos, side, dir);
            }
            if (Utils.isY(side) && type.isTop() != adjTop && side == Direction.DOWN == !type.isTop() && (type.isRight() && adjDir == dir.m_122427_() || !type.isRight() && adjDir == dir)) {
                return SideSkipPredicate.compareState(level, pos, side, dir);
            }
        }
        return false;
    }

    private static boolean testAgainstInnerThreewayCorner(BlockGetter level, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if (!type.isHorizontal() && type.isTop() == adjTop && adjDir == dir) {
            return (side == dir || side == dir.m_122428_()) && SideSkipPredicate.compareState(level, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
        }
        if (type.isHorizontal()) {
            if (Utils.isY(side) && (!type.isRight() && adjDir == dir || type.isRight() && adjDir == dir.m_122427_())) {
                return type.isTop() == adjTop && SideSkipPredicate.compareState(level, pos, side, dir);
            }
            if (!type.isRight() && side == dir.m_122428_() && adjDir == dir || type.isRight() && side == dir.m_122427_() && adjDir == dir.m_122427_()) {
                return type.isTop() == adjTop && SideSkipPredicate.compareState(level, pos, side, dir);
            }
        }
        return false;
    }

    private static boolean testAgainstDoubleThreewayCorner(BlockGetter level, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if (!type.isHorizontal()) {
            if (adjDir == dir && adjTop == type.isTop() && (side == dir || side == dir.m_122428_())) {
                return SideSkipPredicate.compareState(level, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
            }
            if (adjTop != type.isTop() && (side == dir.m_122428_() && adjDir == dir.m_122428_() || side == dir && adjDir == dir.m_122427_())) {
                return SideSkipPredicate.compareState(level, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
            }
        } else if (adjTop == type.isTop()) {
            if (side == dir.m_122428_() && adjDir == dir && !type.isRight() || side == dir.m_122427_() && adjDir == dir.m_122427_() && type.isRight()) {
                return SideSkipPredicate.compareState(level, pos, side, dir);
            }
            if ((side == Direction.DOWN && !type.isTop() || side == Direction.UP && type.isTop()) && (!type.isRight() && (adjDir == dir || adjDir == dir.m_122424_()) || type.isRight() && (adjDir == dir.m_122427_() || adjDir == dir.m_122428_()))) {
                return SideSkipPredicate.compareState(level, pos, side, dir);
            }
        } else if (side == dir.m_122428_() && adjDir == dir.m_122428_() && !type.isRight() || side == dir.m_122427_() && adjDir == dir.m_122424_() && type.isRight()) {
            return SideSkipPredicate.compareState(level, pos, side, dir);
        }
        return false;
    }
}

