/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.util.CtmPredicate;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.FramedHalfStairsBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.StairsType;

public class FramedVerticalStairs
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, side) -> {
        StairsType type = (StairsType)((Object)((Object)state.m_61143_(PropertyHolder.STAIRS_TYPE)));
        if (type == StairsType.VERTICAL) {
            Direction dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
            return side == dir || side == dir.m_122428_();
        }
        return false;
    };

    public FramedVerticalStairs() {
        super(BlockType.FRAMED_VERTICAL_STAIRS);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PropertyHolder.FACING_HOR, PropertyHolder.STAIRS_TYPE, BlockStateProperties.f_61362_, FramedProperties.SOLID});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)PropertyHolder.FACING_HOR, (Comparable)context.m_8125_());
        return this.getStateFromContext(state, (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        Direction dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
        if (facing == dir.m_122424_() || facing == dir.m_122427_()) {
            return state;
        }
        return this.getStateFromContext(state, level, pos);
    }

    private BlockState getStateFromContext(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean top;
        Direction dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
        BlockState front = level.m_8055_(pos.m_142300_(dir));
        BlockState left = level.m_8055_(pos.m_142300_(dir.m_122428_()));
        if (FramedVerticalStairs.isNoStair(front) && FramedVerticalStairs.isNoStair(left)) {
            return (BlockState)state.m_61124_(PropertyHolder.STAIRS_TYPE, (Comparable)((Object)StairsType.VERTICAL));
        }
        boolean topCorner = false;
        boolean bottomCorner = false;
        if (front.m_60734_() instanceof StairBlock && front.m_61143_((Property)BlockStateProperties.f_61374_) == dir.m_122428_()) {
            topCorner = front.m_61143_((Property)BlockStateProperties.f_61402_) == Half.BOTTOM;
            bottomCorner = front.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP;
        } else if (front.m_60734_() instanceof FramedHalfStairsBlock && front.m_61143_((Property)FramedProperties.FACING_HOR) == dir.m_122428_()) {
            top = (Boolean)front.m_61143_((Property)FramedProperties.TOP);
            if (!((Boolean)front.m_61143_((Property)PropertyHolder.RIGHT)).booleanValue()) {
                topCorner = !top;
                bottomCorner = top;
            }
        }
        if (left.m_60734_() instanceof StairBlock && left.m_61143_((Property)BlockStateProperties.f_61374_) == dir) {
            topCorner |= left.m_61143_((Property)BlockStateProperties.f_61402_) == Half.BOTTOM;
            bottomCorner |= left.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP;
        } else if (left.m_60734_() instanceof FramedHalfStairsBlock && left.m_61143_((Property)FramedProperties.FACING_HOR) == dir) {
            top = (Boolean)left.m_61143_((Property)FramedProperties.TOP);
            if (((Boolean)left.m_61143_((Property)PropertyHolder.RIGHT)).booleanValue()) {
                topCorner = !top;
                bottomCorner = top;
            }
        }
        BlockState above = level.m_8055_(pos.m_7494_());
        BlockState below = level.m_8055_(pos.m_7495_());
        StairsType type = topCorner && !above.m_60713_((Block)this) ? StairsType.TOP_CORNER : (bottomCorner && !below.m_60713_((Block)this) ? StairsType.BOTTOM_CORNER : StairsType.VERTICAL);
        return (BlockState)state.m_61124_(PropertyHolder.STAIRS_TYPE, (Comparable)((Object)type));
    }

    private static boolean isNoStair(BlockState state) {
        return !(state.m_60734_() instanceof StairBlock) && !(state.m_60734_() instanceof FramedHalfStairsBlock);
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape vertShape = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (BooleanOp)BooleanOp.f_82695_);
        VoxelShape topCornerShape = Stream.of(Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0), Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
        VoxelShape bottomCornerShape = Stream.of(Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), Block.m_49796_((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
        for (BlockState state : states) {
            StairsType type = (StairsType)((Object)state.m_61143_(PropertyHolder.STAIRS_TYPE));
            Direction dir = ((Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR)).m_122424_();
            if (type == StairsType.TOP_CORNER) {
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, topCornerShape));
                continue;
            }
            if (type == StairsType.BOTTOM_CORNER) {
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, bottomCornerShape));
                continue;
            }
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, vertShape));
        }
        return builder.build();
    }
}

