/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.util.CtmPredicate;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.FramedSlopeSlabBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedElevatedSlopeSlabBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, dir) -> dir == state.m_61143_((Property)FramedProperties.FACING_HOR) || (Boolean)state.m_61143_((Property)FramedProperties.TOP) != false && dir == Direction.UP || (Boolean)state.m_61143_((Property)FramedProperties.TOP) == false && dir == Direction.DOWN;

    public FramedElevatedSlopeSlabBlock() {
        super(BlockType.FRAMED_ELEVATED_SLOPE_SLAB);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP, BlockStateProperties.f_61362_, FramedProperties.SOLID});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction face = context.m_43719_();
        Direction facing = Utils.isY(face) ? context.m_8125_() : face.m_122424_();
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing);
        state = FramedElevatedSlopeSlabBlock.withTop(state, context.m_43719_(), context.m_43720_());
        return FramedElevatedSlopeSlabBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape shapeBottom = Shapes.m_83110_((VoxelShape)FramedSlopeSlabBlock.SHAPE_BOTTOM.m_83216_(0.0, 0.5, 0.0), (VoxelShape)FramedElevatedSlopeSlabBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0));
        VoxelShape shapeTop = Shapes.m_83110_((VoxelShape)FramedSlopeSlabBlock.SHAPE_TOP, (VoxelShape)FramedElevatedSlopeSlabBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, facing, top ? shapeTop : shapeBottom));
        }
        return builder.build();
    }
}

