/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.item.FramedBlueprintItem;

public abstract class AbstractFramedDoubleBlock
extends FramedBlock {
    public AbstractFramedDoubleBlock(BlockType blockType) {
        super(blockType);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FramedProperties.SOLID});
    }

    @Override
    @Nonnull
    public BlockState getFacade(@Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nullable Direction side, @Nonnull BlockPos connection) {
        BlockEntity blockEntity;
        BlockState state = level.m_8055_(pos);
        if (this.getCtmPredicate().test(state, side) && (blockEntity = level.m_7702_(pos)) instanceof FramedDoubleBlockEntity) {
            FramedDoubleBlockEntity be = (FramedDoubleBlockEntity)blockEntity;
            return be.getCamoState(side);
        }
        return Blocks.f_50016_.m_49966_();
    }

    @Override
    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedDoubleBlockEntity) {
            FramedDoubleBlockEntity be = (FramedDoubleBlockEntity)blockEntity;
            return be.getSoundType();
        }
        return this.m_49962_(state);
    }

    protected void m_142387_(Level level, Player player, BlockPos pos, BlockState state) {
        BlockEntity blockEntity;
        if (level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof FramedDoubleBlockEntity) {
            FramedDoubleBlockEntity be = (FramedDoubleBlockEntity)blockEntity;
            BlockState defaultState = be.m_58900_();
            BlockState camoOne = be.getCamoState();
            BlockState camoTwo = be.getCamoStateTwo();
            level.m_5898_(player, 2001, pos, AbstractFramedDoubleBlock.m_49956_((BlockState)(camoOne.m_60795_() ? defaultState : camoOne)));
            if (camoOne != camoTwo) {
                level.m_5898_(player, 2001, pos, AbstractFramedDoubleBlock.m_49956_((BlockState)(camoTwo.m_60795_() ? defaultState : camoTwo)));
            }
        }
    }

    @Override
    public Optional<MutableComponent> printCamoBlock(CompoundTag beTag) {
        BlockState camoState = NbtUtils.m_129241_((CompoundTag)beTag.m_128469_("camo_state"));
        BlockState camoStateTwo = NbtUtils.m_129241_((CompoundTag)beTag.m_128469_("camo_state_two"));
        MutableComponent component = camoState.m_60795_() ? FramedBlueprintItem.BLOCK_NONE : camoState.m_60734_().m_49954_().m_130940_(ChatFormatting.WHITE);
        component = component.m_6881_().m_7220_((Component)new TextComponent(" | ").m_130940_(ChatFormatting.GOLD));
        component.m_7220_((Component)(camoStateTwo.m_60795_() ? FramedBlueprintItem.BLOCK_NONE : camoStateTwo.m_60734_().m_49954_().m_130940_(ChatFormatting.WHITE)));
        return Optional.of(component);
    }
}

