/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import com.mojang.math.Vector4f;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.api.util.client.BakedQuadTransformer;
import xfacthd.framedblocks.api.util.client.ModelUtils;

public class FramedWallModel
extends FramedBlockModel {
    private static final Vector4f[] rects = new Vector4f[]{new Vector4f(0.3125f, 0.0f, 0.6875f, 0.3125f), new Vector4f(0.3125f, 0.6875f, 0.6875f, 1.0f), new Vector4f(0.0f, 0.3125f, 0.3125f, 0.6875f), new Vector4f(0.6875f, 0.3125f, 1.0f, 0.6875f), new Vector4f(0.3125f, 0.0f, 0.6875f, 0.25f), new Vector4f(0.3125f, 0.75f, 0.6875f, 1.0f), new Vector4f(0.0f, 0.3125f, 0.25f, 0.6875f), new Vector4f(0.75f, 0.3125f, 1.0f, 0.6875f)};
    private final boolean center;
    private final WallSide north;
    private final WallSide east;
    private final WallSide south;
    private final WallSide west;

    public FramedWallModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.center = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61366_);
        this.north = (WallSide)state.m_61143_((Property)BlockStateProperties.f_61379_);
        this.east = (WallSide)state.m_61143_((Property)BlockStateProperties.f_61378_);
        this.south = (WallSide)state.m_61143_((Property)BlockStateProperties.f_61380_);
        this.west = (WallSide)state.m_61143_((Property)BlockStateProperties.f_61381_);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        if (this.north != WallSide.NONE) {
            this.buildWallHalfSegment(quadMap, quad, Direction.NORTH, this.north);
        }
        if (this.south != WallSide.NONE) {
            this.buildWallHalfSegment(quadMap, quad, Direction.SOUTH, this.south);
        }
        if (this.east != WallSide.NONE) {
            this.buildWallHalfSegment(quadMap, quad, Direction.EAST, this.east);
        }
        if (this.west != WallSide.NONE) {
            this.buildWallHalfSegment(quadMap, quad, Direction.WEST, this.west);
        }
        FramedWallModel.buildWallEndCap(quadMap, quad, Direction.NORTH, this.north);
        FramedWallModel.buildWallEndCap(quadMap, quad, Direction.EAST, this.east);
        FramedWallModel.buildWallEndCap(quadMap, quad, Direction.SOUTH, this.south);
        FramedWallModel.buildWallEndCap(quadMap, quad, Direction.WEST, this.west);
        this.buildCenterPillar(quadMap, quad);
    }

    private void buildWallHalfSegment(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, Direction dir, WallSide height) {
        if (height != WallSide.NONE) {
            if (Utils.isY(quad.m_111306_())) {
                Vector4f rect = rects[dir.ordinal() - 2 + (this.center ? 4 : 0)];
                BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, rect.m_123601_(), rect.m_123615_(), rect.m_123616_(), rect.m_123617_())) {
                    if (height == WallSide.TALL || quad.m_111306_() == Direction.DOWN) {
                        quadMap.get(quad.m_111306_()).add(topBotQuad);
                    } else {
                        BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, 0.875f);
                        quadMap.get(null).add(topBotQuad);
                    }
                }
            } else if (quad.m_111306_() == dir.m_122427_() || quad.m_111306_() == dir.m_122428_()) {
                BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
                if ((height == WallSide.TALL || BakedQuadTransformer.createHorizontalSideQuad(sideQuad, false, 0.875f)) && BakedQuadTransformer.createVerticalSideQuad(sideQuad, dir.m_122424_(), this.center ? 0.25f : 0.3125f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.6875f);
                    quadMap.get(null).add(sideQuad);
                }
            }
        }
    }

    private static void buildWallEndCap(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, Direction dir, WallSide height) {
        BakedQuad sideQuad;
        if (quad.m_111306_() == dir && height != WallSide.NONE && BakedQuadTransformer.createSideQuad(sideQuad = ModelUtils.duplicateQuad(quad), 0.3125f, 0.0f, 0.6875f, height == WallSide.TALL ? 1.0f : 0.875f)) {
            quadMap.get(dir).add(sideQuad);
        }
    }

    private void buildCenterPillar(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        if (this.center) {
            if (Utils.isY(quad.m_111306_())) {
                BakedQuad pillarQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomQuad(pillarQuad, 0.25f, 0.25f, 0.75f, 0.75f)) {
                    quadMap.get(quad.m_111306_()).add(pillarQuad);
                }
            } else {
                BakedQuad pillarQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createSideQuad(pillarQuad, 0.25f, 0.0f, 0.75f, 1.0f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(pillarQuad, 0.75f);
                    quadMap.get(null).add(pillarQuad);
                }
            }
        } else {
            boolean tall;
            boolean bl = tall = this.north == WallSide.TALL || this.east == WallSide.TALL || this.south == WallSide.TALL || this.west == WallSide.TALL;
            if (Utils.isY(quad.m_111306_())) {
                BakedQuad pillarQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomQuad(pillarQuad, 0.3125f, 0.3125f, 0.6875f, 0.6875f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(pillarQuad, tall || quad.m_111306_() == Direction.DOWN ? 1.0f : 0.875f);
                    quadMap.get(tall ? quad.m_111306_() : null).add(pillarQuad);
                }
            } else if (quad.m_111306_() == Direction.NORTH) {
                FramedWallModel.buildSmallCenterSide(quadMap.get(null), quad, this.north, tall);
            } else if (quad.m_111306_() == Direction.EAST) {
                FramedWallModel.buildSmallCenterSide(quadMap.get(null), quad, this.east, tall);
            } else if (quad.m_111306_() == Direction.SOUTH) {
                FramedWallModel.buildSmallCenterSide(quadMap.get(null), quad, this.south, tall);
            } else if (quad.m_111306_() == Direction.WEST) {
                FramedWallModel.buildSmallCenterSide(quadMap.get(null), quad, this.west, tall);
            }
        }
    }

    private static void buildSmallCenterSide(List<BakedQuad> quadList, BakedQuad quad, WallSide height, boolean tall) {
        BakedQuad pillarQuad;
        if (height == WallSide.NONE) {
            BakedQuad pillarQuad2 = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideQuad(pillarQuad2, 0.3125f, 0.0f, 0.6875f, tall ? 1.0f : 0.875f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(pillarQuad2, 0.6875f);
                quadList.add(pillarQuad2);
            }
        } else if (tall && height == WallSide.LOW && BakedQuadTransformer.createSideQuad(pillarQuad = ModelUtils.duplicateQuad(quad), 0.3125f, 0.875f, 0.6875f, 1.0f)) {
            BakedQuadTransformer.setQuadPosInFacingDir(pillarQuad, 0.6875f);
            quadList.add(pillarQuad);
        }
    }
}

