/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.util.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Vector3f;
import java.util.Arrays;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraftforge.client.model.pipeline.LightUtil;
import xfacthd.framedblocks.api.util.Utils;

public class ModelUtils {
    private static final int ELEMENT_POS = ModelUtils.findElement(VertexFormatElement.Usage.POSITION, 0);
    private static final int ELEMENT_COLOR = ModelUtils.findElement(VertexFormatElement.Usage.COLOR, 0);
    private static final int ELEMENT_UV = ModelUtils.findElement(VertexFormatElement.Usage.UV, 0);
    private static final int ELEMENT_LIGHT = ModelUtils.findElement(VertexFormatElement.Usage.UV, 2);
    private static final int ELEMENT_NORMAL = ModelUtils.findElement(VertexFormatElement.Usage.NORMAL, 0);

    public static boolean modifyQuad(BakedQuad quad, VertexDataConsumer consumer) {
        int[] vertexData = quad.m_111303_();
        float[][] pos = new float[4][3];
        float[][] color = new float[4][4];
        float[][] uv = new float[4][2];
        float[][] light = new float[4][2];
        float[][] normal = new float[4][3];
        for (int vert = 0; vert < 4; ++vert) {
            LightUtil.unpack((int[])vertexData, (float[])pos[vert], (VertexFormat)DefaultVertexFormat.f_85811_, (int)vert, (int)ELEMENT_POS);
            LightUtil.unpack((int[])vertexData, (float[])color[vert], (VertexFormat)DefaultVertexFormat.f_85811_, (int)vert, (int)ELEMENT_COLOR);
            LightUtil.unpack((int[])vertexData, (float[])uv[vert], (VertexFormat)DefaultVertexFormat.f_85811_, (int)vert, (int)ELEMENT_UV);
            LightUtil.unpack((int[])vertexData, (float[])light[vert], (VertexFormat)DefaultVertexFormat.f_85811_, (int)vert, (int)ELEMENT_LIGHT);
            LightUtil.unpack((int[])vertexData, (float[])normal[vert], (VertexFormat)DefaultVertexFormat.f_85811_, (int)vert, (int)ELEMENT_NORMAL);
        }
        boolean success = consumer.accept(pos, color, uv, light, normal);
        if (!success) {
            return false;
        }
        for (int vert = 0; vert < 4; ++vert) {
            LightUtil.pack((float[])pos[vert], (int[])vertexData, (VertexFormat)DefaultVertexFormat.f_85811_, (int)vert, (int)ELEMENT_POS);
            LightUtil.pack((float[])color[vert], (int[])vertexData, (VertexFormat)DefaultVertexFormat.f_85811_, (int)vert, (int)ELEMENT_COLOR);
            LightUtil.pack((float[])uv[vert], (int[])vertexData, (VertexFormat)DefaultVertexFormat.f_85811_, (int)vert, (int)ELEMENT_UV);
            LightUtil.pack((float[])light[vert], (int[])vertexData, (VertexFormat)DefaultVertexFormat.f_85811_, (int)vert, (int)ELEMENT_LIGHT);
            LightUtil.pack((float[])normal[vert], (int[])vertexData, (VertexFormat)DefaultVertexFormat.f_85811_, (int)vert, (int)ELEMENT_NORMAL);
        }
        ModelUtils.fillNormal(quad);
        return true;
    }

    public static float[][] unpackElement(BakedQuad quad, VertexFormatElement.Usage usage, int index) {
        int elemPos = ModelUtils.findElement(usage, index);
        float[][] data = new float[4][4];
        for (int vert = 0; vert < 4; ++vert) {
            LightUtil.unpack((int[])quad.m_111303_(), (float[])data[vert], (VertexFormat)DefaultVertexFormat.f_85811_, (int)vert, (int)elemPos);
        }
        return data;
    }

    public static int findElement(VertexFormatElement.Usage usage, int index) {
        int idx = 0;
        for (VertexFormatElement element : DefaultVertexFormat.f_85811_.m_86023_()) {
            if (element.m_86048_() == usage && element.m_86049_() == index) {
                return idx;
            }
            ++idx;
        }
        throw new IllegalArgumentException("Format doesn't have a " + usage.m_86097_() + " element");
    }

    public static BakedQuad duplicateQuad(BakedQuad quad) {
        int[] vertexData = quad.m_111303_();
        vertexData = Arrays.copyOf(vertexData, vertexData.length);
        return new BakedQuad(vertexData, quad.m_111305_(), quad.m_111306_(), quad.m_173410_(), quad.m_111307_());
    }

    public static void fillNormal(BakedQuad quad) {
        float[][] pos = ModelUtils.unpackElement(quad, VertexFormatElement.Usage.POSITION, 0);
        Vector3f v1 = new Vector3f(pos[3][0], pos[3][1], pos[3][2]);
        Vector3f t1 = new Vector3f(pos[1][0], pos[1][1], pos[1][2]);
        Vector3f v2 = new Vector3f(pos[2][0], pos[2][1], pos[2][2]);
        Vector3f t2 = new Vector3f(pos[0][0], pos[0][1], pos[0][2]);
        v1.m_122267_(t1);
        v2.m_122267_(t2);
        v2.m_122279_(v1);
        v2.m_122278_();
        int x = (byte)Math.round(v2.m_122239_() * 127.0f) & 0xFF;
        int y = (byte)Math.round(v2.m_122260_() * 127.0f) & 0xFF;
        int z = (byte)Math.round(v2.m_122269_() * 127.0f) & 0xFF;
        int normal = x | y << 8 | z << 16;
        int[] vertexData = quad.m_111303_();
        int step = vertexData.length / 4;
        for (int vert = 0; vert < 4; ++vert) {
            vertexData[vert * step + 7] = normal;
        }
    }

    public static void remapUV(Direction quadDir, float coord1, float coord2, float coordTo, float[][] uv, int uv1, int uv2, int uvTo, boolean vAxis, boolean invert, boolean rotated, boolean mirrored) {
        ModelUtils.remapUV(quadDir, coord1, coord2, coordTo, uv, uv, uv1, uv2, uvTo, vAxis, invert, rotated, mirrored);
    }

    public static void remapUV(Direction quadDir, float coord1, float coord2, float coordTo, float[][] uvSrc, float[][] uvDest, int uv1, int uv2, int uvTo, boolean vAxis, boolean invert, boolean rotated, boolean mirrored) {
        if (rotated) {
            if (quadDir == Direction.UP) {
                invert = vAxis == mirrored;
            } else if (quadDir == Direction.DOWN) {
                invert = !mirrored;
            } else if (Utils.isPositive(quadDir) != vAxis) {
                invert = !invert;
            }
        } else if (mirrored) {
            if (quadDir == Direction.UP) {
                invert = !vAxis || uvSrc[0][1] > uvSrc[1][1];
            } else if (quadDir == Direction.DOWN) {
                invert = !vAxis || uvSrc[0][1] < uvSrc[1][1];
            } else if (!vAxis) {
                invert = !invert;
            }
        }
        float coordMin = Math.min(coord1, coord2);
        float coordMax = Math.max(coord1, coord2);
        int uvIdx = rotated != vAxis ? 1 : 0;
        float uvMin = Math.min(uvSrc[uv1][uvIdx], uvSrc[uv2][uvIdx]);
        float uvMax = Math.max(uvSrc[uv1][uvIdx], uvSrc[uv2][uvIdx]);
        if (coordTo == coordMin) {
            uvDest[uvTo][uvIdx] = invert ? uvMax : uvMin;
        } else if (coordTo == coordMax) {
            uvDest[uvTo][uvIdx] = invert ? uvMin : uvMax;
        } else {
            float mult = (coordTo - coordMin) / (coordMax - coordMin);
            if (invert) {
                mult = 1.0f - mult;
            }
            uvDest[uvTo][uvIdx] = Mth.m_14179_((float)mult, (float)uvMin, (float)uvMax);
        }
    }

    public static boolean isQuadRotated(float[][] uv) {
        return !(!Mth.m_14033_((float)uv[0][1], (float)uv[1][1]) && !Mth.m_14033_((float)uv[3][1], (float)uv[2][1]) || !Mth.m_14033_((float)uv[1][0], (float)uv[2][0]) && !Mth.m_14033_((float)uv[0][0], (float)uv[3][0]));
    }

    public static boolean isQuadMirrored(float[][] uv) {
        boolean rotated = ModelUtils.isQuadRotated(uv);
        if (!rotated) {
            return uv[0][0] > uv[3][0] && uv[1][0] > uv[2][0] || uv[0][1] > uv[1][1] && uv[3][1] > uv[2][1];
        }
        return uv[0][0] > uv[1][0] && uv[3][0] > uv[2][0] || uv[0][1] < uv[3][1] && uv[1][1] < uv[2][1];
    }

    public static BakedQuad invertTintIndex(BakedQuad quad) {
        return new BakedQuad(quad.m_111303_(), ModelUtils.encodeSecondaryTintIndex(quad.m_111305_()), quad.m_111306_(), quad.m_173410_(), quad.m_111307_());
    }

    public static int encodeSecondaryTintIndex(int tintIndex) {
        return (tintIndex + 2) * -1;
    }

    public static int decodeSecondaryTintIndex(int tintIndex) {
        return tintIndex * -1 - 2;
    }

    public static interface VertexDataConsumer {
        public boolean accept(float[][] var1, float[][] var2, float[][] var3, float[][] var4, float[][] var5);
    }
}

