/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.util.client;

import com.google.common.base.Suppliers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ClientUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Supplier<Boolean> OPTIFINE_LOADED = Suppliers.memoize(() -> {
        try {
            Class.forName("net.optifine.Config");
            return true;
        }
        catch (ClassNotFoundException ingored) {
            return false;
        }
    });

    @Deprecated(forRemoval=true)
    public static void replaceModels(RegistryObject<Block> block, Map<ResourceLocation, BakedModel> models, BiFunction<BlockState, BakedModel, BakedModel> blockModelGen) {
        ClientUtils.replaceModels(block, models, blockModelGen, (BakedModel model) -> model, null);
    }

    public static void replaceModels(RegistryObject<Block> block, Map<ResourceLocation, BakedModel> models, BiFunction<BlockState, BakedModel, BakedModel> blockModelGen, @Nullable List<Property<?>> ignoredProps) {
        ClientUtils.replaceModels(block, models, blockModelGen, (BakedModel model) -> model, ignoredProps);
    }

    public static void replaceModels(RegistryObject<Block> block, Map<ResourceLocation, BakedModel> models, BiFunction<BlockState, BakedModel, BakedModel> blockModelGen, BlockState itemModelSource, @Nullable List<Property<?>> ignoredProps) {
        ClientUtils.replaceModels(block, models, blockModelGen, (BakedModel model) -> (BakedModel)models.get(BlockModelShaper.m_110895_((BlockState)itemModelSource)), ignoredProps);
    }

    @Deprecated(forRemoval=true)
    public static void replaceModels(RegistryObject<Block> block, Map<ResourceLocation, BakedModel> models, BiFunction<BlockState, BakedModel, BakedModel> blockModelGen, @Nullable Function<BakedModel, BakedModel> itemModelGen, @Nullable List<Property<?>> ignoredProps) {
        HashMap<BlockState, BakedModel> visitedStates = new HashMap<BlockState, BakedModel>();
        for (BlockState state : ((Block)block.get()).m_49965_().m_61056_()) {
            ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)state);
            BakedModel baseModel = models.get(location);
            BakedModel replacement = visitedStates.computeIfAbsent(ClientUtils.ignoreProps(state, ignoredProps), key -> (BakedModel)blockModelGen.apply((BlockState)key, baseModel));
            models.put((ResourceLocation)location, replacement);
        }
        if (itemModelGen != null) {
            ModelResourceLocation location = new ModelResourceLocation(((Block)block.get()).getRegistryName(), "inventory");
            BakedModel replacement = itemModelGen.apply(models.get(location));
            models.put((ResourceLocation)location, replacement);
        }
    }

    private static BlockState ignoreProps(BlockState state, @Nullable List<Property<?>> ignoredProps) {
        if (ignoredProps == null || ignoredProps.isEmpty()) {
            return state;
        }
        BlockState defaultState = state.m_60734_().m_49966_();
        for (Property<?> prop : ignoredProps) {
            if (!state.m_61138_(prop)) {
                LOGGER.warn("Found invalid ignored property {} for block {}!", prop, (Object)state.m_60734_());
                continue;
            }
            state = (BlockState)state.m_61124_(prop, defaultState.m_61143_(prop));
        }
        return state;
    }

    public static BlockEntity getBlockEntitySafe(BlockGetter blockGetter, BlockPos pos) {
        if (blockGetter instanceof RenderChunkRegion) {
            RenderChunkRegion renderChunk = (RenderChunkRegion)blockGetter;
            return renderChunk.m_7702_(pos);
        }
        return null;
    }
}

