/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks;

import com.google.common.base.Preconditions;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.CrashReportCallables;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xfacthd.framedblocks.api.FramedBlocksAPI;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.client.util.ClientConfig;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.compat.CompatHandler;
import xfacthd.framedblocks.common.item.FramedToolItem;
import xfacthd.framedblocks.common.net.OpenSignScreenPacket;
import xfacthd.framedblocks.common.net.SignUpdatePacket;
import xfacthd.framedblocks.common.util.ApiImpl;
import xfacthd.framedblocks.common.util.CommonConfig;
import xfacthd.framedblocks.common.util.ServerConfig;

@Mod(value="framedblocks")
@Mod.EventBusSubscriber(modid="framedblocks", bus=Mod.EventBusSubscriber.Bus.MOD)
public class FramedBlocks {
    public static final String MODID = "framedblocks";
    public static final Logger LOGGER = LogManager.getLogger();
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("framedblocks", "main"), () -> "1", "1"::equals, "1"::equals);
    public static final CreativeModeTab FRAMED_TAB = new CreativeModeTab("framed_blocks"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)FBContent.blockFramedCube.get());
        }

        public void m_6151_(NonNullList<ItemStack> items) {
            super.m_6151_(items);
            items.sort((s1, s2) -> {
                BlockItem bi;
                Item itemOne = s1.m_41720_();
                Item itemTwo = s2.m_41720_();
                if (itemOne instanceof FramedToolItem) {
                    FramedToolItem toolOne = (FramedToolItem)itemOne;
                    if (itemTwo instanceof FramedToolItem) {
                        FramedToolItem toolTwo = (FramedToolItem)itemTwo;
                        return toolOne.getType().compareTo(toolTwo.getType());
                    }
                }
                if (itemOne instanceof FramedToolItem) {
                    return 1;
                }
                if (itemTwo instanceof FramedToolItem) {
                    return -1;
                }
                Preconditions.checkArgument((itemOne instanceof BlockItem && (bi = (BlockItem)itemOne).m_40614_() instanceof IFramedBlock ? 1 : 0) != 0, (Object)String.format("Invalid item in FramedBlocks creative tab: %s", itemOne.getRegistryName()));
                Preconditions.checkArgument((itemTwo instanceof BlockItem && (bi = (BlockItem)itemTwo).m_40614_() instanceof IFramedBlock ? 1 : 0) != 0, (Object)String.format("Invalid item in FramedBlocks creative tab: %s", itemOne.getRegistryName()));
                Block b1 = ((BlockItem)itemOne).m_40614_();
                Block b2 = ((BlockItem)itemTwo).m_40614_();
                return ((IFramedBlock)b1).getBlockType().compareTo(((IFramedBlock)b2).getBlockType());
            });
        }
    };

    public FramedBlocks() {
        FBContent.init();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.SPEC);
        FramedBlocksAPI.INSTANCE.accept(new ApiImpl());
        CompatHandler.init();
        CrashReportCallables.registerCrashCallable((String)"FramedBlocks BlockEntity Warning", FramedBlocks::getBlockEntityWarning);
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        CHANNEL.messageBuilder(SignUpdatePacket.class, 0, NetworkDirection.PLAY_TO_SERVER).encoder(SignUpdatePacket::encode).decoder(SignUpdatePacket::new).consumer(SignUpdatePacket::handle).add();
        CHANNEL.messageBuilder(OpenSignScreenPacket.class, 1, NetworkDirection.PLAY_TO_CLIENT).encoder(OpenSignScreenPacket::encode).decoder(OpenSignScreenPacket::new).consumer(OpenSignScreenPacket::handle).add();
    }

    private static String getBlockEntityWarning() {
        if (!ServerConfig.allowBlockEntities) {
            return "Not applicable";
        }
        return "\n\t\tThe 'allowBlockEntities' setting in the framedblocks-server.toml config file is enabled.\n\t\tIf this crash happened in FramedBlocks code, please try the following solutions before reporting:\n\t\t- If you can identify the block that was used as a camo and resulted in the crash, add the block to the blacklist tag\n\t\t- If you can't identify the block or the crash wasn't fixed, make a backup of the world and disable the mentioned config setting\n\t\tIf the crash still happens, please report it on the FramedBlocks GitHub repository\n";
    }
}

