/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.config;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.config.FlwConfig;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;

public enum FlwEngine {
    OFF("off", "Off"),
    BATCHING("batching", "Parallel Batching"),
    INSTANCING("instancing", "GL33 Instanced Arrays");

    private static final Map<String, FlwEngine> lookup;
    private final String shortName;
    private final String properName;

    private FlwEngine(String shortName, String properName) {
        this.shortName = shortName;
        this.properName = properName;
    }

    public String getProperName() {
        return this.properName;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeByte(this.ordinal());
    }

    public static void handle(@Nullable FlwEngine type) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (type != null) {
            FlwConfig.get().client.engine.set((Object)type);
            Component message = FlwEngine.getMessage(type);
            player.m_5661_(message, false);
            Backend.reloadWorldRenderers();
        } else {
            player.m_5661_(FlwEngine.getMessage(FlwConfig.get().getEngine()), false);
        }
    }

    private static Component getMessage(@NotNull FlwEngine type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case OFF -> new TextComponent("Disabled Flywheel").m_130940_(ChatFormatting.RED);
            case INSTANCING -> new TextComponent("Using Instancing Engine").m_130940_(ChatFormatting.GREEN);
            case BATCHING -> {
                MutableComponent msg = new TextComponent("Using Batching Engine").m_130940_(ChatFormatting.GREEN);
                if (ModList.get().isLoaded("create")) {
                    msg.m_7220_((Component)new TextComponent("\nWARNING: May cause issues with Create Contraptions").m_130940_(ChatFormatting.RED));
                }
                yield msg;
            }
        };
    }

    @Nullable
    public static FlwEngine decode(FriendlyByteBuf buffer) {
        byte b = buffer.readByte();
        if (b == -1) {
            return null;
        }
        return FlwEngine.values()[b];
    }

    @Nullable
    public static FlwEngine byName(String name) {
        return lookup.get(name);
    }

    public static Collection<String> validNames() {
        return lookup.keySet();
    }

    static {
        lookup = new HashMap<String, FlwEngine>();
        for (FlwEngine value : FlwEngine.values()) {
            lookup.put(value.shortName, value);
        }
    }
}

