/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.glue;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.BlockMovementChecks;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.BearingBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.AbstractChassisBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.glue.GlueEffectPacket;
import com.simibubi.create.content.schematics.ISpecialEntityItemRequirement;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.BlockFace;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedWorld;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.Validate;

public class SuperGlueEntity
extends Entity
implements IEntityAdditionalSpawnData,
ISpecialEntityItemRequirement {
    private int validationTimer;
    protected BlockPos hangingPosition;
    protected Direction facingDirection = Direction.SOUTH;

    public SuperGlueEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public SuperGlueEntity(Level world, BlockPos pos, Direction direction) {
        this((EntityType)AllEntityTypes.SUPER_GLUE.get(), world);
        this.hangingPosition = pos;
        this.facingDirection = direction;
        this.updateFacingWithBoundingBox();
    }

    protected void m_8097_() {
    }

    public int getWidthPixels() {
        return 12;
    }

    public int getHeightPixels() {
        return 12;
    }

    public void onBroken(@Nullable Entity breaker) {
        this.m_5496_(SoundEvents.f_12470_, 1.0f, 1.0f);
        if (this.onValidSurface()) {
            AllPackets.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new GlueEffectPacket(this.getHangingPosition(), this.getFacingDirection().m_122424_(), false));
            AllSoundEvents.SLIME_ADDED.playFrom(this, 0.5f, 0.5f);
        }
    }

    public void playPlaceSound() {
        AllSoundEvents.SLIME_ADDED.playFrom(this, 0.5f, 0.75f);
    }

    protected void updateFacingWithBoundingBox() {
        Validate.notNull((Object)this.getFacingDirection());
        if (this.getFacingDirection().m_122434_().m_122479_()) {
            this.m_146926_(0.0f);
            this.m_146922_(this.getFacingDirection().m_122416_() * 90);
        } else {
            this.m_146926_(-90 * this.getFacingDirection().m_122421_().m_122540_());
            this.m_146922_(0.0f);
        }
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        this.updateBoundingBox();
    }

    protected void updateBoundingBox() {
        if (this.getFacingDirection() != null) {
            double offset = 0.49609375;
            double x = (double)this.hangingPosition.m_123341_() + 0.5 - (double)this.facingDirection.m_122429_() * offset;
            double y = (double)this.hangingPosition.m_123342_() + 0.5 - (double)this.facingDirection.m_122430_() * offset;
            double z = (double)this.hangingPosition.m_123343_() + 0.5 - (double)this.facingDirection.m_122431_() * offset;
            this.m_20343_(x, y, z);
            double w = this.getWidthPixels();
            double h = this.getHeightPixels();
            double l = this.getWidthPixels();
            Direction.Axis axis = this.getFacingDirection().m_122434_();
            double depth = 1.9921875;
            switch (axis) {
                case X: {
                    w = depth;
                    break;
                }
                case Y: {
                    h = depth;
                    break;
                }
                case Z: {
                    l = depth;
                }
            }
            this.m_20011_(new AABB(x - (w /= 32.0), y - (h /= 32.0), z - (l /= 32.0), x + w, y + h, z + l));
        }
    }

    public void m_8119_() {
        if (this.validationTimer++ == 10 && !this.f_19853_.f_46443_) {
            this.validationTimer = 0;
            if (this.m_6084_() && !this.onValidSurface()) {
                this.m_6074_();
                this.onBroken(null);
            }
        }
    }

    public boolean isVisible() {
        if (!this.m_6084_()) {
            return false;
        }
        if (this.f_19853_ instanceof WrappedWorld) {
            return true;
        }
        BlockPos pos = this.hangingPosition;
        BlockPos pos2 = pos.m_142300_(this.getFacingDirection().m_122424_());
        return SuperGlueEntity.isValidFace(this.f_19853_, pos2, this.getFacingDirection()) != SuperGlueEntity.isValidFace(this.f_19853_, pos, this.getFacingDirection().m_122424_());
    }

    public boolean onValidSurface() {
        BlockPos pos = this.hangingPosition;
        BlockPos pos2 = this.hangingPosition.m_142300_(this.getFacingDirection().m_122424_());
        if (this.f_19853_.m_151570_(pos2)) {
            return false;
        }
        if (!this.f_19853_.isAreaLoaded(pos, 0) || !this.f_19853_.isAreaLoaded(pos2, 0)) {
            return true;
        }
        if (!SuperGlueEntity.isValidFace(this.f_19853_, pos2, this.getFacingDirection()) && !SuperGlueEntity.isValidFace(this.f_19853_, pos, this.getFacingDirection().m_122424_())) {
            return false;
        }
        if (SuperGlueEntity.isSideSticky(this.f_19853_, pos2, this.getFacingDirection()) || SuperGlueEntity.isSideSticky(this.f_19853_, pos, this.getFacingDirection().m_122424_())) {
            return false;
        }
        return this.f_19853_.m_6249_((Entity)this, this.m_142469_(), e -> e instanceof SuperGlueEntity).isEmpty();
    }

    public static boolean isValidFace(Level world, BlockPos pos, Direction direction) {
        BlockState state = world.m_8055_(pos);
        if (BlockMovementChecks.isBlockAttachedTowards(state, world, pos, direction)) {
            return true;
        }
        if (!BlockMovementChecks.isMovementNecessary(state, world, pos)) {
            return false;
        }
        return !BlockMovementChecks.isNotSupportive(state, direction);
    }

    public static boolean isSideSticky(Level world, BlockPos pos, Direction direction) {
        BlockState state = world.m_8055_(pos);
        if (AllBlocks.STICKY_MECHANICAL_PISTON.has(state)) {
            return state.m_61143_((Property)DirectionalKineticBlock.FACING) == direction;
        }
        if (AllBlocks.STICKER.has(state)) {
            return state.m_61143_((Property)DirectionalBlock.f_52588_) == direction;
        }
        if (state.m_60734_() == Blocks.f_50374_) {
            return true;
        }
        if (state.m_60734_() == Blocks.f_50719_) {
            return true;
        }
        if (AllBlocks.CART_ASSEMBLER.has(state)) {
            return Direction.UP == direction;
        }
        if (AllBlocks.GANTRY_CARRIAGE.has(state)) {
            return state.m_61143_((Property)DirectionalKineticBlock.FACING) == direction;
        }
        if (state.m_60734_() instanceof BearingBlock) {
            return state.m_61143_((Property)DirectionalKineticBlock.FACING) == direction;
        }
        if (state.m_60734_() instanceof AbstractChassisBlock) {
            BooleanProperty glueableSide = ((AbstractChassisBlock)state.m_60734_()).getGlueableSide(state, direction);
            if (glueableSide == null) {
                return false;
            }
            return (Boolean)state.m_61143_((Property)glueableSide);
        }
        return false;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_7313_(Entity entity) {
        return entity instanceof Player ? this.m_6469_(DamageSource.m_19344_((Player)((Player)entity)), 0.0f) : false;
    }

    public Direction m_6350_() {
        return this.getFacingDirection();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        boolean mobGriefing = this.f_19853_.m_46469_().m_46207_(GameRules.f_46132_);
        Entity trueSource = source.m_7639_();
        if (!mobGriefing && trueSource instanceof Mob) {
            return false;
        }
        Entity immediateSource = source.m_7640_();
        if (!this.isVisible() && immediateSource instanceof Player && !AllItems.SUPER_GLUE.isIn(((Player)immediateSource).m_21205_())) {
            return true;
        }
        if (this.m_6084_() && !this.f_19853_.f_46443_) {
            this.onBroken(source.m_7639_());
            this.m_6074_();
            this.m_5834_();
        }
        return true;
    }

    public void m_6478_(MoverType typeIn, Vec3 pos) {
        if (!this.f_19853_.f_46443_ && this.m_6084_() && pos.m_82556_() > 0.0) {
            this.m_146870_();
            this.onBroken(null);
        }
    }

    public void m_5997_(double x, double y, double z) {
        if (!this.f_19853_.f_46443_ && this.m_6084_() && x * x + y * y + z * z > 0.0) {
            this.m_146870_();
            this.onBroken(null);
        }
    }

    protected float m_6380_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.0f;
    }

    public ItemStack getPickedResult(HitResult target) {
        return AllItems.SUPER_GLUE.asStack();
    }

    public void m_7334_(Entity entityIn) {
        super.m_7334_(entityIn);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player instanceof FakePlayer) {
            return InteractionResult.PASS;
        }
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.triggerPlaceBlock(player, hand));
        return InteractionResult.CONSUME;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void triggerPlaceBlock(Player player, InteractionHand hand) {
        BlockFace hangingFace;
        if (!(player instanceof LocalPlayer)) {
            return;
        }
        if (!(player.f_19853_ instanceof ClientLevel)) {
            return;
        }
        LocalPlayer cPlayer = (LocalPlayer)player;
        Minecraft mc = Minecraft.m_91087_();
        HitResult ray = cPlayer.m_19907_((double)mc.f_91072_.m_105286_(), AnimationTickHolder.getPartialTicks(), false);
        if (!(ray instanceof BlockHitResult)) {
            return;
        }
        if (ray.m_6662_() == HitResult.Type.MISS) {
            return;
        }
        BlockHitResult blockRay = (BlockHitResult)ray;
        BlockFace rayFace = new BlockFace(blockRay.m_82425_(), blockRay.m_82434_());
        if (!rayFace.isEquivalent(hangingFace = new BlockFace(this.getHangingPosition(), this.getFacingDirection().m_122424_()))) {
            return;
        }
        int n = 0;
        InteractionHand[] interactionHandArray = InteractionHand.values();
        int n2 = interactionHandArray.length;
        if (n < n2) {
            InteractionHand handIn = interactionHandArray[n];
            ItemStack itemstack = cPlayer.m_21120_(handIn);
            int countBefore = itemstack.m_41613_();
            InteractionResult actionResultType = mc.f_91072_.m_105262_(cPlayer, (ClientLevel)cPlayer.f_19853_, handIn, blockRay);
            if (actionResultType != InteractionResult.SUCCESS) {
                return;
            }
            cPlayer.m_6674_(handIn);
            if (!itemstack.m_41619_() && (itemstack.m_41613_() != countBefore || mc.f_91072_.m_105290_())) {
                mc.f_91063_.f_109055_.m_109320_(handIn);
            }
            return;
        }
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128344_("Facing", (byte)this.getFacingDirection().m_122411_());
        BlockPos blockpos = this.getHangingPosition();
        compound.m_128405_("TileX", blockpos.m_123341_());
        compound.m_128405_("TileY", blockpos.m_123342_());
        compound.m_128405_("TileZ", blockpos.m_123343_());
    }

    public void m_7378_(CompoundTag compound) {
        this.hangingPosition = new BlockPos(compound.m_128451_("TileX"), compound.m_128451_("TileY"), compound.m_128451_("TileZ"));
        this.facingDirection = Direction.m_122376_((int)compound.m_128445_("Facing"));
        this.updateFacingWithBoundingBox();
    }

    public ItemEntity m_5552_(ItemStack stack, float yOffset) {
        float xOffset = (float)this.getFacingDirection().m_122429_() * 0.15f;
        float zOffset = (float)this.getFacingDirection().m_122431_() * 0.15f;
        ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_() + (double)xOffset, this.m_20186_() + (double)yOffset, this.m_20189_() + (double)zOffset, stack);
        itementity.m_32060_();
        this.f_19853_.m_7967_((Entity)itementity);
        return itementity;
    }

    protected boolean m_6093_() {
        return false;
    }

    public void m_6034_(double x, double y, double z) {
        this.hangingPosition = new BlockPos(x, y, z);
        this.updateBoundingBox();
        this.f_19812_ = true;
    }

    public float m_7890_(Rotation transformRotation) {
        if (this.getFacingDirection().m_122434_() != Direction.Axis.Y) {
            switch (transformRotation) {
                case CLOCKWISE_180: {
                    this.facingDirection = this.facingDirection.m_122424_();
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    this.facingDirection = this.facingDirection.m_122428_();
                    break;
                }
                case CLOCKWISE_90: {
                    this.facingDirection = this.facingDirection.m_122427_();
                }
            }
        }
        float f = Mth.m_14177_((float)this.m_146908_());
        return switch (transformRotation) {
            case Rotation.CLOCKWISE_180 -> f + 180.0f;
            case Rotation.COUNTERCLOCKWISE_90 -> f + 90.0f;
            case Rotation.CLOCKWISE_90 -> f + 270.0f;
            default -> f;
        };
    }

    public BlockPos getHangingPosition() {
        return this.hangingPosition;
    }

    public float m_6961_(Mirror transformMirror) {
        return this.m_7890_(transformMirror.m_54846_(this.getFacingDirection()));
    }

    public Direction getAttachedDirection(BlockPos pos) {
        return !pos.equals((Object)this.hangingPosition) ? this.getFacingDirection() : this.getFacingDirection().m_122424_();
    }

    public void m_8038_(ServerLevel world, LightningBolt lightningBolt) {
    }

    public void m_6210_() {
    }

    public static EntityType.Builder<?> build(EntityType.Builder<?> builder) {
        EntityType.Builder<?> entityBuilder = builder;
        return entityBuilder;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        CompoundTag compound = new CompoundTag();
        this.m_7380_(compound);
        buffer.m_130079_(compound);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.m_7378_(additionalData.m_130260_());
    }

    public Direction getFacingDirection() {
        return this.facingDirection;
    }

    @Override
    public ItemRequirement getRequiredItems() {
        return new ItemRequirement(ItemRequirement.ItemUseType.DAMAGE, (Item)AllItems.SUPER_GLUE.get());
    }

    public boolean m_6090_() {
        return true;
    }
}

