/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.actors.SeatEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionDisassemblyPacket;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionStallPacket;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.StructureTransform;
import com.simibubi.create.content.contraptions.components.structureMovement.TranslatingContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.glue.SuperGlueEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.MountedContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.sync.ContraptionSeatMappingPacket;
import com.simibubi.create.foundation.collision.Matrix3d;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.io.DataOutput;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.MutablePair;

public abstract class AbstractContraptionEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private static final EntityDataAccessor<Boolean> STALLED = SynchedEntityData.m_135353_(AbstractContraptionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final Map<Entity, MutableInt> collidingEntities = new IdentityHashMap<Entity, MutableInt>();
    protected Contraption contraption;
    protected boolean initialized;
    protected boolean prevPosInvalid = true;
    private boolean ticking;

    public AbstractContraptionEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    protected void setContraption(Contraption contraption) {
        this.contraption = contraption;
        if (contraption == null) {
            return;
        }
        if (this.f_19853_.f_46443_) {
            return;
        }
        contraption.onEntityCreated(this);
    }

    public boolean supportsTerrainCollision() {
        return this.contraption instanceof TranslatingContraption;
    }

    protected void contraptionInitialize() {
        this.contraption.onEntityInitialize(this.f_19853_, this);
        this.initialized = true;
    }

    public boolean collisionEnabled() {
        return true;
    }

    public void addSittingPassenger(Entity passenger, int seatIndex) {
        passenger.m_7998_((Entity)this, true);
        if (this.f_19853_.f_46443_) {
            return;
        }
        this.contraption.getSeatMapping().put(passenger.m_142081_(), seatIndex);
        AllPackets.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ContraptionSeatMappingPacket(this.m_142049_(), this.contraption.getSeatMapping()));
    }

    protected void m_20351_(Entity passenger) {
        Vec3 transformedVector = this.getPassengerPosition(passenger, 1.0f);
        super.m_20351_(passenger);
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (transformedVector != null) {
            passenger.getPersistentData().m_128365_("ContraptionDismountLocation", (Tag)VecHelper.writeNBT(transformedVector));
        }
        this.contraption.getSeatMapping().remove(passenger.m_142081_());
        AllPackets.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ContraptionSeatMappingPacket(this.m_142049_(), this.contraption.getSeatMapping()));
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        Vec3 transformedVector = this.getPassengerPosition(passenger, 1.0f);
        if (transformedVector == null) {
            return;
        }
        callback.m_20372_(passenger, transformedVector.f_82479_, transformedVector.f_82480_, transformedVector.f_82481_);
    }

    protected Vec3 getPassengerPosition(Entity passenger, float partialTicks) {
        BlockPos localPos;
        UUID id = passenger.m_142081_();
        if (passenger instanceof OrientedContraptionEntity && (localPos = this.contraption.getBearingPosOf(id)) != null) {
            return this.toGlobalVector(VecHelper.getCenterOf((Vec3i)localPos), partialTicks).m_82549_(VecHelper.getCenterOf((Vec3i)BlockPos.f_121853_)).m_82492_(0.5, 1.0, 0.5);
        }
        AABB bb = passenger.m_142469_();
        double ySize = bb.m_82376_();
        BlockPos seat = this.contraption.getSeatOf(id);
        if (seat == null) {
            return null;
        }
        Vec3 transformedVector = this.toGlobalVector(Vec3.m_82528_((Vec3i)seat).m_82520_(0.5, passenger.m_6049_() + ySize - (double)0.15f, 0.5), partialTicks).m_82549_(VecHelper.getCenterOf((Vec3i)BlockPos.f_121853_)).m_82492_(0.5, ySize, 0.5);
        return transformedVector;
    }

    protected boolean m_7310_(Entity p_184219_1_) {
        if (p_184219_1_ instanceof OrientedContraptionEntity) {
            return true;
        }
        return this.contraption.getSeatMapping().size() < this.contraption.getSeats().size();
    }

    public boolean handlePlayerInteraction(Player player, BlockPos localPos, Direction side, InteractionHand interactionHand) {
        int indexOfSeat = this.contraption.getSeats().indexOf(localPos);
        if (indexOfSeat == -1) {
            return this.contraption.interactors.containsKey(localPos) && this.contraption.interactors.get(localPos).handlePlayerInteraction(player, interactionHand, localPos, this);
        }
        Entity toDismount = null;
        for (Map.Entry<UUID, Integer> entry : this.contraption.getSeatMapping().entrySet()) {
            if (entry.getValue() != indexOfSeat) continue;
            for (Entity entity : this.m_20197_()) {
                if (!entry.getKey().equals(entity.m_142081_())) continue;
                if (entity instanceof Player) {
                    return false;
                }
                toDismount = entity;
            }
        }
        if (toDismount != null && !this.f_19853_.f_46443_) {
            Vec3 transformedVector = this.getPassengerPosition(toDismount, 1.0f);
            toDismount.m_8127_();
            if (transformedVector != null) {
                toDismount.m_6021_(transformedVector.f_82479_, transformedVector.f_82480_, transformedVector.f_82481_);
            }
        }
        if (this.f_19853_.f_46443_) {
            return true;
        }
        this.addSittingPassenger((Entity)player, indexOfSeat);
        return true;
    }

    public Vec3 toGlobalVector(Vec3 localVec, float partialTicks) {
        Vec3 rotationOffset = VecHelper.getCenterOf((Vec3i)BlockPos.f_121853_);
        localVec = localVec.m_82546_(rotationOffset);
        localVec = this.applyRotation(localVec, partialTicks);
        localVec = localVec.m_82549_(rotationOffset).m_82549_(this.getAnchorVec());
        return localVec;
    }

    public Vec3 toLocalVector(Vec3 globalVec, float partialTicks) {
        Vec3 rotationOffset = VecHelper.getCenterOf((Vec3i)BlockPos.f_121853_);
        globalVec = globalVec.m_82546_(this.getAnchorVec()).m_82546_(rotationOffset);
        globalVec = this.reverseRotation(globalVec, partialTicks);
        globalVec = globalVec.m_82549_(rotationOffset);
        return globalVec;
    }

    public final void m_8119_() {
        if (this.contraption == null) {
            this.m_146870_();
            return;
        }
        this.collidingEntities.entrySet().removeIf(e -> ((MutableInt)e.getValue()).incrementAndGet() > 3);
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        this.prevPosInvalid = false;
        if (!this.initialized) {
            this.contraptionInitialize();
        }
        this.contraption.onEntityTick(this.f_19853_);
        this.tickContraption();
        super.m_8119_();
    }

    protected abstract void tickContraption();

    public abstract Vec3 applyRotation(Vec3 var1, float var2);

    public abstract Vec3 reverseRotation(Vec3 var1, float var2);

    public void tickActors() {
        boolean stalledPreviously = this.contraption.stalled;
        if (!this.f_19853_.f_46443_) {
            this.contraption.stalled = false;
        }
        this.ticking = true;
        for (MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> pair : this.contraption.getActors()) {
            MovementContext context = (MovementContext)pair.right;
            StructureTemplate.StructureBlockInfo blockInfo = (StructureTemplate.StructureBlockInfo)pair.left;
            MovementBehaviour actor = AllMovementBehaviours.of(blockInfo.f_74676_);
            Vec3 oldMotion = context.motion;
            Vec3 actorPosition = this.toGlobalVector(VecHelper.getCenterOf((Vec3i)blockInfo.f_74675_).m_82549_(actor.getActiveAreaOffset(context)), 1.0f);
            BlockPos gridPosition = new BlockPos(actorPosition);
            boolean newPosVisited = !context.stall && this.shouldActorTrigger(context, blockInfo, actor, actorPosition, gridPosition);
            context.rotation = v -> this.applyRotation((Vec3)v, 1.0f);
            context.position = actorPosition;
            if (!actor.isActive(context)) continue;
            if (newPosVisited && !context.stall) {
                actor.visitNewPosition(context, gridPosition);
                if (!this.m_6084_()) break;
                context.firstMovement = false;
            }
            if (!oldMotion.equals((Object)context.motion)) {
                actor.onSpeedChanged(context, oldMotion, context.motion);
                if (!this.m_6084_()) break;
            }
            actor.tick(context);
            if (!this.m_6084_()) break;
            this.contraption.stalled |= context.stall;
        }
        if (!this.m_6084_()) {
            this.contraption.stop(this.f_19853_);
            return;
        }
        this.ticking = false;
        for (Entity entity : this.m_20197_()) {
            if (!(entity instanceof OrientedContraptionEntity) || !this.contraption.stabilizedSubContraptions.containsKey(entity.m_142081_())) continue;
            OrientedContraptionEntity orientedCE = (OrientedContraptionEntity)entity;
            if (orientedCE.contraption == null || !orientedCE.contraption.stalled) continue;
            this.contraption.stalled = true;
            break;
        }
        if (!this.f_19853_.f_46443_) {
            if (!stalledPreviously && this.contraption.stalled) {
                this.onContraptionStalled();
            }
            this.f_19804_.m_135381_(STALLED, (Object)this.contraption.stalled);
            return;
        }
        this.contraption.stalled = this.isStalled();
    }

    protected void onContraptionStalled() {
        AllPackets.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ContraptionStallPacket(this.m_142049_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getStalledAngle()));
    }

    protected boolean shouldActorTrigger(MovementContext context, StructureTemplate.StructureBlockInfo blockInfo, MovementBehaviour actor, Vec3 actorPosition, BlockPos gridPosition) {
        Vec3 previousPosition = context.position;
        if (previousPosition == null) {
            return false;
        }
        Vec3 relativeMotion = context.motion = actorPosition.m_82546_(previousPosition);
        context.relativeMotion = relativeMotion = this.reverseRotation(relativeMotion, 1.0f);
        return !new BlockPos(previousPosition).equals((Object)gridPosition) || context.relativeMotion.m_82553_() > 0.0 && context.firstMovement;
    }

    public void move(double x, double y, double z) {
        this.m_6034_(this.m_20185_() + x, this.m_20186_() + y, this.m_20189_() + z);
    }

    public Vec3 getAnchorVec() {
        return this.m_20182_();
    }

    public float getYawOffset() {
        return 0.0f;
    }

    public void m_6034_(double x, double y, double z) {
        super.m_6034_(x, y, z);
        if (this.contraption == null) {
            return;
        }
        AABB cbox = this.contraption.bounds;
        if (cbox == null) {
            return;
        }
        Vec3 actualVec = this.getAnchorVec();
        this.m_20011_(cbox.m_82383_(actualVec));
    }

    public static float yawFromVector(Vec3 vec) {
        return (float)((4.71238898038469 + Math.atan2(vec.f_82481_, vec.f_82479_)) / Math.PI * 180.0);
    }

    public static float pitchFromVector(Vec3 vec) {
        return (float)(Math.acos(vec.f_82480_) / Math.PI * 180.0);
    }

    public static EntityType.Builder<?> build(EntityType.Builder<?> builder) {
        EntityType.Builder<?> entityBuilder = builder;
        return entityBuilder.m_20699_(1.0f, 1.0f);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(STALLED, (Object)false);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        CompoundTag compound = new CompoundTag();
        this.writeAdditional(compound, true);
        try {
            ByteArrayDataOutput dataOutput = ByteStreams.newDataOutput();
            NbtIo.m_128941_((CompoundTag)compound, (DataOutput)dataOutput);
            byte[] byteArray = dataOutput.toByteArray();
            int estimatedPacketSize = byteArray.length;
            if (estimatedPacketSize > 2000000) {
                Create.LOGGER.warn("Could not send Contraption Spawn Data (Packet too big): " + this.getContraption().getType().id + " @" + this.m_20182_() + " (" + this.m_142081_().toString() + ")");
                buffer.m_130079_(new CompoundTag());
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            buffer.m_130079_(new CompoundTag());
            return;
        }
        buffer.m_130079_(compound);
    }

    protected final void m_7380_(CompoundTag compound) {
        this.writeAdditional(compound, false);
    }

    protected void writeAdditional(CompoundTag compound, boolean spawnPacket) {
        if (this.contraption != null) {
            compound.m_128365_("Contraption", (Tag)this.contraption.writeNBT(spawnPacket));
        }
        compound.m_128379_("Stalled", this.isStalled());
        compound.m_128379_("Initialized", this.initialized);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.readAdditional(additionalData.m_130260_(), true);
    }

    protected final void m_7378_(CompoundTag compound) {
        this.readAdditional(compound, false);
    }

    protected void readAdditional(CompoundTag compound, boolean spawnData) {
        if (compound.m_128456_()) {
            return;
        }
        this.initialized = compound.m_128471_("Initialized");
        this.contraption = Contraption.fromNBT(this.f_19853_, compound.m_128469_("Contraption"), spawnData);
        this.contraption.entity = this;
        this.f_19804_.m_135381_(STALLED, (Object)compound.m_128471_("Stalled"));
    }

    public void disassemble() {
        if (!this.m_6084_()) {
            return;
        }
        if (this.contraption == null) {
            return;
        }
        StructureTransform transform = this.makeStructureTransform();
        AllPackets.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ContraptionDisassemblyPacket(this.m_142049_(), transform));
        this.m_146870_();
        this.contraption.addBlocksToWorld(this.f_19853_, transform);
        this.contraption.addPassengersToWorld(this.f_19853_, transform, this.m_20197_());
        for (Entity entity : this.m_20197_()) {
            UUID id;
            if (!(entity instanceof OrientedContraptionEntity) || !this.contraption.stabilizedSubContraptions.containsKey(id = entity.m_142081_())) continue;
            BlockPos transformed = transform.apply(this.contraption.stabilizedSubContraptions.get(id).getConnectedPos());
            entity.m_6034_((double)transformed.m_123341_(), (double)transformed.m_123342_(), (double)transformed.m_123343_());
            ((AbstractContraptionEntity)entity).disassemble();
        }
        this.m_20153_();
        this.moveCollidedEntitiesOnDisassembly(transform);
        AllSoundEvents.CONTRAPTION_DISASSEMBLE.playOnServer(this.f_19853_, (Vec3i)this.m_142538_());
    }

    private void moveCollidedEntitiesOnDisassembly(StructureTransform transform) {
        for (Entity entity : this.collidingEntities.keySet()) {
            Vec3 localVec = this.toLocalVector(entity.m_20182_(), 0.0f);
            Vec3 transformed = transform.apply(localVec);
            if (this.f_19853_.f_46443_) {
                entity.m_6034_(transformed.f_82479_, transformed.f_82480_ + 0.0625, transformed.f_82481_);
                continue;
            }
            entity.m_6021_(transformed.f_82479_, transformed.f_82480_ + 0.0625, transformed.f_82481_);
        }
    }

    public void m_142687_(Entity.RemovalReason p_146834_) {
        if (!(this.f_19853_.f_46443_ || this.m_146910_() || this.contraption == null || this.ticking)) {
            this.contraption.stop(this.f_19853_);
        }
        if (this.contraption != null) {
            this.contraption.onEntityRemoved(this);
        }
        super.m_142687_(p_146834_);
    }

    protected abstract StructureTransform makeStructureTransform();

    public void m_6074_() {
        this.m_20153_();
        super.m_6074_();
    }

    protected void m_6088_() {
        this.m_20153_();
        super.m_6088_();
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (this.f_19853_ != null && this.f_19853_.f_46443_) {
            return;
        }
        this.m_20197_().forEach(Entity::m_146870_);
    }

    protected void m_5841_() {
    }

    public Contraption getContraption() {
        return this.contraption;
    }

    public boolean isStalled() {
        return (Boolean)this.f_19804_.m_135370_(STALLED);
    }

    @OnlyIn(value=Dist.CLIENT)
    static void handleStallPacket(ContraptionStallPacket packet) {
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(packet.entityID);
        if (!(entity instanceof AbstractContraptionEntity)) {
            return;
        }
        AbstractContraptionEntity ce = (AbstractContraptionEntity)entity;
        ce.handleStallInformation(packet.x, packet.y, packet.z, packet.angle);
    }

    @OnlyIn(value=Dist.CLIENT)
    static void handleDisassemblyPacket(ContraptionDisassemblyPacket packet) {
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(packet.entityID);
        if (!(entity instanceof AbstractContraptionEntity)) {
            return;
        }
        AbstractContraptionEntity ce = (AbstractContraptionEntity)entity;
        ce.moveCollidedEntitiesOnDisassembly(packet.transform);
    }

    protected abstract float getStalledAngle();

    protected abstract void handleStallInformation(float var1, float var2, float var3, float var4);

    public CompoundTag m_20240_(CompoundTag nbt) {
        Vec3 vec = this.m_20182_();
        List passengers = this.m_20197_();
        for (Entity entity : passengers) {
            String srg = "f_146795_";
            ObfuscationReflectionHelper.setPrivateValue(Entity.class, (Object)entity, (Object)Entity.RemovalReason.UNLOADED_TO_CHUNK, (String)srg);
            Vec3 prevVec = entity.m_20182_();
            entity.m_20343_(vec.f_82479_, prevVec.f_82480_, vec.f_82481_);
            ObfuscationReflectionHelper.setPrivateValue(Entity.class, (Object)entity, null, (String)srg);
        }
        CompoundTag tag = super.m_20240_(nbt);
        return tag;
    }

    public void m_20256_(Vec3 motionIn) {
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public void setContraptionMotion(Vec3 vec) {
        super.m_20256_(vec);
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public Vec3 getPrevPositionVec() {
        return this.prevPosInvalid ? this.m_20182_() : new Vec3(this.f_19854_, this.f_19855_, this.f_19856_);
    }

    public abstract ContraptionRotationState getRotationState();

    public Vec3 getContactPointMotion(Vec3 globalContactPoint) {
        if (this.prevPosInvalid) {
            return Vec3.f_82478_;
        }
        Vec3 contactPoint = this.toGlobalVector(this.toLocalVector(globalContactPoint, 0.0f), 1.0f);
        return contactPoint.m_82546_(globalContactPoint).m_82549_(this.m_20182_().m_82546_(this.getPrevPositionVec()));
    }

    public boolean m_7337_(Entity e) {
        if (e instanceof Player && e.m_5833_()) {
            return false;
        }
        if (e.f_19794_) {
            return false;
        }
        if (e instanceof HangingEntity) {
            return false;
        }
        if (e instanceof AbstractMinecart) {
            return !(this.contraption instanceof MountedContraption);
        }
        if (e instanceof SuperGlueEntity) {
            return false;
        }
        if (e instanceof SeatEntity) {
            return false;
        }
        if (e instanceof Projectile) {
            return false;
        }
        if (e.m_20202_() != null) {
            return false;
        }
        for (Entity riding = this.m_20202_(); riding != null; riding = riding.m_20202_()) {
            if (riding != e) continue;
            return false;
        }
        return e.m_7752_() == PushReaction.NORMAL;
    }

    public boolean m_146898_() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void doLocalTransforms(float var1, PoseStack[] var2);

    protected boolean m_20073_() {
        return false;
    }

    public void m_20254_(int p_70015_1_) {
    }

    public static class ContraptionRotationState {
        public static final ContraptionRotationState NONE = new ContraptionRotationState();
        float xRotation = 0.0f;
        float yRotation = 0.0f;
        float zRotation = 0.0f;
        float secondYRotation = 0.0f;
        Matrix3d matrix;

        public Matrix3d asMatrix() {
            if (this.matrix != null) {
                return this.matrix;
            }
            this.matrix = new Matrix3d().asIdentity();
            if (this.xRotation != 0.0f) {
                this.matrix.multiply(new Matrix3d().asXRotation(AngleHelper.rad(-this.xRotation)));
            }
            if (this.yRotation != 0.0f) {
                this.matrix.multiply(new Matrix3d().asYRotation(AngleHelper.rad(this.yRotation)));
            }
            if (this.zRotation != 0.0f) {
                this.matrix.multiply(new Matrix3d().asZRotation(AngleHelper.rad(-this.zRotation)));
            }
            return this.matrix;
        }

        public boolean hasVerticalRotation() {
            return this.xRotation != 0.0f || this.zRotation != 0.0f;
        }

        public float getYawOffset() {
            return this.secondYRotation;
        }
    }
}

