/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllItems;
import com.simibubi.create.compat.jei.category.ProcessingViaFanCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedKinetics;
import com.simibubi.create.content.contraptions.components.fan.HauntingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingOutput;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class FanHauntingCategory
extends ProcessingViaFanCategory<HauntingRecipe> {
    public FanHauntingCategory() {
        super(185, FanHauntingCategory.doubleItemIcon((ItemLike)AllItems.PROPELLER.get(), (ItemLike)Items.f_42782_));
    }

    public Class<? extends HauntingRecipe> getRecipeClass() {
        return HauntingRecipe.class;
    }

    @Override
    public void setIngredients(HauntingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.m_7527_());
        ingredients.setOutputs(VanillaTypes.ITEM, recipe.getRollableResultsAsItemStacks());
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, HauntingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        NonNullList<ProcessingOutput> results = recipe.getRollableResults();
        int xOffsetGlobal = 8 * (3 - Math.min(3, results.size()));
        itemStacks.init(0, true, xOffsetGlobal + 12, 47);
        itemStacks.set(0, Arrays.asList(((Ingredient)recipe.m_7527_().get(0)).m_43908_()));
        boolean single = results.size() == 1;
        boolean excessive = results.size() > 9;
        for (int outputIndex = 0; outputIndex < results.size(); ++outputIndex) {
            int xOffset = outputIndex % 3 * 19;
            int yOffset = outputIndex / 3 * -19;
            itemStacks.init(outputIndex + 1, false, xOffsetGlobal + (single ? 126 : 126 + xOffset), 47 + yOffset + (excessive ? 8 : 0));
            itemStacks.set(outputIndex + 1, ((ProcessingOutput)results.get(outputIndex)).getStack());
        }
        FanHauntingCategory.addStochasticTooltip(itemStacks, results);
    }

    @Override
    protected void renderWidgets(PoseStack matrixStack, HauntingRecipe recipe, double mouseX, double mouseY) {
        int size = recipe.getRollableResultsAsItemStacks().size();
        int xOffsetGlobal = 8 * (3 - Math.min(3, size));
        AllGuiTextures.JEI_SLOT.render(matrixStack, xOffsetGlobal + 12, 47);
        AllGuiTextures.JEI_SHADOW.render(matrixStack, 51, 29);
        AllGuiTextures.JEI_SHADOW.render(matrixStack, 70, 39);
        AllGuiTextures.JEI_LONG_ARROW.render(matrixStack, xOffsetGlobal + 42, 51);
        if (size == 1) {
            FanHauntingCategory.getRenderedSlot(recipe, 0).render(matrixStack, xOffsetGlobal + 126, 47);
            return;
        }
        for (int i = 0; i < size; ++i) {
            int xOffset = i % 3 * 19;
            int yOffset = i / 3 * -19 + (size > 9 ? 8 : 0);
            FanHauntingCategory.getRenderedSlot(recipe, i).render(matrixStack, xOffsetGlobal + 126 + xOffset, 47 + yOffset);
        }
    }

    @Override
    protected void translateFan(PoseStack ms) {
        ms.m_85837_(60.0, 33.0, 0.0);
    }

    @Override
    public void renderAttachedBlock(PoseStack matrixStack) {
        matrixStack.m_85836_();
        GuiGameElement.of(Blocks.f_50084_.m_49966_()).scale(24.0).atLocal(0.0, 0.0, 2.0).lighting(AnimatedKinetics.DEFAULT_LIGHTING).render(matrixStack);
        matrixStack.m_85849_();
    }
}

