/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import moze_intel.projecte.PECore;
import moze_intel.projecte.gameObjs.PETags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.level.Level;

public class EntityRandomizerHelper {
    public static Mob getRandomEntity(Level level, Mob toRandomize) {
        Rabbit rabbit;
        EntityType entType = toRandomize.m_6095_();
        boolean isPeaceful = PETags.Entities.RANDOMIZER_PEACEFUL.m_8110_((Object)entType);
        boolean isHostile = PETags.Entities.RANDOMIZER_HOSTILE.m_8110_((Object)entType);
        if (isPeaceful && isHostile && toRandomize instanceof Rabbit && (rabbit = (Rabbit)toRandomize).m_29719_() == 99) {
            isPeaceful = false;
        }
        if (isPeaceful) {
            return EntityRandomizerHelper.createRandomEntity(level, (Entity)toRandomize, PETags.Entities.RANDOMIZER_PEACEFUL);
        }
        if (isHostile) {
            Mob ent = EntityRandomizerHelper.createRandomEntity(level, (Entity)toRandomize, PETags.Entities.RANDOMIZER_HOSTILE);
            if (ent instanceof Rabbit) {
                Rabbit rabbit2 = (Rabbit)ent;
                rabbit2.m_29733_(99);
            }
            return ent;
        }
        if (level.f_46441_.nextBoolean()) {
            return (Mob)EntityType.f_20526_.m_20615_(level);
        }
        return (Mob)EntityType.f_20520_.m_20615_(level);
    }

    @Nullable
    private static Mob createRandomEntity(Level level, Entity current, Tag.Named<EntityType<?>> type) {
        EntityType newType;
        EntityType currentType = current.m_6095_();
        if (currentType == (newType = EntityRandomizerHelper.getRandomTagEntry(level.m_5822_(), type, currentType))) {
            return null;
        }
        Entity newEntity = newType.m_20615_(level);
        if (newEntity instanceof Mob) {
            return (Mob)newEntity;
        }
        if (newEntity != null) {
            newEntity.m_146870_();
            PECore.LOGGER.warn("Invalid Entity type {} in mob randomizer tag {}. All entities in this tag are expected to be a mob.", (Object)newType.getRegistryName(), (Object)type.m_6979_());
        }
        return null;
    }

    private static <T> T getRandomTagEntry(Random random, Tag<T> tag, T toExclude) {
        Object obj;
        List list = tag.m_6497_();
        if (list.isEmpty() || list.size() == 1 && list.contains(toExclude)) {
            return toExclude;
        }
        while ((obj = tag.m_13288_(random)).equals(toExclude)) {
        }
        return (T)obj;
    }
}

