/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.packets.to_server;

import java.util.Optional;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.armor.GemArmorBase;
import moze_intel.projecte.gameObjs.items.armor.GemChest;
import moze_intel.projecte.gameObjs.items.armor.GemFeet;
import moze_intel.projecte.gameObjs.items.armor.GemHelmet;
import moze_intel.projecte.handlers.InternalAbilities;
import moze_intel.projecte.network.packets.IPEPacket;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.NonNullPredicate;
import net.minecraftforge.network.NetworkEvent;

public record KeyPressPKT(PEKeybind key) implements IPEPacket
{
    @Override
    public void handle(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        if (this.key == PEKeybind.HELMET_TOGGLE) {
            ItemStack helm = player.m_6844_(EquipmentSlot.HEAD);
            if (!helm.m_41619_() && helm.m_41720_() instanceof GemHelmet) {
                GemHelmet.toggleNightVision(helm, (Player)player);
            }
            return;
        }
        if (this.key == PEKeybind.BOOTS_TOGGLE) {
            ItemStack boots = player.m_6844_(EquipmentSlot.FEET);
            if (!boots.m_41619_() && boots.m_41720_() instanceof GemFeet) {
                ((GemFeet)boots.m_41720_()).toggleStepAssist(boots, (Player)player);
            }
            return;
        }
        Optional cap = player.getCapability(InternalAbilities.CAPABILITY).resolve();
        if (cap.isEmpty()) {
            return;
        }
        InternalAbilities internalAbilities = (InternalAbilities)cap.get();
        block6: for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = player.m_21120_(hand);
            switch (this.key) {
                case CHARGE: {
                    if (KeyPressPKT.tryPerformCapability(stack, PECapabilities.CHARGE_ITEM_CAPABILITY, capability -> capability.changeCharge((Player)player, stack, hand))) {
                        return;
                    }
                    if (hand != InteractionHand.MAIN_HAND || !KeyPressPKT.isSafe(stack) || !GemArmorBase.hasAnyPiece((Player)player)) continue block6;
                    internalAbilities.setGemState(!internalAbilities.getGemState());
                    PELang langEntry = internalAbilities.getGemState() ? PELang.GEM_ACTIVATE : PELang.GEM_DEACTIVATE;
                    player.m_6352_((Component)langEntry.translate(new Object[0]), Util.f_137441_);
                    return;
                }
                case EXTRA_FUNCTION: {
                    Item item;
                    ItemStack chestplate;
                    if (KeyPressPKT.tryPerformCapability(stack, PECapabilities.EXTRA_FUNCTION_ITEM_CAPABILITY, capability -> capability.doExtraFunction(stack, (Player)player, hand))) {
                        return;
                    }
                    if (hand != InteractionHand.MAIN_HAND || !KeyPressPKT.isSafe(stack) || !internalAbilities.getGemState() || (chestplate = player.m_6844_(EquipmentSlot.CHEST)).m_41619_() || !((item = chestplate.m_41720_()) instanceof GemChest)) continue block6;
                    GemChest chest = (GemChest)item;
                    if (internalAbilities.getGemCooldown() != 0) continue block6;
                    chest.doExplode((Player)player);
                    internalAbilities.resetGemCooldown();
                    return;
                }
                case FIRE_PROJECTILE: {
                    ItemStack helmet;
                    Item item;
                    if (!stack.m_41619_() && internalAbilities.getProjectileCooldown() == 0 && KeyPressPKT.tryPerformCapability(stack, PECapabilities.PROJECTILE_SHOOTER_ITEM_CAPABILITY, capability -> capability.shootProjectile((Player)player, stack, hand))) {
                        PlayerHelper.swingItem((Player)player, hand);
                        internalAbilities.resetProjectileCooldown();
                    }
                    if (hand != InteractionHand.MAIN_HAND || !KeyPressPKT.isSafe(stack) || !internalAbilities.getGemState() || (helmet = player.m_6844_(EquipmentSlot.HEAD)).m_41619_() || !((item = helmet.m_41720_()) instanceof GemHelmet)) continue block6;
                    GemHelmet gemHelmet = (GemHelmet)item;
                    gemHelmet.doZap((Player)player);
                    return;
                }
                case MODE: {
                    if (!KeyPressPKT.tryPerformCapability(stack, PECapabilities.MODE_CHANGER_ITEM_CAPABILITY, capability -> capability.changeMode((Player)player, stack, hand))) continue block6;
                    return;
                }
            }
        }
    }

    private static <CAPABILITY> boolean tryPerformCapability(ItemStack stack, Capability<CAPABILITY> capability, NonNullPredicate<CAPABILITY> perform) {
        return !stack.m_41619_() && stack.getCapability(capability).filter(perform).isPresent();
    }

    private static boolean isSafe(ItemStack stack) {
        return ProjectEConfig.server.misc.unsafeKeyBinds.get() || stack.m_41619_();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.key);
    }

    public static KeyPressPKT decode(FriendlyByteBuf buf) {
        return new KeyPressPKT((PEKeybind)buf.m_130066_(PEKeybind.class));
    }
}

