/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.jei.world_transmute;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredients;
import moze_intel.projecte.api.imc.WorldTransmutationEntry;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class WorldTransmuteEntry {
    private static final StateInfo EMPTY = new StateInfo(ItemStack.f_41583_, FluidStack.EMPTY);
    private final StateInfo input;
    private final StateInfo leftOutput;
    private final StateInfo rightOutput;

    public WorldTransmuteEntry(WorldTransmutationEntry transmutationEntry) {
        BlockState leftOutputState = transmutationEntry.result();
        BlockState rightOutputState = transmutationEntry.altResult();
        if (leftOutputState == rightOutputState) {
            rightOutputState = null;
        }
        this.input = this.createInfo(transmutationEntry.origin());
        this.leftOutput = this.createInfo(leftOutputState);
        this.rightOutput = this.createInfo(rightOutputState);
    }

    private StateInfo createInfo(@Nullable BlockState output) {
        if (output == null) {
            return EMPTY;
        }
        FluidStack outputFluid = this.fluidFromBlock(output.m_60734_());
        if (outputFluid.isEmpty()) {
            return new StateInfo(this.itemFromBlock(output.m_60734_(), output), outputFluid);
        }
        return new StateInfo(ItemStack.f_41583_, outputFluid);
    }

    private FluidStack fluidFromBlock(Block block) {
        if (block instanceof LiquidBlock) {
            LiquidBlock liquidBlock = (LiquidBlock)block;
            return new FluidStack((Fluid)liquidBlock.getFluid(), 1000);
        }
        if (block instanceof IFluidBlock) {
            IFluidBlock fluidBlock = (IFluidBlock)block;
            return new FluidStack(fluidBlock.getFluid(), 1000);
        }
        return FluidStack.EMPTY;
    }

    private ItemStack itemFromBlock(Block block, BlockState state) {
        try {
            return block.getCloneItemStack(state, null, null, null, null);
        }
        catch (Exception e) {
            return new ItemStack((ItemLike)block);
        }
    }

    public boolean isRenderable() {
        return !this.input.isEmpty() && (!this.leftOutput.isEmpty() || !this.rightOutput.isEmpty());
    }

    public void setIngredients(@Nonnull IIngredients ingredients) {
        if (!this.input.fluid().isEmpty()) {
            ingredients.setInput(VanillaTypes.FLUID, (Object)this.input.fluid());
        } else if (!this.input.item().m_41619_()) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)this.input.item());
        }
        ArrayList<FluidStack> fluidOutputs = new ArrayList<FluidStack>();
        if (!this.leftOutput.fluid().isEmpty()) {
            fluidOutputs.add(this.leftOutput.fluid());
        }
        if (!this.rightOutput.fluid().isEmpty()) {
            fluidOutputs.add(this.rightOutput.fluid());
        }
        if (!fluidOutputs.isEmpty()) {
            ingredients.setOutputs(VanillaTypes.FLUID, fluidOutputs);
        }
        ArrayList<ItemStack> outputList = new ArrayList<ItemStack>();
        if (!this.leftOutput.item().m_41619_()) {
            outputList.add(this.leftOutput.item());
        }
        if (!this.rightOutput.item().m_41619_()) {
            outputList.add(this.rightOutput.item());
        }
        if (!outputList.isEmpty()) {
            ingredients.setOutputs(VanillaTypes.ITEM, outputList);
        }
    }

    public ItemStack getInputItem() {
        return this.input.item();
    }

    public FluidStack getInputFluid() {
        return this.input.fluid();
    }

    private record StateInfo(ItemStack item, FluidStack fluid) {
        public boolean isEmpty() {
            return this.item.m_41619_() && this.fluid.isEmpty();
        }
    }
}

