/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.jei.collectors;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import moze_intel.projecte.PECore;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.integration.jei.collectors.FuelUpgradeRecipe;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class CollectorRecipeCategory
implements IRecipeCategory<FuelUpgradeRecipe> {
    public static final ResourceLocation UID = PECore.rl("collector");
    private final IDrawable background;
    private final IDrawable arrow;
    private final IDrawable icon;

    public CollectorRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(135, 48);
        this.arrow = guiHelper.drawableBuilder(PECore.rl("textures/gui/arrow.png"), 0, 0, 22, 15).setTextureSize(32, 32).build();
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack(PEBlocks.COLLECTOR));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<FuelUpgradeRecipe> getRecipeClass() {
        return FuelUpgradeRecipe.class;
    }

    @Nonnull
    public Component getTitle() {
        return PELang.JEI_COLLECTOR.translate(new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(@Nonnull FuelUpgradeRecipe o, @Nonnull IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.ITEM, (Object)o.getInput());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)o.getOutput());
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull FuelUpgradeRecipe o, @Nonnull IIngredients ingredients) {
        int itemSlots = 0;
        int xPos = 16;
        for (List s : ingredients.getInputs(VanillaTypes.ITEM)) {
            recipeLayout.getItemStacks().init(itemSlots, true, xPos, 16);
            recipeLayout.getItemStacks().set(itemSlots, s);
            ++itemSlots;
            xPos += 16;
        }
        xPos = 104;
        for (List stacks : ingredients.getOutputs(VanillaTypes.ITEM)) {
            recipeLayout.getItemStacks().init(itemSlots, false, xPos, 16);
            recipeLayout.getItemStacks().set(itemSlots, stacks);
            ++itemSlots;
            xPos += 16;
        }
    }

    public void draw(FuelUpgradeRecipe recipe, @Nonnull PoseStack matrix, double mouseX, double mouseY) {
        TranslatableComponent emc = PELang.EMC.translate(recipe.getUpgradeEMC());
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int stringWidth = fontRenderer.m_92852_((FormattedText)emc);
        fontRenderer.m_92889_(matrix, (Component)emc, (float)(this.getBackground().getWidth() - stringWidth) / 2.0f, 5.0f, 0x808080);
        this.arrow.draw(matrix, 55, 18);
    }
}

