/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.impl.capability;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.event.PlayerKnowledgeChangeEvent;
import moze_intel.projecte.capability.managing.SerializableCapabilityResolver;
import moze_intel.projecte.emc.EMCMappingHandler;
import moze_intel.projecte.emc.nbt.NBTManager;
import moze_intel.projecte.gameObjs.items.Tome;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeSyncChangePKT;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeSyncEmcPKT;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeSyncInputsAndLocksPKT;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeSyncPKT;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public final class KnowledgeImpl {
    public static IKnowledgeProvider getDefault() {
        return new DefaultImpl(null);
    }

    private KnowledgeImpl() {
    }

    private static class DefaultImpl
    implements IKnowledgeProvider {
        @Nullable
        private final Player player;
        private final Set<ItemInfo> knowledge = new HashSet<ItemInfo>();
        private final ItemStackHandler inputLocks = new ItemStackHandler(9);
        private BigInteger emc = BigInteger.ZERO;
        private boolean fullKnowledge = false;

        private DefaultImpl(@Nullable Player player) {
            this.player = player;
        }

        private void fireChangedEvent() {
            if (this.player != null && !this.player.f_19853_.f_46443_) {
                MinecraftForge.EVENT_BUS.post((Event)new PlayerKnowledgeChangeEvent(this.player));
            }
        }

        @Override
        public boolean hasFullKnowledge() {
            return this.fullKnowledge;
        }

        @Override
        public void setFullKnowledge(boolean fullKnowledge) {
            boolean changed = this.fullKnowledge != fullKnowledge;
            this.fullKnowledge = fullKnowledge;
            if (changed) {
                this.fireChangedEvent();
            }
        }

        @Override
        public void clearKnowledge() {
            boolean hasKnowledge = this.fullKnowledge || !this.knowledge.isEmpty();
            this.knowledge.clear();
            this.fullKnowledge = false;
            if (hasKnowledge) {
                this.fireChangedEvent();
            }
        }

        @Nullable
        private ItemInfo getIfPersistent(@Nonnull ItemInfo info) {
            if (!info.hasNBT() || EMCMappingHandler.hasEmcValue(info)) {
                return null;
            }
            ItemInfo cleanedInfo = NBTManager.getPersistentInfo(info);
            if (cleanedInfo.hasNBT() && !EMCMappingHandler.hasEmcValue(cleanedInfo)) {
                return cleanedInfo;
            }
            return null;
        }

        @Override
        public boolean hasKnowledge(@Nonnull ItemInfo info) {
            if (this.fullKnowledge) {
                ItemInfo persistentInfo = this.getIfPersistent(info);
                return persistentInfo == null || this.knowledge.contains(persistentInfo);
            }
            return this.knowledge.contains(NBTManager.getPersistentInfo(info));
        }

        @Override
        public boolean addKnowledge(@Nonnull ItemInfo info) {
            if (this.fullKnowledge) {
                ItemInfo persistentInfo = this.getIfPersistent(info);
                if (persistentInfo == null) {
                    return false;
                }
                return this.tryAdd(persistentInfo);
            }
            if (info.getItem() instanceof Tome) {
                if (info.hasNBT()) {
                    info = ItemInfo.fromItem(info.getItem());
                }
                this.knowledge.add(info);
                this.fullKnowledge = true;
                this.fireChangedEvent();
                return true;
            }
            return this.tryAdd(NBTManager.getPersistentInfo(info));
        }

        private boolean tryAdd(@Nonnull ItemInfo cleanedInfo) {
            if (this.knowledge.add(cleanedInfo)) {
                this.fireChangedEvent();
                return true;
            }
            return false;
        }

        @Override
        public boolean removeKnowledge(@Nonnull ItemInfo info) {
            if (this.fullKnowledge) {
                if (info.getItem() instanceof Tome) {
                    if (info.hasNBT()) {
                        info = ItemInfo.fromItem(info.getItem());
                    }
                    this.knowledge.remove(info);
                    this.fullKnowledge = false;
                    this.fireChangedEvent();
                    return true;
                }
                ItemInfo persistentInfo = this.getIfPersistent(info);
                return persistentInfo != null && this.tryRemove(persistentInfo);
            }
            return this.tryRemove(NBTManager.getPersistentInfo(info));
        }

        private boolean tryRemove(@Nonnull ItemInfo cleanedInfo) {
            if (this.knowledge.remove(cleanedInfo)) {
                this.fireChangedEvent();
                return true;
            }
            return false;
        }

        @Override
        @Nonnull
        public Set<ItemInfo> getKnowledge() {
            if (this.fullKnowledge) {
                Set<ItemInfo> allKnowledge = EMCMappingHandler.getMappedItems();
                allKnowledge.addAll(this.knowledge);
                return Collections.unmodifiableSet(allKnowledge);
            }
            return Collections.unmodifiableSet(this.knowledge);
        }

        @Nonnull
        public IItemHandlerModifiable getInputAndLocks() {
            return this.inputLocks;
        }

        @Override
        public BigInteger getEmc() {
            return this.emc;
        }

        @Override
        public void setEmc(BigInteger emc) {
            this.emc = emc;
        }

        @Override
        public void sync(@Nonnull ServerPlayer player) {
            PacketHandler.sendTo(new KnowledgeSyncPKT(this.serializeNBT()), player);
        }

        @Override
        public void syncEmc(@Nonnull ServerPlayer player) {
            PacketHandler.sendTo(new KnowledgeSyncEmcPKT(this.getEmc()), player);
        }

        @Override
        public void syncKnowledgeChange(@Nonnull ServerPlayer player, ItemInfo change, boolean learned) {
            PacketHandler.sendTo(new KnowledgeSyncChangePKT(change, learned), player);
        }

        @Override
        public void syncInputAndLocks(@Nonnull ServerPlayer player, List<Integer> slotsChanged, IKnowledgeProvider.TargetUpdateType updateTargets) {
            if (!slotsChanged.isEmpty()) {
                int slots = this.inputLocks.getSlots();
                HashMap<Integer, ItemStack> stacksToSync = new HashMap<Integer, ItemStack>();
                for (int slot : slotsChanged) {
                    if (slot < 0 || slot >= slots) continue;
                    stacksToSync.put(slot, this.inputLocks.getStackInSlot(slot));
                }
                if (!stacksToSync.isEmpty()) {
                    PacketHandler.sendTo(new KnowledgeSyncInputsAndLocksPKT(stacksToSync, updateTargets), player);
                }
            }
        }

        @Override
        public void receiveInputsAndLocks(Map<Integer, ItemStack> changes) {
            int slots = this.inputLocks.getSlots();
            for (Map.Entry<Integer, ItemStack> entry : changes.entrySet()) {
                int slot = entry.getKey();
                if (slot < 0 || slot >= slots) continue;
                this.inputLocks.setStackInSlot(slot, entry.getValue());
            }
        }

        public CompoundTag serializeNBT() {
            CompoundTag properties = new CompoundTag();
            properties.m_128359_("transmutationEmc", this.emc.toString());
            ListTag knowledgeWrite = new ListTag();
            for (ItemInfo i : this.knowledge) {
                knowledgeWrite.add((Object)i.write(new CompoundTag()));
            }
            properties.m_128365_("knowledge", (Tag)knowledgeWrite);
            properties.m_128365_("inputlock", (Tag)this.inputLocks.serializeNBT());
            properties.m_128379_("fullknowledge", this.fullKnowledge);
            return properties;
        }

        public void deserializeNBT(CompoundTag properties) {
            int i;
            String transmutationEmc = properties.m_128461_("transmutationEmc");
            this.emc = transmutationEmc.isEmpty() ? BigInteger.ZERO : new BigInteger(transmutationEmc);
            ListTag list = properties.m_128437_("knowledge", 10);
            for (i = 0; i < list.size(); ++i) {
                ItemInfo info = ItemInfo.read(list.m_128728_(i));
                if (info == null) continue;
                this.knowledge.add(info);
            }
            this.pruneStaleKnowledge();
            for (i = 0; i < this.inputLocks.getSlots(); ++i) {
                this.inputLocks.setStackInSlot(i, ItemStack.f_41583_);
            }
            this.inputLocks.deserializeNBT(properties.m_128469_("inputlock"));
            this.fullKnowledge = properties.m_128471_("fullknowledge");
        }

        private void pruneStaleKnowledge() {
            ArrayList<ItemInfo> toRemove = new ArrayList<ItemInfo>();
            ArrayList<ItemInfo> toAdd = new ArrayList<ItemInfo>();
            for (ItemInfo info : this.knowledge) {
                ItemInfo persistentInfo;
                if (!info.equals(persistentInfo = NBTManager.getPersistentInfo(info))) {
                    toRemove.add(info);
                    if (!EMCHelper.doesItemHaveEmc(persistentInfo)) continue;
                    toAdd.add(persistentInfo);
                    continue;
                }
                if (EMCHelper.doesItemHaveEmc(info)) continue;
                toRemove.add(info);
            }
            toRemove.forEach(this.knowledge::remove);
            this.knowledge.addAll(toAdd);
        }
    }

    public static class Provider
    extends SerializableCapabilityResolver<IKnowledgeProvider> {
        public static final ResourceLocation NAME = PECore.rl("knowledge");

        public Provider(Player player) {
            super(new DefaultImpl(player));
        }

        @Override
        @Nonnull
        public Capability<IKnowledgeProvider> getMatchingCapability() {
            return PECapabilities.KNOWLEDGE_CAPABILITY;
        }
    }
}

