/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.impl.capability;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.capabilities.IAlchBagProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.capability.managing.SerializableCapabilityResolver;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.to_client.SyncBagDataPKT;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public final class AlchBagImpl {
    public static IAlchBagProvider getDefault() {
        return new DefaultImpl();
    }

    private AlchBagImpl() {
    }

    private static class DefaultImpl
    implements IAlchBagProvider {
        private final Map<DyeColor, ItemStackHandler> inventories = new EnumMap<DyeColor, ItemStackHandler>(DyeColor.class);

        private DefaultImpl() {
        }

        @Override
        @Nonnull
        public IItemHandler getBag(@Nonnull DyeColor color) {
            if (!this.inventories.containsKey(color)) {
                this.inventories.put(color, new ItemStackHandler(104));
            }
            return (IItemHandler)this.inventories.get(color);
        }

        @Override
        public void sync(@Nullable DyeColor color, @Nonnull ServerPlayer player) {
            PacketHandler.sendTo(new SyncBagDataPKT(this.writeNBT(color)), player);
        }

        private CompoundTag writeNBT(DyeColor color) {
            DyeColor[] colors;
            DyeColor[] dyeColorArray;
            CompoundTag ret = new CompoundTag();
            if (color == null) {
                dyeColorArray = DyeColor.values();
            } else {
                DyeColor[] dyeColorArray2 = new DyeColor[1];
                dyeColorArray = dyeColorArray2;
                dyeColorArray2[0] = color;
            }
            for (DyeColor c : colors = dyeColorArray) {
                if (!this.inventories.containsKey(c)) continue;
                ret.m_128365_(c.m_7912_(), (Tag)this.inventories.get(c).serializeNBT());
            }
            return ret;
        }

        public CompoundTag serializeNBT() {
            return this.writeNBT(null);
        }

        public void deserializeNBT(CompoundTag nbt) {
            for (DyeColor e : DyeColor.values()) {
                if (!nbt.m_128441_(e.m_7912_())) continue;
                ItemStackHandler inv = new ItemStackHandler(104);
                inv.deserializeNBT(nbt.m_128469_(e.m_7912_()));
                this.inventories.put(e, inv);
            }
        }
    }

    public static class Provider
    extends SerializableCapabilityResolver<IAlchBagProvider> {
        public static final ResourceLocation NAME = PECore.rl("alch_bags");

        public Provider() {
            super(AlchBagImpl.getDefault());
        }

        @Override
        @Nonnull
        public Capability<IAlchBagProvider> getMatchingCapability() {
            return PECapabilities.ALCH_BAG_CAPABILITY;
        }
    }
}

