/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.tools;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.capabilities.item.IExtraFunction;
import moze_intel.projecte.api.capabilities.item.IItemCharge;
import moze_intel.projecte.capability.ChargeItemCapabilityWrapper;
import moze_intel.projecte.capability.ExtraFunctionItemCapabilityWrapper;
import moze_intel.projecte.capability.ItemCapability;
import moze_intel.projecte.capability.ItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.EnumMatterType;
import moze_intel.projecte.gameObjs.PETags;
import moze_intel.projecte.gameObjs.items.IBarHelper;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.ToolHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class PESword
extends SwordItem
implements IExtraFunction,
IItemCharge,
IBarHelper {
    private final List<Supplier<ItemCapability<?>>> supportedCapabilities = new ArrayList();
    private final ToolHelper.ChargeAttributeCache attributeCache = new ToolHelper.ChargeAttributeCache();
    private final EnumMatterType matterType;
    private final int numCharges;

    public PESword(EnumMatterType matterType, int numCharges, int damage, Item.Properties props) {
        super((Tier)matterType, damage, -2.4f, props);
        this.matterType = matterType;
        this.numCharges = numCharges;
        this.addItemCapability(ChargeItemCapabilityWrapper::new);
        this.addItemCapability(ExtraFunctionItemCapabilityWrapper::new);
    }

    protected void addItemCapability(Supplier<ItemCapability<?>> capabilitySupplier) {
        this.supportedCapabilities.add(capabilitySupplier);
    }

    public boolean m_8120_(@Nonnull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return 0;
    }

    public boolean m_142522_(@Nonnull ItemStack stack) {
        return true;
    }

    @Override
    public float getWidthForBar(ItemStack stack) {
        return 1.0f - this.getChargePercent(stack);
    }

    public int m_142158_(@Nonnull ItemStack stack) {
        return this.getScaledBarWidth(stack);
    }

    public int m_142159_(@Nonnull ItemStack stack) {
        return this.getColorForBar(stack);
    }

    public float m_8102_(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        float speed = super.m_8102_(stack, state);
        if (speed == 1.0f && state.m_60620_(PETags.Blocks.MINEABLE_WITH_PE_SWORD)) {
            speed = this.matterType.m_6624_();
        }
        return ToolHelper.getDestroySpeed(speed, this.matterType, this.getCharge(stack));
    }

    public boolean isCorrectToolForDrops(@Nonnull ItemStack stack, BlockState state) {
        return state.m_60620_(PETags.Blocks.MINEABLE_WITH_PE_SWORD) && TierSortingRegistry.isCorrectTierForDrops((Tier)this.matterType, (BlockState)state);
    }

    @Override
    public int getNumCharges(@Nonnull ItemStack stack) {
        return this.numCharges;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        if (this.supportedCapabilities.isEmpty()) {
            return super.initCapabilities(stack, nbt);
        }
        return new ItemCapabilityWrapper(stack, this.supportedCapabilities);
    }

    public boolean m_7579_(@Nonnull ItemStack stack, @Nonnull LivingEntity damaged, @Nonnull LivingEntity damager) {
        ToolHelper.attackWithCharge(stack, damaged, damager, 1.0f);
        return true;
    }

    @Nonnull
    public AABB getSweepHitBox(@Nonnull ItemStack stack, @Nonnull Player player, @Nonnull Entity target) {
        int charge = this.getCharge(stack);
        return target.m_142469_().m_82377_((double)charge, (double)charge / 4.0, (double)charge);
    }

    @Override
    public boolean doExtraFunction(@Nonnull ItemStack stack, @Nonnull Player player, InteractionHand hand) {
        if (player.m_36403_(0.0f) == 1.0f) {
            ToolHelper.attackAOE(stack, player, this.slayAll(stack), this.m_43299_(), 0L, hand);
            PlayerHelper.resetCooldown(player);
            return true;
        }
        return false;
    }

    protected boolean slayAll(@Nonnull ItemStack stack) {
        return false;
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@Nonnull EquipmentSlot slot, ItemStack stack) {
        return this.attributeCache.addChargeAttributeModifier((Multimap<Attribute, AttributeModifier>)super.getAttributeModifiers(slot, stack), slot, stack);
    }
}

