/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.tools;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.capability.ModeChangerItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.EnumMatterType;
import moze_intel.projecte.gameObjs.PETags;
import moze_intel.projecte.gameObjs.items.IItemMode;
import moze_intel.projecte.gameObjs.items.tools.PETool;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.ToolHelper;
import moze_intel.projecte.utils.text.ILangEntry;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class PEMorningStar
extends PETool
implements IItemMode {
    private final ToolHelper.ChargeAttributeCache attributeCache = new ToolHelper.ChargeAttributeCache();
    private final ILangEntry[] modeDesc = new ILangEntry[]{PELang.MODE_MORNING_STAR_1, PELang.MODE_MORNING_STAR_2, PELang.MODE_MORNING_STAR_3, PELang.MODE_MORNING_STAR_4};

    public PEMorningStar(EnumMatterType matterType, int numCharges, Item.Properties props) {
        super(matterType, (Tag<Block>)PETags.Blocks.MINEABLE_WITH_PE_MORNING_STAR, 16.0f, -3.0f, numCharges, props);
        this.addItemCapability(ModeChangerItemCapabilityWrapper::new);
    }

    @Override
    public ILangEntry[] getModeLangEntries() {
        return this.modeDesc;
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltips, @Nonnull TooltipFlag flags) {
        super.m_7373_(stack, level, tooltips, flags);
        tooltips.add(this.getToolTip(stack));
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_PICKAXE_ACTIONS.contains(toolAction) || ToolActions.DEFAULT_SHOVEL_ACTIONS.contains(toolAction) || ToolHelper.DEFAULT_PE_HAMMER_ACTIONS.contains(toolAction) || ToolHelper.DEFAULT_PE_MORNING_STAR_ACTIONS.contains(toolAction);
    }

    public boolean m_7579_(@Nonnull ItemStack stack, @Nonnull LivingEntity damaged, @Nonnull LivingEntity damager) {
        ToolHelper.attackWithCharge(stack, damaged, damager, 1.0f);
        return true;
    }

    public boolean m_6813_(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull LivingEntity living) {
        ToolHelper.digBasedOnMode(stack, level, pos, living, (x$0, x$1, x$2) -> Item.m_41435_((Level)x$0, (Player)x$1, (ClipContext.Fluid)x$2));
        return true;
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        InteractionHand hand = context.m_43724_();
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction sideHit = context.m_43719_();
        ItemStack stack = context.m_43722_();
        BlockState state = level.m_8055_(pos);
        return ToolHelper.performActions(ToolHelper.flattenAOE(context, 0L), () -> ToolHelper.dowseCampfire(context, state), () -> {
            if (state.m_60620_((Tag)Tags.Blocks.GRAVEL) || state.m_60734_() == Blocks.f_50129_) {
                if (ProjectEConfig.server.items.pickaxeAoeVeinMining.get()) {
                    return ToolHelper.digAOE(level, player, hand, stack, pos, sideHit, false, 0L);
                }
                return ToolHelper.tryVeinMine(player, stack, pos, sideHit);
            }
            return InteractionResult.PASS;
        }, () -> {
            if (ItemHelper.isOre(state) && !ProjectEConfig.server.items.pickaxeAoeVeinMining.get()) {
                return ToolHelper.tryVeinMine(player, stack, pos, sideHit);
            }
            return InteractionResult.PASS;
        }, () -> ToolHelper.digAOE(level, player, hand, stack, pos, sideHit, !(state.m_60734_() instanceof GrassBlock) && !state.m_60620_((Tag)BlockTags.f_13029_) && !state.m_60620_((Tag)BlockTags.f_144274_), 0L));
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (ProjectEConfig.server.items.pickaxeAoeVeinMining.get()) {
            return ItemHelper.actionResultFromType(ToolHelper.mineOreVeinsInAOE(player, hand), stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @Override
    public float m_8102_(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        return ToolHelper.canMatterMine(this.matterType, state.m_60734_()) ? 1200000.0f : super.m_8102_(stack, state) + 48.0f;
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@Nonnull EquipmentSlot slot, ItemStack stack) {
        return this.attributeCache.addChargeAttributeModifier((Multimap<Attribute, AttributeModifier>)super.getAttributeModifiers(slot, stack), slot, stack);
    }
}

