/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.block_entity.IDMPedestal;
import moze_intel.projecte.api.capabilities.item.IItemCharge;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.capability.ChargeItemCapabilityWrapper;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.IBarHelper;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

public class Zero
extends PEToggleItem
implements IPedestalItem,
IItemCharge,
IBarHelper {
    public Zero(Item.Properties props) {
        super(props);
        this.addItemCapability(PedestalItemCapabilityWrapper::new);
        this.addItemCapability(ChargeItemCapabilityWrapper::new);
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return stack.m_41777_();
    }

    public void m_6883_(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull Entity entity, int slot, boolean held) {
        super.m_6883_(stack, level, entity, slot, held);
        if (!level.f_46443_ && entity instanceof Player && slot < Inventory.m_36059_() && ItemHelper.checkItemNBT(stack, "Active")) {
            AABB box = new AABB(entity.m_20185_() - 3.0, entity.m_20186_() - 3.0, entity.m_20189_() - 3.0, entity.m_20185_() + 3.0, entity.m_20186_() + 3.0, entity.m_20189_() + 3.0);
            WorldHelper.freezeInBoundingBox(level, box, (Player)entity, true);
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_) {
            int offset = 3 + this.getCharge(stack);
            AABB box = player.m_142469_().m_82400_((double)offset);
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)PESoundEvents.POWER.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            WorldHelper.freezeInBoundingBox(level, box, player, false);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    @Override
    public <PEDESTAL extends BlockEntity> boolean updateInPedestal(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull PEDESTAL pedestal) {
        if (!level.f_46443_ && ProjectEConfig.server.cooldown.pedestal.zero.get() != -1) {
            if (((IDMPedestal)pedestal).getActivityCooldown() == 0) {
                AABB aabb = ((IDMPedestal)pedestal).getEffectBounds();
                WorldHelper.freezeInBoundingBox(level, aabb, null, false);
                for (Entity ent : level.m_6443_(Entity.class, aabb, e -> !e.m_5833_() && e.m_6060_())) {
                    ent.m_20095_();
                }
                ((IDMPedestal)pedestal).setActivityCooldown(ProjectEConfig.server.cooldown.pedestal.zero.get());
            } else {
                ((IDMPedestal)pedestal).decrementActivityCooldown();
            }
        }
        return false;
    }

    @Override
    @Nonnull
    public List<Component> getPedestalDescription() {
        ArrayList<Component> list = new ArrayList<Component>();
        if (ProjectEConfig.server.cooldown.pedestal.zero.get() != -1) {
            list.add((Component)PELang.PEDESTAL_ZERO_1.translateColored(ChatFormatting.BLUE, new Object[0]));
            list.add((Component)PELang.PEDESTAL_ZERO_2.translateColored(ChatFormatting.BLUE, new Object[0]));
            list.add((Component)PELang.PEDESTAL_ZERO_3.translateColored(ChatFormatting.BLUE, MathUtils.tickToSecFormatted(ProjectEConfig.server.cooldown.pedestal.zero.get())));
        }
        return list;
    }

    @Override
    public int getNumCharges(@Nonnull ItemStack stack) {
        return 4;
    }

    @Override
    public boolean m_142522_(@Nonnull ItemStack stack) {
        return true;
    }

    @Override
    public float getWidthForBar(ItemStack stack) {
        return 1.0f - this.getChargePercent(stack);
    }

    public int m_142158_(@Nonnull ItemStack stack) {
        return this.getScaledBarWidth(stack);
    }

    public int m_142159_(@Nonnull ItemStack stack) {
        return this.getColorForBar(stack);
    }
}

