/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.block_entity.IDMPedestal;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.api.capabilities.item.IProjectileShooter;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.capability.ProjectileShooterItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.EntitySWRGProjectile;
import moze_intel.projecte.gameObjs.items.IFlightProvider;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.handlers.InternalAbilities;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SWRG
extends ItemPE
implements IPedestalItem,
IFlightProvider,
IProjectileShooter {
    public SWRG(Item.Properties props) {
        super(props);
        this.addItemCapability(PedestalItemCapabilityWrapper::new);
        this.addItemCapability(ProjectileShooterItemCapabilityWrapper::new);
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    private void tick(ItemStack stack, Player player) {
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128451_("Mode") > 1) {
            WorldHelper.repelEntitiesSWRG(player.m_20193_(), player.m_142469_().m_82400_(5.0), player);
        }
        if (player.m_20193_().f_46443_) {
            return;
        }
        ServerPlayer playerMP = (ServerPlayer)player;
        if (SWRG.getEmc(stack) == 0L && !SWRG.consumeFuel(player, stack, 64L, false)) {
            if (nbt.m_128451_("Mode") > 0) {
                this.changeMode(player, stack, 0);
            }
            if (playerMP.m_150110_().f_35936_) {
                playerMP.getCapability(InternalAbilities.CAPABILITY).ifPresent(InternalAbilities::disableSwrgFlightOverride);
            }
            return;
        }
        if (!playerMP.m_150110_().f_35936_) {
            playerMP.getCapability(InternalAbilities.CAPABILITY).ifPresent(InternalAbilities::enableSwrgFlightOverride);
        }
        if (playerMP.m_150110_().f_35935_) {
            if (!this.isFlyingEnabled(nbt)) {
                this.changeMode(player, stack, nbt.m_128451_("Mode") == 0 ? 1 : 3);
            }
        } else if (this.isFlyingEnabled(nbt)) {
            this.changeMode(player, stack, nbt.m_128451_("Mode") == 1 ? 0 : 2);
        }
        float toRemove = 0.0f;
        if (playerMP.m_150110_().f_35935_) {
            toRemove = 0.32f;
        }
        if (nbt.m_128451_("Mode") == 2) {
            toRemove = 0.32f;
        } else if (nbt.m_128451_("Mode") == 3) {
            toRemove = 0.64f;
        }
        SWRG.removeEmc(stack, EMCHelper.removeFractionalEMC(stack, toRemove));
        playerMP.f_19789_ = 0.0f;
    }

    private boolean isFlyingEnabled(CompoundTag nbt) {
        return nbt.m_128451_("Mode") == 1 || nbt.m_128451_("Mode") == 3;
    }

    public void m_6883_(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull Entity entity, int invSlot, boolean isHeldItem) {
        if (invSlot < Inventory.m_36059_() && entity instanceof Player) {
            Player player = (Player)entity;
            this.tick(stack, player);
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_) {
            int newMode = switch (stack.m_41784_().m_128451_("Mode")) {
                case 0 -> 2;
                case 1 -> 3;
                case 2 -> 0;
                case 3 -> 1;
                default -> 0;
            };
            this.changeMode(player, stack, newMode);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void changeMode(Player player, ItemStack stack, int mode) {
        CompoundTag nbt = stack.m_41784_();
        int oldMode = nbt.m_128451_("Mode");
        if (mode == oldMode) {
            return;
        }
        nbt.m_128405_("Mode", mode);
        if (player == null) {
            return;
        }
        if (mode == 0 || oldMode == 3) {
            player.m_20193_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)PESoundEvents.UNCHARGE.get(), SoundSource.PLAYERS, 0.8f, 1.0f);
        } else if (oldMode == 0 || mode == 3) {
            player.m_20193_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)PESoundEvents.HEAL.get(), SoundSource.PLAYERS, 0.8f, 1.0f);
        }
    }

    @Override
    public boolean canProvideFlight(ItemStack stack, ServerPlayer player) {
        return false;
    }

    public boolean m_142522_(@Nonnull ItemStack stack) {
        return false;
    }

    @Override
    public <PEDESTAL extends BlockEntity> boolean updateInPedestal(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull PEDESTAL pedestal) {
        if (!level.f_46443_ && ProjectEConfig.server.cooldown.pedestal.swrg.get() != -1) {
            if (((IDMPedestal)pedestal).getActivityCooldown() <= 0) {
                for (Mob living : level.m_6443_(Mob.class, ((IDMPedestal)pedestal).getEffectBounds(), ent -> {
                    TamableAnimal tamableAnimal;
                    return !ent.m_5833_() && (!(ent instanceof TamableAnimal) || !(tamableAnimal = (TamableAnimal)ent).m_21824_());
                })) {
                    LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(level);
                    if (lightning == null) continue;
                    lightning.m_20219_(living.m_20182_());
                    level.m_7967_((Entity)lightning);
                }
                ((IDMPedestal)pedestal).setActivityCooldown(ProjectEConfig.server.cooldown.pedestal.swrg.get());
            } else {
                ((IDMPedestal)pedestal).decrementActivityCooldown();
            }
        }
        return false;
    }

    @Override
    @Nonnull
    public List<Component> getPedestalDescription() {
        ArrayList<Component> list = new ArrayList<Component>();
        if (ProjectEConfig.server.cooldown.pedestal.swrg.get() != -1) {
            list.add((Component)PELang.PEDESTAL_SWRG_1.translateColored(ChatFormatting.BLUE, new Object[0]));
            list.add((Component)PELang.PEDESTAL_SWRG_2.translateColored(ChatFormatting.BLUE, MathUtils.tickToSecFormatted(ProjectEConfig.server.cooldown.pedestal.swrg.get())));
        }
        return list;
    }

    @Override
    public boolean shootProjectile(@Nonnull Player player, @Nonnull ItemStack stack, @Nullable InteractionHand hand) {
        EntitySWRGProjectile projectile = new EntitySWRGProjectile(player, false, player.f_19853_);
        projectile.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
        player.f_19853_.m_7967_((Entity)projectile);
        return true;
    }
}

