/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.block_entity.IDMPedestal;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.api.capabilities.item.IProjectileShooter;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.capability.ProjectileShooterItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.EntityFireProjectile;
import moze_intel.projecte.gameObjs.items.IFireProtector;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class Ignition
extends PEToggleItem
implements IPedestalItem,
IFireProtector,
IProjectileShooter {
    public Ignition(Item.Properties props) {
        super(props);
        this.addItemCapability(PedestalItemCapabilityWrapper::new);
        this.addItemCapability(ProjectileShooterItemCapabilityWrapper::new);
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    public void m_6883_(@Nonnull ItemStack stack, Level level, @Nonnull Entity entity, int inventorySlot, boolean held) {
        if (level.f_46443_ || inventorySlot >= Inventory.m_36059_() || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        super.m_6883_(stack, level, entity, inventorySlot, held);
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128471_("Active")) {
            if (Ignition.getEmc(stack) == 0L && !Ignition.consumeFuel(player, stack, 64L, false)) {
                nbt.m_128379_("Active", false);
            } else {
                WorldHelper.igniteNearby(level, player);
                Ignition.removeEmc(stack, EMCHelper.removeFractionalEMC(stack, 0.32f));
            }
        } else {
            WorldHelper.extinguishNearby(level, player);
        }
    }

    @Nonnull
    public InteractionResult m_6225_(@Nonnull UseOnContext ctx) {
        return WorldHelper.igniteBlock(ctx);
    }

    @Override
    public <PEDESTAL extends BlockEntity> boolean updateInPedestal(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull PEDESTAL pedestal) {
        if (!level.f_46443_ && ProjectEConfig.server.cooldown.pedestal.ignition.get() != -1) {
            if (((IDMPedestal)pedestal).getActivityCooldown() == 0) {
                for (Mob living : level.m_45976_(Mob.class, ((IDMPedestal)pedestal).getEffectBounds())) {
                    living.m_6469_(DamageSource.f_19305_, 3.0f);
                    living.m_20254_(8);
                }
                ((IDMPedestal)pedestal).setActivityCooldown(ProjectEConfig.server.cooldown.pedestal.ignition.get());
            } else {
                ((IDMPedestal)pedestal).decrementActivityCooldown();
            }
        }
        return false;
    }

    @Override
    @Nonnull
    public List<Component> getPedestalDescription() {
        ArrayList<Component> list = new ArrayList<Component>();
        if (ProjectEConfig.server.cooldown.pedestal.ignition.get() != -1) {
            list.add((Component)PELang.PEDESTAL_IGNITION_1.translateColored(ChatFormatting.BLUE, new Object[0]));
            list.add((Component)PELang.PEDESTAL_IGNITION_2.translateColored(ChatFormatting.BLUE, MathUtils.tickToSecFormatted(ProjectEConfig.server.cooldown.pedestal.ignition.get())));
        }
        return list;
    }

    @Override
    public boolean shootProjectile(@Nonnull Player player, @Nonnull ItemStack stack, InteractionHand hand) {
        Level level = player.m_20193_();
        if (level.f_46443_) {
            return false;
        }
        EntityFireProjectile fire = new EntityFireProjectile(player, false, level);
        fire.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
        level.m_7967_((Entity)fire);
        return true;
    }

    @Override
    public boolean canProtectAgainstFire(ItemStack stack, ServerPlayer player) {
        return true;
    }
}

