/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.block_entity.IDMPedestal;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.handlers.InternalTimers;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;

public class BodyStone
extends PEToggleItem
implements IPedestalItem {
    public BodyStone(Item.Properties props) {
        super(props);
        this.addItemCapability(PedestalItemCapabilityWrapper::new);
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    public void m_6883_(@Nonnull ItemStack stack, Level level, @Nonnull Entity entity, int slot, boolean held) {
        if (level.f_46443_ || slot >= Inventory.m_36059_() || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        super.m_6883_(stack, level, entity, slot, held);
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128471_("Active")) {
            long itemEmc = BodyStone.getEmc(stack);
            if (itemEmc < 64L && !BodyStone.consumeFuel(player, stack, 64L, false)) {
                nbt.m_128379_("Active", false);
            } else {
                player.getCapability(InternalTimers.CAPABILITY, null).ifPresent(timers -> {
                    timers.activateFeed();
                    if (player.m_36324_().m_38721_() && timers.canFeed()) {
                        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)PESoundEvents.HEAL.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        player.m_36324_().m_38707_(2, 10.0f);
                        level.m_142346_((Entity)player, GameEvent.f_157806_, player.m_146901_());
                        player.m_146850_(GameEvent.f_157806_);
                        BodyStone.removeEmc(stack, 64L);
                    }
                });
            }
        }
    }

    @Override
    public <PEDESTAL extends BlockEntity> boolean updateInPedestal(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull PEDESTAL pedestal) {
        if (!level.f_46443_ && ProjectEConfig.server.cooldown.pedestal.body.get() != -1) {
            if (((IDMPedestal)pedestal).getActivityCooldown() == 0) {
                for (ServerPlayer player : level.m_45976_(ServerPlayer.class, ((IDMPedestal)pedestal).getEffectBounds())) {
                    if (!player.m_36324_().m_38721_()) continue;
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)PESoundEvents.HEAL.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    player.m_36324_().m_38707_(1, 1.0f);
                }
                ((IDMPedestal)pedestal).setActivityCooldown(ProjectEConfig.server.cooldown.pedestal.body.get());
            } else {
                ((IDMPedestal)pedestal).decrementActivityCooldown();
            }
        }
        return false;
    }

    @Override
    @Nonnull
    public List<Component> getPedestalDescription() {
        ArrayList<Component> list = new ArrayList<Component>();
        if (ProjectEConfig.server.cooldown.pedestal.body.get() != -1) {
            list.add((Component)PELang.PEDESTAL_BODY_STONE_1.translateColored(ChatFormatting.BLUE, new Object[0]));
            list.add((Component)PELang.PEDESTAL_BODY_STONE_2.translateColored(ChatFormatting.BLUE, MathUtils.tickToSecFormatted(ProjectEConfig.server.cooldown.pedestal.body.get())));
        }
        return list;
    }
}

