/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.capabilities.item.IExtraFunction;
import moze_intel.projecte.api.capabilities.item.IProjectileShooter;
import moze_intel.projecte.capability.ExtraFunctionItemCapabilityWrapper;
import moze_intel.projecte.capability.ModeChangerItemCapabilityWrapper;
import moze_intel.projecte.capability.ProjectileShooterItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.entity.EntityFireProjectile;
import moze_intel.projecte.gameObjs.entity.EntitySWRGProjectile;
import moze_intel.projecte.gameObjs.items.IFireProtector;
import moze_intel.projecte.gameObjs.items.IFlightProvider;
import moze_intel.projecte.gameObjs.items.IItemMode;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.ILangEntry;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class Arcana
extends ItemPE
implements IItemMode,
IFlightProvider,
IFireProtector,
IExtraFunction,
IProjectileShooter {
    private static final ILangEntry[] modes = new ILangEntry[]{PELang.MODE_ARCANA_1, PELang.MODE_ARCANA_2, PELang.MODE_ARCANA_3, PELang.MODE_ARCANA_4};

    public Arcana(Item.Properties props) {
        super(props);
        this.addItemCapability(ExtraFunctionItemCapabilityWrapper::new);
        this.addItemCapability(ProjectileShooterItemCapabilityWrapper::new);
        this.addItemCapability(ModeChangerItemCapabilityWrapper::new);
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return stack.m_41777_();
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> list) {
        if (this.m_41389_(group)) {
            for (byte i = 0; i < this.getModeCount(); i = (byte)(i + 1)) {
                ItemStack stack = new ItemStack((ItemLike)this);
                stack.m_41784_().m_128344_("Mode", i);
                list.add((Object)stack);
            }
        }
    }

    @Override
    public ILangEntry[] getModeLangEntries() {
        return modes;
    }

    private void tick(ItemStack stack, Level level, ServerPlayer player) {
        if (ItemHelper.checkItemNBT(stack, "Active")) {
            switch (this.getMode(stack)) {
                case 0: {
                    WorldHelper.freezeInBoundingBox(level, player.m_142469_().m_82400_(5.0), (Player)player, true);
                    break;
                }
                case 1: {
                    WorldHelper.igniteNearby(level, (Player)player);
                    break;
                }
                case 2: {
                    WorldHelper.growNearbyRandomly(true, level, player.m_142538_(), (Player)player);
                    break;
                }
                case 3: {
                    WorldHelper.repelEntitiesSWRG(level, player.m_142469_().m_82400_(5.0), (Player)player);
                }
            }
        }
    }

    public void m_6883_(@Nonnull ItemStack stack, Level level, @Nonnull Entity entity, int slot, boolean held) {
        if (!level.f_46443_ && slot < Inventory.m_36059_() && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            this.tick(stack, level, player);
        }
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltips, @Nonnull TooltipFlag flags) {
        super.m_7373_(stack, level, tooltips, flags);
        if (ItemHelper.checkItemNBT(stack, "Active")) {
            tooltips.add(this.getToolTip(stack));
        } else {
            tooltips.add((Component)PELang.TOOLTIP_ARCANA_INACTIVE.translateColored(ChatFormatting.RED, new Object[0]));
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        if (!level.f_46443_) {
            CompoundTag compound;
            compound.m_128379_("Active", !(compound = player.m_21120_(hand).m_41784_()).m_128471_("Active"));
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext ctx) {
        InteractionResult result;
        if (this.getMode(ctx.m_43722_()) == 1 && (result = WorldHelper.igniteBlock(ctx)) != InteractionResult.PASS) {
            return result;
        }
        return super.m_6225_(ctx);
    }

    @Override
    public boolean doExtraFunction(@Nonnull ItemStack stack, @Nonnull Player player, InteractionHand hand) {
        Level level = player.m_20193_();
        if (level.f_46443_) {
            return true;
        }
        if (this.getMode(stack) == 1) {
            switch (player.m_6350_()) {
                case SOUTH: 
                case NORTH: {
                    for (BlockPos pos : BlockPos.m_121940_((BlockPos)player.m_142538_().m_142082_(-30, -5, -3), (BlockPos)player.m_142538_().m_142082_(30, 5, 3))) {
                        if (!level.m_46859_(pos)) continue;
                        PlayerHelper.checkedPlaceBlock((ServerPlayer)player, pos.m_7949_(), Blocks.f_50083_.m_49966_());
                    }
                    break;
                }
                case WEST: 
                case EAST: {
                    for (BlockPos pos : BlockPos.m_121940_((BlockPos)player.m_142538_().m_142082_(-3, -5, -30), (BlockPos)player.m_142538_().m_142082_(3, 5, 30))) {
                        if (!level.m_46859_(pos)) continue;
                        PlayerHelper.checkedPlaceBlock((ServerPlayer)player, pos.m_7949_(), Blocks.f_50083_.m_49966_());
                    }
                    break;
                }
            }
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)PESoundEvents.POWER.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return true;
    }

    @Override
    public boolean shootProjectile(@Nonnull Player player, @Nonnull ItemStack stack, InteractionHand hand) {
        Level level = player.m_20193_();
        if (level.f_46443_) {
            return false;
        }
        switch (this.getMode(stack)) {
            case 0: {
                Snowball snowball = new Snowball(level, (LivingEntity)player);
                snowball.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
                level.m_7967_((Entity)snowball);
                snowball.m_5496_(SoundEvents.f_12473_, 1.0f, 1.0f);
                break;
            }
            case 1: {
                EntityFireProjectile fire = new EntityFireProjectile(player, true, level);
                fire.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
                level.m_7967_((Entity)fire);
                fire.m_5496_((SoundEvent)PESoundEvents.POWER.get(), 1.0f, 1.0f);
                break;
            }
            case 3: {
                EntitySWRGProjectile lightning = new EntitySWRGProjectile(player, true, level);
                lightning.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
                level.m_7967_((Entity)lightning);
            }
        }
        return true;
    }

    @Override
    public boolean canProtectAgainstFire(ItemStack stack, ServerPlayer player) {
        return true;
    }

    @Override
    public boolean canProvideFlight(ItemStack stack, ServerPlayer player) {
        return true;
    }
}

